set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530250';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      0.750721,
      3,
      0.326188,
      0,
      0,
      2.537200,
      NULL,
      '401',
      NULL,
      NULL,
      38,
      '3122124',
      0.559262,
      1,
      0,
      NULL,
      NULL,
      0.748549,
      1.051666,
      NULL,
      NULL,
      NULL,
      38,
      32.034762,
      NULL,
      2,
      2,
      ' 4-18-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 0-18-2003',
      NULL,
      NULL,
      2,
      2.173059,
      3,
      3.836807,
      NULL,
      1,
      NULL,
      1,
      NULL,
      22.885814,
      8,
      4.021894,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      3.288845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      4,
      1.850747,
      4,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      5,
      5,
      3,
      0,
      6.311367,
      0,
      1,
      2,
      1,
      0.911261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      3.499318,
      3.628397,
      0,
      1.059385,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      1.224174,
      2,
      NULL,
      3.450732,
      1.847811,
      3.090849,
      1.824109,
      1,
      0,
      0,
      7,
      0,
      1,
      1.503968,
      0.758837,
      NULL,
      NULL,
      0.373183,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      4,
      1,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1.619839,
      NULL,
      1,
      1,
      1,
      4,
      0,
      0,
      0,
      3,
      2,
      0,
      5,
      0,
      0,
      NULL,
      0,
      1,
      1,
      4,
      2,
      3,
      0,
      4,
      3,
      5,
      1,
      0,
      NULL,
      0.472815,
      ' 7-11-1987',
      622.835858,
      ' 3- 5-1996',
      NULL,
      3.650142,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750476,
      0.543125,
      3,
      1,
      NULL,
      3,
      0.148570,
      NULL,
      NULL,
      NULL,
      NULL,
      5.829894,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.768813,
      0.619803,
      1,
      NULL,
      1.676132,
      5,
      3,
      1.479579,
      NULL,
      NULL,
      NULL,
      0,
      1.944032,
      3.744609,
      NULL,
      3,
      2,
      2,
      1,
      3,
      2,
      1,
      2,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1.903645,
      1,
      1,
      0.803563,
      1.674128,
      0,
      0,
      1,
      NULL,
      3.448011,
      NULL,
      1,
      6,
      3.640725,
      5.823021,
      11,
      NULL,
      1,
      0.869144,
      7.915832,
      NULL,
      1,
      3,
      15.616187,
      2,
      NULL,
      47,
      NULL,
      NULL,
      77.758597,
      1,
      3,
      2,
      '41122',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      2.238188,
      16.060884,
      NULL,
      32.316877,
      2,
      45,
      8,
      0,
      5,
      3.820712,
      NULL,
      2.131847,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424413,
      NULL,
      NULL,
      1.768650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014837,
      2.426151,
      2.150154,
      NULL,
      0.491823,
      0,
      0.182758,
      1.245683,
      3.221941,
      0.317737,
      NULL,
      NULL,
      1,
      2.563921,
      NULL,
      1,
      3,
      5.012130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348886,
      NULL,
      NULL,
      NULL,
      2.343302,
      2,
      0,
      2.524268,
      2.905462,
      NULL,
      1,
      1,
      3.729002,
      NULL,
      0,
      1.171005,
      0.660354,
      NULL,
      NULL,
      NULL,
      3,
      2.243792,
      3.894447,
      NULL,
      1,
      0.586526,
      0.851089,
      2.859609,
      1,
      0.758543,
      NULL,
      NULL,
      1.278588,
      NULL,
      NULL,
      1,
      0,
      0.242895,
      9,
      NULL,
      4,
      0,
      0.892756,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.737489,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252626,
      NULL,
      NULL,
      0.922192,
      0,
      NULL,
      NULL,
      NULL,
      1.175718,
      4.974569,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.089351,
      NULL,
      NULL,
      1.239959,
      NULL,
      NULL,
      NULL,
      0.557127,
      NULL,
      0.319650,
      0.895010,
      3.462846,
      2.042603,
      0,
      6.844610,
      1.151375,
      NULL,
      9.299022,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      0,
      2.538020,
      8.953245,
      5,
      3.014772,
      2,
      0,
      1,
      NULL,
      1.725897,
      3,
      3,
      NULL,
      3.192683,
      2.492384,
      1.872296,
      NULL,
      9.767232,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      0,
      1,
      1.860678,
      0.137168,
      0.870179,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.642509,
      NULL,
      NULL,
      1.773020,
      NULL,
      NULL,
      0.037591,
      NULL,
      NULL,
      1.975095,
      NULL,
      NULL,
      1.974536,
      NULL,
      NULL,
      1.952325,
      NULL,
      NULL,
      0.868267,
      1,
      2.187221,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.931132,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.504691,
      NULL,
      NULL,
      NULL,
      1.488853,
      NULL,
      NULL,
      NULL,
      0.924892,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700455,
      NULL,
      NULL,
      NULL,
      1.214552,
      NULL,
      NULL,
      NULL,
      2,
      3.764254,
      2,
      0,
      1.107634,
      NULL,
      NULL,
      NULL,
      9,
      3,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.213741,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      NULL,
      0.734515,
      NULL,
      0,
      0,
      1.976383,
      0.565076,
      0.265080,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.656971,
      1.225396,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      7.813349,
      2.611566,
      0.083051,
      2,
      0,
      8,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      3.354900,
      NULL,
      1.538231,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.851757,
      1,
      NULL,
      1,
      0.417338,
      NULL,
      0,
      1.303529,
      NULL,
      0.905725,
      2,
      NULL,
      1,
      0.471719,
      NULL,
      NULL,
      1.987791,
      NULL,
      NULL,
      0.502913,
      NULL,
      2,
      1.869061,
      1.995425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562309,
      NULL,
      1.111742,
      NULL,
      0.364540,
      NULL,
      NULL,
      3,
      5,
      2,
      NULL,
      3.343039,
      24.366380,
      82.556671,
      NULL,
      0.250750,
      0,
      '10430',
      '',
      '',
      0.171882,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


