set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8430555';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '1301444',
      1.314526,
      NULL,
      2,
      2,
      '2142',
      1,
      0.410417,
      NULL,
      NULL,
      ' 6-14-1994',
      NULL,
      NULL,
      0,
      NULL,
      1.172989,
      ' 4- 6-1982',
      NULL,
      4.992951,
      NULL,
      57,
      3,
      ' 6-17-1976',
      ' 8-25-1997',
      ' 6- 1-1997',
      1.312197,
      1.174845,
      0.876920,
      1.696567,
      0,
      3.248639,
      NULL,
      0,
      0.089635,
      NULL,
      7,
      15,
      7.369399,
      NULL,
      62,
      0,
      11.469968,
      0,
      3,
      4,
      1,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.635939,
      1,
      181,
      1,
      2,
      5,
      2.332818,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.443611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      1.947245,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      3,
      0,
      NULL,
      1,
      3,
      4,
      NULL,
      0,
      0,
      3,
      2,
      3,
      0,
      4,
      3,
      3,
      NULL,
      NULL,
      1.963325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      1,
      2,
      2,
      2.624481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.078227,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      7.031228,
      0,
      NULL,
      NULL,
      0.338527,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.279344,
      1.492452,
      NULL,
      3,
      0.813962,
      NULL,
      0.536870,
      19458,
      1.910127,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.758757,
      1,
      1,
      3,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2.863208,
      2.543589,
      4,
      6,
      NULL,
      1.510175,
      NULL,
      1.219174,
      0,
      NULL,
      1,
      0.167212,
      NULL,
      0.429543,
      0,
      0,
      0.850937,
      2.318873,
      NULL,
      1,
      2,
      2.923102,
      0,
      3.486305,
      3.025096,
      NULL,
      NULL,
      7.630524,
      NULL,
      2,
      0,
      51,
      NULL,
      NULL,
      NULL,
      32,
      5,
      25,
      NULL,
      0.674495,
      NULL,
      '33314',
      '14224',
      '',
      NULL,
      '34242',
      NULL,
      '',
      1,
      '32440',
      '13024',
      NULL,
      3.932164,
      NULL,
      NULL,
      1.687491,
      2,
      0.477440,
      6,
      NULL,
      3,
      1.047718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.971879,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.182624,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.194853,
      NULL,
      NULL,
      1.829620,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.024874,
      NULL,
      NULL,
      0.830780,
      NULL,
      NULL,
      0.923459,
      NULL,
      NULL,
      NULL,
      NULL,
      7.752810,
      NULL,
      1.952946,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.546729,
      1.717873,
      2.181988,
      2.475197,
      1,
      1.393759,
      NULL,
      NULL,
      0,
      0.378475,
      2.269289,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1.884471,
      0.583082,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.376663,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277121,
      NULL,
      NULL,
      NULL,
      2.865974,
      2,
      NULL,
      NULL,
      2,
      0,
      1,
      1.534255,
      3.579441,
      1,
      NULL,
      NULL,
      6,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.453763,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.338731,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.944089,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.951265,
      NULL,
      3,
      NULL,
      0.157328,
      0,
      2,
      3,
      2,
      NULL,
      3.116146,
      3,
      1,
      2,
      0.904503,
      1,
      6,
      3,
      1.631309,
      2,
      NULL,
      1,
      1.390574,
      NULL,
      NULL,
      0.896121,
      2,
      1.784038,
      3,
      2.499136,
      1.981573,
      6.848391,
      3,
      NULL,
      NULL,
      1,
      0.898237,
      0,
      3,
      0.276727,
      0.944956,
      0.935919,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.796981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.722817,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.192889,
      NULL,
      NULL,
      3.448425,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0.509036,
      1.612446,
      1,
      NULL,
      NULL,
      0.805200,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.997971,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161379,
      0.560446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253663,
      0.807162,
      NULL,
      NULL,
      1,
      1.741165,
      NULL,
      NULL,
      0.924620,
      NULL,
      NULL,
      NULL,
      1.962406,
      1,
      NULL,
      NULL,
      NULL,
      3.423617,
      NULL,
      NULL,
      3,
      0.022199,
      NULL,
      NULL,
      1,
      14.645156,
      3,
      2,
      1.881382,
      NULL,
      154.516530,
      0,
      NULL,
      341,
      1.917357,
      NULL,
      NULL,
      NULL,
      561.469213,
      6,
      3,
      681.915090,
      1556,
      0,
      NULL,
      NULL,
      3.390532,
      42,
      2.969778,
      18356.904840,
      63,
      1,
      0.814919,
      1,
      NULL,
      0.932351,
      1.319259,
      0,
      2,
      1.985668,
      NULL,
      NULL,
      0.647219,
      1.363190,
      0,
      0,
      0,
      1.747978,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.740974,
      NULL,
      2.996060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.974225,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.420797,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.657954,
      NULL,
      0,
      NULL,
      0.025189,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.019722,
      NULL,
      1.517513,
      1.779631,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.533733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.913320,
      NULL,
      0.134259,
      NULL,
      1.410447,
      NULL,
      NULL,
      NULL,
      0.976183,
      NULL,
      1.774825,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.345961,
      0,
      1.852907,
      0,
      0.480751,
      0.954468,
      0.711804,
      0,
      1.799285,
      0.144293,
      0.956099,
      0.852792,
      1,
      0.470869,
      0,
      1,
      1,
      1.441402,
      1.580936,
      0.126466,
      0,
      1,
      3,
      NULL,
      NULL,
      1,
      2.154036,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.798630,
      NULL,
      0,
      0.081825,
      1.752261,
      3,
      0.269876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602032,
      1.986025,
      1.373754,
      0,
      0,
      0,
      3,
      NULL,
      0,
      3,
      NULL,
      0.944378,
      67.515665,
      26.596219,
      1,
      0.686268,
      NULL,
      '14210',
      '34222',
      NULL,
      5.692505,
      '14223',
      '31003',
      '',
      7.033122,
      '0143',
      '04411',
      '10402');
commit;
end;
/


