set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9884735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      NULL,
      1,
      5,
      5.376357,
      7,
      2.291404,
      '110',
      '41241044',
      36.744613,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2,
      '0141',
      5.973213,
      0.631215,
      NULL,
      NULL,
      ' 2- 2-1975',
      91,
      50,
      NULL,
      2.786164,
      1,
      ' 2-21-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 7-22-1975',
      ' 8-28-1980',
      ' 2- 4-1978',
      1,
      3,
      2.306945,
      NULL,
      1,
      3,
      3,
      NULL,
      0.084848,
      0,
      5,
      19,
      3.614076,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.164831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      4,
      NULL,
      1,
      1,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      0,
      9.748580,
      0,
      1,
      0,
      1,
      0.227457,
      NULL,
      NULL,
      0.748321,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.251895,
      1.783349,
      3,
      1.524403,
      0,
      2.278866,
      0.604330,
      1.106439,
      0,
      NULL,
      1.754015,
      1.391921,
      0.410413,
      0,
      1,
      NULL,
      3,
      3.078447,
      0,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      4,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      4,
      1,
      1.399898,
      NULL,
      0,
      0,
      0,
      1.179772,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      4,
      0,
      NULL,
      3,
      0,
      2,
      4,
      0,
      0,
      3,
      NULL,
      1,
      3,
      5,
      0,
      0,
      7,
      2.869920,
      ' 0- 7-1979',
      221.668878,
      NULL,
      101,
      3,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0,
      3,
      0.411639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      11,
      0.669748,
      3.589553,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.938538,
      1,
      NULL,
      0.083079,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.502221,
      0.049196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541370,
      NULL,
      0.192021,
      1.245044,
      1,
      1,
      1.095235,
      1,
      6.819770,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.536936,
      0.661400,
      2,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      6,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128980,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.055029,
      0.474882,
      0,
      21,
      2,
      0,
      28,
      NULL,
      56,
      NULL,
      3,
      1,
      3.808576,
      '32110',
      '',
      '',
      0.646399,
      NULL,
      '',
      '',
      1.830980,
      '',
      '',
      NULL,
      NULL,
      17,
      38,
      30,
      1.114906,
      NULL,
      NULL,
      NULL,
      NULL,
      2.599611,
      2,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2.362283,
      NULL,
      NULL,
      NULL,
      1.232216,
      NULL,
      NULL,
      NULL,
      3,
      1.510083,
      1,
      0.905633,
      3,
      3.219458,
      3.299065,
      NULL,
      3,
      NULL,
      3,
      1.799343,
      1,
      3.932061,
      1.467287,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      1.486076,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.523187,
      0,
      1,
      0.525688,
      NULL,
      NULL,
      1.913227,
      1,
      0,
      1,
      1.120004,
      0.814220,
      NULL,
      3,
      1,
      2.787093,
      NULL,
      0.613798,
      0,
      1,
      3,
      0.150833,
      3.064024,
      3,
      NULL,
      1.074235,
      NULL,
      NULL,
      1.815651,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.283877,
      NULL,
      NULL,
      0,
      3,
      3.104526,
      1,
      NULL,
      NULL,
      1.578537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      4.174646,
      4,
      0.603202,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509291,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1.367742,
      NULL,
      3,
      0.563830,
      NULL,
      0,
      NULL,
      2,
      0,
      2.562581,
      2.612545,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.554122,
      6,
      7.470608,
      2,
      2,
      1,
      1.341725,
      NULL,
      0.763708,
      3,
      3,
      3,
      3,
      NULL,
      3.025322,
      3,
      NULL,
      NULL,
      2.711873,
      3.840837,
      6.573973,
      2.623861,
      2,
      0,
      1.931945,
      NULL,
      0,
      0.529158,
      0.485820,
      2.217556,
      NULL,
      NULL,
      1.991716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306399,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.421918,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.661949,
      NULL,
      NULL,
      3.563898,
      NULL,
      NULL,
      2.022927,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      130.783989,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.500901,
      NULL,
      NULL,
      NULL,
      0.695615,
      NULL,
      NULL,
      NULL,
      1.628212,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.329115,
      NULL,
      NULL,
      NULL,
      0.860084,
      NULL,
      NULL,
      NULL,
      2.118645,
      NULL,
      NULL,
      NULL,
      1.399642,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.224928,
      NULL,
      NULL,
      NULL,
      NULL,
      38.097688,
      6,
      2.867071,
      6.846429,
      1.608494,
      1.728005,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.163967,
      NULL,
      NULL,
      1.123281,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      8,
      0.332440,
      NULL,
      0.807942,
      1.814207,
      0.659431,
      1.134077,
      1.507793,
      0,
      0.633499,
      1,
      1.149371,
      NULL,
      0.652226,
      0.838772,
      1.811886,
      1.392327,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      6.563299,
      0,
      5.320190,
      0,
      3.441417,
      0.585658,
      3.257653,
      0.381778,
      NULL,
      NULL,
      3.635187,
      NULL,
      2.499617,
      NULL,
      NULL,
      1.622868,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      0.150516,
      1.157775,
      NULL,
      1,
      2.797892,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.716027,
      NULL,
      1.478941,
      NULL,
      NULL,
      4,
      4,
      3.115558,
      0.248638,
      0,
      60,
      95,
      NULL,
      5.392438,
      0,
      '34403',
      '',
      NULL,
      1.123907,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


