set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9884735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.166959,
      0.352929,
      1,
      1.590996,
      5.492395,
      0,
      1,
      3,
      '030',
      '20321142',
      25,
      83.421191,
      '4414444',
      NULL,
      NULL,
      3,
      NULL,
      '0144',
      0,
      0.340174,
      NULL,
      NULL,
      ' 1-19-1985',
      177.662376,
      8.382306,
      NULL,
      3.419398,
      0.459227,
      ' 2- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 2-27-1977',
      2,
      1,
      1.201940,
      1.915800,
      1,
      2,
      NULL,
      0.531426,
      1,
      NULL,
      7,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      7,
      0,
      4,
      1,
      NULL,
      1,
      1,
      1,
      0,
      3,
      0,
      3,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.448292,
      NULL,
      1.383718,
      NULL,
      NULL,
      0.527760,
      3.108811,
      3,
      1,
      1.290609,
      0.846176,
      1.717602,
      1.233738,
      3.841543,
      3.384540,
      NULL,
      0,
      1,
      3,
      6,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      0.792352,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      5,
      NULL,
      5,
      0,
      0,
      NULL,
      0,
      0,
      0,
      4.469197,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      3,
      0,
      3,
      4,
      1,
      0,
      0,
      NULL,
      3,
      0,
      5,
      NULL,
      1,
      1,
      2,
      2,
      4,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.384238,
      ' 2- 0-1986',
      271.327213,
      ' 6-11-1992',
      68,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623432,
      6,
      1.032909,
      1.761144,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.338358,
      0.987262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.002845,
      0,
      1.653988,
      0.225795,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      7.267949,
      NULL,
      0.477235,
      NULL,
      NULL,
      1.340398,
      1.049590,
      1.298906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      10.361588,
      NULL,
      3.488536,
      0,
      7,
      NULL,
      NULL,
      NULL,
      62.588146,
      3,
      0.070373,
      81,
      NULL,
      NULL,
      NULL,
      2,
      5.422709,
      3.534668,
      '33142',
      '',
      '',
      0.504855,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      38.931686,
      104.997690,
      33,
      1,
      21,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0.724458,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.939438,
      3.455163,
      0.161626,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.859009,
      3.002770,
      2,
      2,
      2.655627,
      0.696018,
      0,
      NULL,
      1,
      1.360086,
      1.969869,
      1.949821,
      1.871477,
      2.680271,
      NULL,
      1,
      NULL,
      NULL,
      8,
      4.787426,
      6,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.447405,
      3,
      2,
      1.522560,
      NULL,
      NULL,
      0.567995,
      NULL,
      3,
      2.804806,
      1,
      0.586953,
      NULL,
      3,
      1.224700,
      2,
      3,
      NULL,
      1.463037,
      NULL,
      1,
      1.192218,
      2,
      2.563851,
      0.391279,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.872527,
      0,
      2,
      7,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.903052,
      NULL,
      0.550587,
      NULL,
      NULL,
      0.515827,
      NULL,
      NULL,
      NULL,
      5,
      2.602358,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.407856,
      0,
      2,
      0,
      NULL,
      NULL,
      0.149399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.942891,
      0.279796,
      0.617458,
      NULL,
      3.064672,
      1,
      NULL,
      NULL,
      2.237550,
      NULL,
      1,
      0.952183,
      2,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.187979,
      NULL,
      0,
      NULL,
      2.849511,
      NULL,
      0,
      NULL,
      3,
      1.783646,
      2.953285,
      2,
      3.236641,
      4.601403,
      3,
      3,
      NULL,
      0,
      6,
      2,
      2,
      1,
      0,
      0,
      1.243510,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.246360,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      6.566949,
      NULL,
      NULL,
      0.300102,
      1,
      1,
      1,
      1,
      1.702068,
      0,
      NULL,
      NULL,
      5.244058,
      NULL,
      NULL,
      NULL,
      107.001696,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.428013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.670204,
      NULL,
      NULL,
      NULL,
      1.147697,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.506994,
      NULL,
      NULL,
      NULL,
      1.417657,
      NULL,
      NULL,
      NULL,
      0.864538,
      NULL,
      NULL,
      NULL,
      0.773379,
      NULL,
      NULL,
      NULL,
      0.640645,
      NULL,
      NULL,
      NULL,
      1.297241,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.237579,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.407272,
      14.868230,
      0,
      2.928369,
      11.215371,
      1.336030,
      1.755188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.706744,
      NULL,
      0,
      0.812266,
      12.195838,
      1.130864,
      0.506471,
      0,
      0,
      1,
      1.011437,
      1.964683,
      0.403809,
      1,
      0.244879,
      1.772605,
      1,
      1.537336,
      1,
      NULL,
      1.128147,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      NULL,
      3,
      0,
      2.828147,
      3,
      NULL,
      0,
      1.113304,
      NULL,
      0,
      0,
      NULL,
      1.290254,
      NULL,
      NULL,
      0.224221,
      0,
      NULL,
      0.156034,
      3.435217,
      NULL,
      NULL,
      3,
      NULL,
      1.618015,
      1.689297,
      NULL,
      NULL,
      3,
      NULL,
      3.455269,
      0.589872,
      NULL,
      0,
      NULL,
      NULL,
      2.119297,
      1,
      1.491507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.043033,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      2.001644,
      1,
      NULL,
      40.663081,
      NULL,
      1,
      0.098765,
      3,
      '21401',
      '',
      '',
      1.306442,
      '',
      '',
      '',
      0.396505,
      '',
      '',
      '');
commit;
end;
/


