set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902014';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '2212221',
      2,
      0.752823,
      4,
      1,
      '2331',
      NULL,
      1,
      NULL,
      NULL,
      ' 3-29-1978',
      143,
      NULL,
      0,
      1,
      NULL,
      '11- 9-2003',
      NULL,
      4,
      95,
      58,
      3,
      ' 0- 8-1987',
      ' 5- 0-1994',
      ' 7-10-1991',
      0,
      NULL,
      1,
      0,
      1.925297,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      4.578513,
      6.266813,
      3,
      7.658965,
      4,
      2,
      8.194643,
      NULL,
      0,
      1,
      1,
      NULL,
      0.993412,
      0,
      0.019814,
      NULL,
      1.776437,
      NULL,
      3,
      2,
      0,
      3,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.049792,
      2.314314,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      0.951678,
      1.849977,
      3.264643,
      NULL,
      1.450535,
      NULL,
      1.538897,
      NULL,
      1,
      0,
      0,
      1,
      1,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      2,
      0,
      NULL,
      0,
      0.150642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      1.244499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211840,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.011833,
      3.783612,
      3.268348,
      2,
      NULL,
      1,
      NULL,
      4,
      1,
      4.705477,
      2.002321,
      0.555544,
      1.664877,
      NULL,
      NULL,
      1,
      1.686822,
      0.985988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.453084,
      1.150275,
      NULL,
      1.022417,
      1,
      1,
      0.930407,
      NULL,
      3,
      1.018840,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0,
      0,
      0,
      NULL,
      3,
      2,
      3,
      1,
      2,
      1,
      3.794937,
      NULL,
      16,
      2.832143,
      NULL,
      0.504566,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0.709737,
      1,
      1.048330,
      0,
      1,
      1,
      1,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      5.226418,
      3.756395,
      0.124734,
      NULL,
      3,
      0,
      1,
      59,
      NULL,
      3,
      NULL,
      50,
      NULL,
      39,
      4,
      NULL,
      4.337276,
      '42311',
      '21222',
      '',
      1.091990,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      52.809418,
      NULL,
      0.011344,
      4.671341,
      2,
      4.886550,
      NULL,
      1.747980,
      NULL,
      NULL,
      1.806906,
      NULL,
      NULL,
      1.187620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298045,
      NULL,
      NULL,
      0.573576,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.346434,
      NULL,
      NULL,
      0.050413,
      NULL,
      NULL,
      0.874682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0.320403,
      NULL,
      NULL,
      1.694200,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.015434,
      1.183584,
      3,
      1.904219,
      0,
      1,
      1.193863,
      2,
      1.473646,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.376160,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.058448,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.595396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824130,
      NULL,
      NULL,
      0.999912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.696346,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.366567,
      0.952909,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.976459,
      2.361560,
      1.071324,
      NULL,
      NULL,
      4.156584,
      NULL,
      0,
      NULL,
      0.237273,
      NULL,
      0.098422,
      0.748916,
      0,
      1.225127,
      NULL,
      NULL,
      0.138553,
      NULL,
      NULL,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.444440,
      0,
      1,
      0,
      0.318425,
      0,
      1.736710,
      0.274497,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.986348,
      0.242833,
      0,
      NULL,
      0.809852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871072,
      1,
      2.136677,
      0.689205,
      NULL,
      NULL,
      0.747516,
      NULL,
      NULL,
      1.923212,
      NULL,
      0,
      136,
      4.937445,
      1.566430,
      1,
      0.735120,
      0,
      0.422335,
      0,
      1,
      2,
      0,
      0.577394,
      0.724178,
      2.407054,
      1.165567,
      0.170751,
      0,
      NULL,
      1,
      1.607632,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.796508,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      44,
      NULL,
      NULL,
      14.951796,
      19.785349,
      NULL,
      2.123638,
      3.017962,
      NULL,
      0,
      NULL,
      0.445404,
      NULL,
      1.939555,
      NULL,
      0.538291,
      NULL,
      1.523365,
      NULL,
      1.433288,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.917935,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.790918,
      NULL,
      3.118409,
      NULL,
      1.687609,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1.912748,
      NULL,
      1,
      0.046558,
      1.822314,
      0.678550,
      1.229149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.537231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.534686,
      0,
      NULL,
      1.004456,
      0,
      0.080428,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.046239,
      0.632044,
      0.942687,
      0,
      0.934179,
      1.768798,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.993968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.468779,
      0.115075,
      0.986187,
      3.913934,
      0.622464,
      2.246137,
      NULL,
      NULL,
      1.508002,
      1.535716,
      0.886022,
      0,
      0,
      0,
      1.189680,
      3.449384,
      4.572279,
      34,
      1,
      1.881819,
      1.873030,
      0.385827,
      0,
      NULL,
      NULL,
      5.038678,
      3.278878,
      0,
      3,
      1,
      0.549902,
      3.400284,
      0.956140,
      0.670847,
      0.775018,
      1,
      NULL,
      0.637937,
      0.880230,
      NULL,
      1.657152,
      1.072564,
      NULL,
      1,
      1,
      NULL,
      0.725292,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1.948587,
      0.253978,
      NULL,
      0.891904,
      0,
      NULL,
      0,
      1.882255,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      1,
      NULL,
      NULL,
      95.458257,
      NULL,
      3,
      0,
      4.274198,
      '20312',
      '24413',
      '',
      1,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


