set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9616418';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      1.650501,
      0.335628,
      3,
      3,
      '3402',
      2,
      NULL,
      NULL,
      NULL,
      ' 2-16-1994',
      3.033216,
      NULL,
      1,
      1.742153,
      0.186668,
      ' 8-23-1994',
      9,
      0.068105,
      175,
      1.821011,
      0,
      '11- 7-2002',
      NULL,
      ' 4-10-2001',
      2,
      NULL,
      0.144579,
      0,
      0.722845,
      3,
      3,
      0,
      0.099087,
      NULL,
      3,
      NULL,
      5.205847,
      NULL,
      7,
      0,
      13.892513,
      5,
      1,
      NULL,
      1,
      1,
      1,
      1.830074,
      NULL,
      0.275223,
      NULL,
      1.190173,
      NULL,
      1.410266,
      1.334782,
      3,
      5,
      4,
      2,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.926811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.162648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      4,
      1,
      0,
      0,
      4,
      1,
      1,
      NULL,
      0.469485,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      5,
      0,
      1,
      3,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      2,
      0,
      4,
      1,
      1,
      1,
      3,
      2,
      4,
      1,
      0,
      0,
      NULL,
      2,
      ' 4- 7-2003',
      139,
      ' 4- 9-1993',
      9,
      2.813032,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.085459,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.893980,
      1.848988,
      1.105220,
      1.781360,
      NULL,
      NULL,
      3.569015,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.194456,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      2.342686,
      0.592122,
      0.499267,
      3,
      NULL,
      1,
      1,
      0.287581,
      NULL,
      0.829527,
      NULL,
      0.825134,
      0,
      1.998701,
      NULL,
      0,
      1,
      NULL,
      NULL,
      7.156866,
      NULL,
      4.630569,
      1.845445,
      5,
      7.134141,
      4.355969,
      2.237505,
      NULL,
      2,
      0.691738,
      1.113132,
      19,
      2,
      1,
      NULL,
      NULL,
      19,
      57,
      4,
      NULL,
      3,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0.971436,
      '',
      '',
      '',
      0,
      0.366793,
      60,
      38,
      3.713427,
      12,
      3,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.495791,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.425636,
      NULL,
      NULL,
      1.588776,
      NULL,
      NULL,
      1.619048,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119510,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.440055,
      NULL,
      NULL,
      1.165957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.895232,
      NULL,
      NULL,
      1.447899,
      NULL,
      NULL,
      0.079224,
      NULL,
      NULL,
      0.621882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.681639,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.909087,
      0,
      NULL,
      NULL,
      3,
      1.638333,
      3.048407,
      4.996032,
      1.013799,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.740652,
      NULL,
      NULL,
      0.394005,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.625937,
      0,
      5.460046,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.088848,
      NULL,
      NULL,
      0.248014,
      NULL,
      NULL,
      0,
      3.786927,
      0,
      NULL,
      2.477683,
      1.901849,
      1,
      3.735942,
      3.251621,
      NULL,
      1.543905,
      1.383325,
      NULL,
      0.167557,
      3,
      1.699464,
      0.301914,
      1,
      1,
      NULL,
      1.974979,
      4.868754,
      2,
      0.075149,
      1,
      NULL,
      NULL,
      NULL,
      4,
      3,
      3,
      0.938589,
      2,
      2,
      1.754512,
      0.942688,
      7.234835,
      NULL,
      NULL,
      47.775364,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.694679,
      NULL,
      NULL,
      0.924490,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.102051,
      NULL,
      NULL,
      3.299567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      6.944915,
      NULL,
      0.014562,
      1.007939,
      1.739043,
      0,
      1,
      0.660403,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.298237,
      NULL,
      2.234843,
      3.415924,
      3.658108,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.316360,
      0,
      NULL,
      NULL,
      NULL,
      0.058858,
      NULL,
      1,
      NULL,
      0.123561,
      1.286969,
      0.533646,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1.703561,
      NULL,
      1.952419,
      0.747843,
      1.294445,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      8.477920,
      NULL,
      0.821805,
      2.538781,
      1,
      0.961014,
      2.331489,
      0.459137,
      NULL,
      1.756831,
      0,
      NULL,
      0,
      1,
      NULL,
      0.316317,
      1,
      NULL,
      0.286711,
      1.234035,
      NULL,
      1.167413,
      NULL,
      NULL,
      3,
      2.020388,
      NULL,
      0.013081,
      0.074975,
      NULL,
      3,
      3,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.490835,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363386,
      NULL,
      1.136734,
      NULL,
      0.734721,
      NULL,
      3,
      NULL,
      7,
      2,
      1,
      NULL,
      57.771570,
      14,
      NULL,
      1.517405,
      2,
      '10403',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.664605,
      '',
      '',
      '');
commit;
end;
/


