set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '3001024',
      NULL,
      NULL,
      0,
      0,
      '0440',
      NULL,
      0,
      NULL,
      NULL,
      ' 3- 2-1983',
      NULL,
      NULL,
      5,
      1.638015,
      1,
      ' 8- 1-1985',
      30.862358,
      1.979610,
      109,
      199.513284,
      2,
      NULL,
      NULL,
      ' 5-15-1998',
      NULL,
      1.646498,
      1.933867,
      0.593127,
      1.325873,
      2.684880,
      3,
      2,
      NULL,
      NULL,
      NULL,
      6,
      3,
      3,
      20.206064,
      3,
      14,
      0,
      0,
      6,
      0,
      2,
      0,
      NULL,
      1,
      0,
      0,
      3.382537,
      0,
      NULL,
      0,
      NULL,
      4,
      4,
      3.101047,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      4,
      NULL,
      3,
      4,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.757123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      4,
      1,
      NULL,
      NULL,
      1,
      4,
      1,
      0,
      0,
      1,
      0.180049,
      NULL,
      NULL,
      2,
      5,
      0,
      1,
      1,
      2,
      4,
      4,
      1,
      0,
      1,
      3,
      2,
      1,
      1,
      1,
      NULL,
      1,
      3,
      NULL,
      0,
      3,
      NULL,
      2,
      1,
      3,
      3,
      ' 2-27-1990',
      196,
      ' 2- 8-1996',
      NULL,
      1.505254,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.029815,
      1.334832,
      NULL,
      NULL,
      NULL,
      0,
      5.225245,
      0.674490,
      1,
      1,
      NULL,
      1.030362,
      NULL,
      NULL,
      NULL,
      0,
      0.531870,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0.740185,
      1.392280,
      0.965707,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.794156,
      0,
      3,
      0,
      2,
      0,
      NULL,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.080637,
      1.469405,
      NULL,
      1.991073,
      0,
      0,
      0.522237,
      0.685821,
      1,
      0.090086,
      0,
      0,
      NULL,
      NULL,
      9.003763,
      3,
      5.817933,
      0.819399,
      11,
      0,
      2.875525,
      NULL,
      4.230805,
      0.008969,
      0,
      NULL,
      5.157215,
      2,
      1.714253,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.662496,
      NULL,
      '',
      '',
      0.660219,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      19,
      59.271485,
      8,
      NULL,
      6.752509,
      NULL,
      1,
      NULL,
      3,
      1.870565,
      0.930026,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.571521,
      NULL,
      NULL,
      1.016311,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.323460,
      1,
      1.381468,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.115334,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383762,
      NULL,
      2.116492,
      NULL,
      3.022685,
      0,
      1.768801,
      2.921564,
      0,
      0,
      0,
      NULL,
      NULL,
      3.692202,
      NULL,
      1.735008,
      0,
      1,
      0,
      NULL,
      2.946545,
      NULL,
      1,
      1.663481,
      NULL,
      NULL,
      0,
      0.204734,
      0,
      0.947534,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.234429,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      1.855858,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0.480084,
      0.010590,
      1,
      1.499257,
      NULL,
      3.497592,
      0.812917,
      2.022996,
      0,
      NULL,
      NULL,
      5,
      5.728649,
      5.329056,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.813933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.329790,
      NULL,
      NULL,
      1,
      0.052631,
      1.776674,
      NULL,
      NULL,
      1.597808,
      0,
      2.517039,
      0.969316,
      1.769166,
      1,
      5,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.904039,
      2,
      0,
      NULL,
      4.720501,
      4.490830,
      3,
      0.550611,
      0.451176,
      2,
      1.424619,
      0.806002,
      2,
      1.471625,
      0.098375,
      2,
      0,
      18,
      4.998774,
      0,
      1.389576,
      0,
      NULL,
      NULL,
      0,
      3,
      2,
      1,
      1,
      1,
      0.592003,
      0.389650,
      NULL,
      NULL,
      NULL,
      1.361304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970398,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.404522,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.890718,
      NULL,
      NULL,
      0.284964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.650108,
      3.084300,
      0.636024,
      0,
      0,
      0.837160,
      0,
      NULL,
      6.830931,
      NULL,
      NULL,
      NULL,
      1.702991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.905651,
      NULL,
      NULL,
      1.176035,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.492073,
      0.135352,
      NULL,
      NULL,
      0,
      0.325308,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.829199,
      NULL,
      NULL,
      2.673749,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321797,
      NULL,
      NULL,
      NULL,
      2.305245,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.054307,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.903038,
      0,
      NULL,
      NULL,
      2.885346,
      4,
      NULL,
      NULL,
      NULL,
      0.600920,
      NULL,
      NULL,
      NULL,
      2.292949,
      31.637971,
      NULL,
      1,
      14.247503,
      NULL,
      1.119964,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.515272,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856660,
      NULL,
      1.316167,
      0,
      1,
      0,
      1.389572,
      NULL,
      NULL,
      NULL,
      1.681908,
      1.949048,
      3,
      NULL,
      1,
      0.097492,
      NULL,
      1.165324,
      0,
      0.183890,
      3,
      NULL,
      0.180839,
      NULL,
      0.706580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.779326,
      NULL,
      0.111523,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501634,
      0.134932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.760058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.172283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.845254,
      1.260186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231667,
      NULL,
      NULL,
      0.325910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.024098,
      0.139500,
      21,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.494398,
      1,
      1,
      9.784526,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1.749948,
      NULL,
      NULL,
      0.698635,
      NULL,
      NULL,
      1.687514,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      1,
      2,
      NULL,
      0,
      1.151934,
      NULL,
      1,
      0,
      NULL,
      0.713998,
      0.494785,
      NULL,
      1.621747,
      0,
      NULL,
      1.997027,
      1,
      1.002109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.605640,
      NULL,
      0.695179,
      NULL,
      0.543082,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.381059,
      NULL,
      NULL,
      NULL,
      0.583599,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.182153,
      NULL,
      1,
      NULL,
      NULL,
      1.257024,
      699,
      1.271181,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.659844,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      '01244',
      '44241',
      '',
      0,
      '',
      '',
      '',
      1.851752,
      '',
      '',
      '');
commit;
end;
/


