set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '4210431',
      1,
      0.445706,
      2,
      3,
      '0220',
      NULL,
      0,
      NULL,
      NULL,
      ' 1-12-1997',
      28,
      NULL,
      1,
      2,
      7.890372,
      ' 4-18-1978',
      NULL,
      2,
      122.950563,
      165,
      1,
      NULL,
      NULL,
      ' 8- 7-2002',
      2,
      1,
      1.732788,
      NULL,
      1.732494,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.858371,
      2,
      NULL,
      0.855022,
      5,
      12,
      1,
      3,
      0,
      0.182287,
      NULL,
      0,
      0,
      NULL,
      0,
      0.972414,
      2.270374,
      NULL,
      NULL,
      1.349378,
      NULL,
      NULL,
      4,
      2.560183,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      3,
      2,
      3,
      1,
      0,
      5.606884,
      2,
      1,
      NULL,
      0,
      1.643527,
      NULL,
      NULL,
      0.016220,
      NULL,
      NULL,
      2,
      3,
      0,
      0.571060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      NULL,
      3,
      1,
      1,
      0,
      3,
      3,
      3,
      NULL,
      1,
      4.553616,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      0,
      5,
      4,
      NULL,
      5,
      2,
      0,
      0,
      NULL,
      1,
      1,
      3,
      2,
      4,
      5,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.995348,
      NULL,
      NULL,
      ' 4-27-1995',
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      4.282237,
      1,
      1.092930,
      0,
      0,
      4,
      1.558869,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.626893,
      2,
      1,
      NULL,
      0.499076,
      NULL,
      0,
      1.958070,
      NULL,
      2,
      0.940310,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.058550,
      NULL,
      0,
      1,
      2,
      1,
      1,
      3,
      2,
      3,
      2,
      3.298037,
      NULL,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.536289,
      1.108123,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      4,
      NULL,
      5.672911,
      3,
      2,
      0,
      7.580959,
      0,
      3.578000,
      1.336837,
      59.051265,
      3,
      1.979426,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.111451,
      1,
      NULL,
      '',
      '',
      0.888991,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.099746,
      20,
      58,
      NULL,
      3,
      24.564581,
      1.664256,
      1.009387,
      1,
      1,
      0.855615,
      2.950604,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.889585,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.598078,
      0,
      0,
      0,
      NULL,
      1.519306,
      NULL,
      NULL,
      3,
      2.665108,
      0.713684,
      1.127669,
      0.703479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      4,
      1,
      1.095449,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      2.806358,
      NULL,
      0.112296,
      1,
      1.537860,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1.513405,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      3,
      0.863335,
      1.497431,
      NULL,
      NULL,
      NULL,
      0.576373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.071734,
      1.250164,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.262675,
      3.479206,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.829908,
      2.226945,
      3,
      0,
      2.228322,
      0.831845,
      0,
      9.417985,
      3,
      5,
      3,
      NULL,
      3.053810,
      0.226139,
      0,
      1.951261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.035446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3.952209,
      6,
      4.119142,
      5,
      2.953357,
      2.888843,
      7.191625,
      NULL,
      NULL,
      NULL,
      0.601207,
      NULL,
      NULL,
      2.682910,
      2.780582,
      0,
      0.141159,
      0.608724,
      1.083333,
      NULL,
      3.464624,
      2.627928,
      0.154209,
      0.117073,
      0,
      3,
      0,
      NULL,
      3,
      2,
      3,
      NULL,
      2.481003,
      1.373659,
      9,
      4,
      7.069779,
      1,
      3.241590,
      5.223704,
      3,
      1,
      1,
      0.976170,
      NULL,
      0,
      1.271243,
      0.623718,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815433,
      NULL,
      NULL,
      0.673086,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.465854,
      NULL,
      NULL,
      0.674513,
      NULL,
      NULL,
      0.283592,
      NULL,
      1,
      NULL,
      2,
      0.720930,
      1,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0.012973,
      1,
      NULL,
      NULL,
      3.224645,
      2.532785,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.410450,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.482376,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.240440,
      NULL,
      NULL,
      NULL,
      0.258977,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.601687,
      NULL,
      NULL,
      1.552319,
      2,
      NULL,
      NULL,
      1.623243,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0.200427,
      NULL,
      NULL,
      3.590395,
      2.284032,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.372797,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3.282722,
      1.541063,
      NULL,
      NULL,
      NULL,
      2,
      2,
      27,
      2,
      8.981973,
      NULL,
      0.806130,
      NULL,
      NULL,
      0.151393,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.132312,
      NULL,
      1,
      1494,
      0.248049,
      1,
      NULL,
      0,
      1,
      0,
      0.735740,
      NULL,
      1.851513,
      1.248471,
      1.997785,
      NULL,
      1,
      0,
      1.885193,
      1,
      0,
      0,
      NULL,
      NULL,
      0.852344,
      NULL,
      1.202760,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.196317,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.927751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504322,
      1.588770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.740315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986653,
      0.593467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522645,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608420,
      NULL,
      NULL,
      NULL,
      NULL,
      3.665024,
      NULL,
      98,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.784487,
      1,
      0,
      NULL,
      16.071387,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      1,
      1.163634,
      0,
      NULL,
      3.936511,
      1.075209,
      1.561814,
      1.164786,
      0.159956,
      0.666859,
      NULL,
      1.361872,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.413876,
      NULL,
      NULL,
      3,
      NULL,
      0.608599,
      NULL,
      NULL,
      1.509218,
      0.141530,
      NULL,
      NULL,
      0.396560,
      NULL,
      1,
      0.631952,
      NULL,
      1.826585,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      3,
      NULL,
      2.940949,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.713757,
      NULL,
      3.007174,
      NULL,
      1.254126,
      NULL,
      2,
      NULL,
      1.449198,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      65,
      1.859432,
      NULL,
      0,
      NULL,
      1.523141,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      86.536943,
      2,
      1,
      5.417057,
      '23144',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


