set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      2.248729,
      1.549540,
      3,
      NULL,
      '3142',
      0,
      1.777348,
      NULL,
      NULL,
      ' 4-28-1997',
      29,
      NULL,
      5,
      0,
      0.200829,
      ' 8- 1-1985',
      40,
      2,
      289.979990,
      209.665774,
      5,
      NULL,
      NULL,
      ' 2-13-1986',
      2.931684,
      1.872034,
      0.335741,
      1.237854,
      1,
      0,
      NULL,
      2.288775,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      193,
      55.740355,
      1,
      18.804384,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.617197,
      0,
      2,
      NULL,
      1.075233,
      2,
      5,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.234772,
      3.042963,
      0.546237,
      1.421407,
      0.877246,
      NULL,
      0.825855,
      0,
      0.489845,
      0,
      0,
      0.483192,
      1,
      1.627262,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1.114467,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      3,
      2,
      2,
      0,
      3.239273,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      2,
      1,
      4,
      2,
      4,
      3,
      2,
      4,
      2,
      3,
      3,
      1,
      3,
      4,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      2,
      2,
      1,
      0,
      ' 9- 0-1997',
      NULL,
      '11- 0-1983',
      201,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0.717861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518006,
      1,
      1.452879,
      0,
      9.220229,
      0,
      NULL,
      NULL,
      NULL,
      0.017234,
      0.745746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919709,
      3,
      NULL,
      1.661689,
      NULL,
      1,
      0.003369,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      1,
      3,
      3,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.104572,
      0,
      0.366413,
      0,
      1.089749,
      NULL,
      3,
      0.949907,
      NULL,
      0,
      1,
      NULL,
      0.566384,
      0.698827,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      NULL,
      NULL,
      NULL,
      3,
      1.402023,
      2,
      '20322',
      NULL,
      '',
      1.378098,
      '',
      NULL,
      '',
      1.549821,
      '',
      '',
      '',
      NULL,
      22,
      31.426834,
      35.523778,
      2,
      42.855624,
      2.560062,
      NULL,
      5,
      3.449069,
      0,
      0.658338,
      1.092419,
      NULL,
      NULL,
      1.972352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.054686,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.669259,
      1.236996,
      2,
      3.724165,
      0,
      1,
      1,
      1.477959,
      0,
      1,
      0.118155,
      1.243776,
      NULL,
      1.242028,
      0.398080,
      NULL,
      1.722242,
      1,
      0.501488,
      1,
      1.967559,
      NULL,
      0.564014,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.725596,
      0.241632,
      NULL,
      0.294135,
      0.932891,
      NULL,
      NULL,
      NULL,
      1.056849,
      0.348903,
      1.716043,
      1,
      1,
      0,
      0.202908,
      1.917117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403719,
      NULL,
      NULL,
      8.832869,
      1.215840,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.461030,
      1.029052,
      NULL,
      NULL,
      3,
      3,
      0,
      1.594659,
      1.491540,
      1.262303,
      1,
      NULL,
      NULL,
      NULL,
      2,
      5.806605,
      NULL,
      0,
      0,
      1.592815,
      0.937491,
      NULL,
      NULL,
      0.990503,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937461,
      NULL,
      NULL,
      0.657121,
      NULL,
      NULL,
      0.409163,
      NULL,
      NULL,
      1.001557,
      NULL,
      NULL,
      2.063630,
      0.315916,
      0,
      2,
      1,
      NULL,
      4.796261,
      NULL,
      0,
      10.918197,
      NULL,
      6,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.155859,
      2,
      NULL,
      2.570292,
      6.012201,
      1.825403,
      8.695992,
      3,
      0.566519,
      3,
      1.129606,
      NULL,
      NULL,
      0.618500,
      0.425979,
      2.630976,
      0.317898,
      3,
      1,
      7,
      4,
      4.700244,
      11.223909,
      2.535161,
      7.681090,
      1,
      1,
      4,
      1,
      0.048366,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.237379,
      NULL,
      NULL,
      1.421642,
      NULL,
      1,
      NULL,
      0.491250,
      0.252534,
      0.686516,
      NULL,
      4,
      1,
      NULL,
      NULL,
      2.477107,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.342845,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.357905,
      NULL,
      NULL,
      2,
      1.948065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629221,
      NULL,
      NULL,
      NULL,
      NULL,
      1.340726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.255725,
      3.029805,
      NULL,
      NULL,
      1.570840,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.954355,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      7.463368,
      NULL,
      NULL,
      NULL,
      3.883547,
      1,
      NULL,
      NULL,
      NULL,
      2.612555,
      17,
      NULL,
      2.206099,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.049657,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      16803,
      NULL,
      NULL,
      0.302100,
      NULL,
      1.764981,
      1.359846,
      0.948192,
      1,
      1,
      0.550299,
      0.940387,
      1,
      2.794303,
      0.963261,
      NULL,
      0.293949,
      0,
      1.550646,
      0,
      NULL,
      1.855728,
      NULL,
      1.564221,
      NULL,
      0.652884,
      NULL,
      0.352420,
      NULL,
      0,
      NULL,
      1.512525,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.065250,
      0.827232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893070,
      1.203808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228747,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284546,
      1.535725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.629645,
      NULL,
      1.450403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.960557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      2.995030,
      0,
      2.798416,
      2,
      6,
      NULL,
      1,
      1.855321,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947365,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.632379,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.864169,
      NULL,
      0,
      0.040000,
      NULL,
      3.622041,
      0.488917,
      1.013304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069501,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      5,
      0.154029,
      NULL,
      NULL,
      35,
      48.483608,
      0,
      0,
      3.013483,
      '44103',
      '',
      '',
      0.613091,
      '',
      '',
      '',
      1.389613,
      '',
      '',
      '');
commit;
end;
/


