set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      0.091870,
      0,
      2,
      '1201',
      3.521672,
      1,
      NULL,
      NULL,
      ' 7-24-1977',
      13,
      NULL,
      NULL,
      2.243044,
      1.028603,
      '10-24-1990',
      28,
      1,
      NULL,
      135.221597,
      1,
      NULL,
      '11-20-1987',
      ' 4- 5-1985',
      NULL,
      0.224623,
      NULL,
      0.322717,
      0.706377,
      2.742382,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      18,
      3,
      8.965181,
      2,
      1,
      4.854912,
      NULL,
      0,
      0,
      NULL,
      1.829255,
      1.433465,
      1,
      1,
      1.300536,
      0,
      0,
      1,
      3,
      NULL,
      3,
      NULL,
      0,
      2,
      0,
      NULL,
      3,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      2,
      1.682502,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      0.820305,
      1.588891,
      0,
      NULL,
      NULL,
      1,
      3,
      0.807711,
      NULL,
      0,
      1.172648,
      2,
      1.929013,
      0,
      2.985241,
      1,
      3,
      1,
      0,
      NULL,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4,
      5,
      5,
      0,
      0,
      4,
      3,
      NULL,
      1,
      2,
      NULL,
      4,
      4,
      1,
      2,
      1,
      0,
      NULL,
      5,
      0,
      4,
      NULL,
      9.105660,
      2.461858,
      ' 7-21-2000',
      28,
      ' 9- 2-1994',
      85,
      3.771573,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      1,
      0.115213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843799,
      NULL,
      0,
      NULL,
      1,
      0.810035,
      0.129328,
      1,
      0,
      5.599448,
      5,
      5,
      1.034380,
      NULL,
      NULL,
      0.621871,
      0.160598,
      0.176267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.630426,
      1,
      1,
      1.664243,
      0,
      0.039091,
      1,
      2,
      NULL,
      NULL,
      1.450840,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      3,
      2,
      1,
      3,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      1.666698,
      3,
      NULL,
      NULL,
      1.751231,
      0,
      0,
      0.963081,
      NULL,
      1,
      NULL,
      1,
      0.048150,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4.981732,
      NULL,
      NULL,
      5.504278,
      NULL,
      4.260614,
      NULL,
      NULL,
      2.391418,
      8,
      2,
      1.058544,
      NULL,
      50,
      33,
      36,
      NULL,
      NULL,
      2,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.279762,
      '',
      '',
      '',
      0,
      NULL,
      62.906454,
      42.536505,
      2.864581,
      34,
      7.878565,
      0,
      1,
      NULL,
      2.034066,
      2,
      1.193873,
      NULL,
      NULL,
      NULL,
      1,
      1.337847,
      0,
      NULL,
      NULL,
      1.280226,
      NULL,
      NULL,
      2,
      NULL,
      2.829681,
      1,
      NULL,
      NULL,
      1.647455,
      2.416050,
      NULL,
      1.412800,
      3.444106,
      0,
      1.840810,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      3.112263,
      6,
      4.084873,
      0,
      0.446281,
      NULL,
      NULL,
      NULL,
      0.669410,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0.501229,
      0.006980,
      0,
      2,
      1.131337,
      1,
      0,
      NULL,
      1.805871,
      NULL,
      1,
      2,
      1.900282,
      1.288115,
      2,
      1.025011,
      1,
      0.301199,
      0.456499,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11,
      1,
      NULL,
      1,
      1.784262,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.151390,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521906,
      NULL,
      NULL,
      2,
      3.682678,
      0,
      0,
      NULL,
      NULL,
      0,
      5,
      2.487463,
      3.584460,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.565725,
      1.715597,
      0,
      NULL,
      2.415760,
      3,
      0.644194,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309564,
      NULL,
      NULL,
      2.671508,
      1,
      0,
      1.769536,
      NULL,
      1.416926,
      2.491162,
      2.220402,
      2,
      2.269161,
      6.707032,
      NULL,
      1.598648,
      2.898874,
      2.538391,
      3.967256,
      3.868334,
      3.521032,
      1,
      NULL,
      NULL,
      0,
      1,
      0.750959,
      6.987059,
      5.261682,
      4,
      8,
      7,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.807019,
      0,
      0.934841,
      NULL,
      NULL,
      0.113606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520334,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.043753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.592035,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.682633,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0.991692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685438,
      NULL,
      NULL,
      NULL,
      0.154347,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.255560,
      NULL,
      NULL,
      NULL,
      0.792550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570082,
      NULL,
      NULL,
      NULL,
      1.757191,
      NULL,
      NULL,
      NULL,
      1.755089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      35.415999,
      6,
      1,
      NULL,
      NULL,
      0.549084,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.279732,
      8,
      0.980584,
      3.791331,
      1.553286,
      1,
      0.747326,
      1,
      1,
      0.028468,
      1,
      NULL,
      NULL,
      0.552353,
      NULL,
      1.064832,
      1,
      0.958144,
      0.411631,
      2,
      NULL,
      1.166016,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.339093,
      NULL,
      1,
      NULL,
      79.396496,
      NULL,
      0.969302,
      NULL,
      28.930717,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.881420,
      NULL,
      NULL,
      NULL,
      0.360625,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.672292,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.670120,
      NULL,
      1,
      2.765695,
      1,
      0.096150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940860,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000162,
      1.243574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551766,
      0.296489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.322057,
      NULL,
      0.136952,
      NULL,
      NULL,
      NULL,
      0.769458,
      NULL,
      0.224605,
      NULL,
      1,
      0.491560,
      0.150794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      7.866500,
      1.279657,
      2.912139,
      1.857315,
      0,
      11.732764,
      2.842222,
      NULL,
      0,
      2.061885,
      3,
      NULL,
      1,
      0,
      NULL,
      0.368101,
      1.971132,
      NULL,
      1,
      2,
      NULL,
      0,
      2.082746,
      NULL,
      1.141080,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.100971,
      2.103502,
      NULL,
      2,
      1,
      1.090590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      42,
      72,
      NULL,
      5.534300,
      0.423813,
      '33012',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.154098,
      '',
      NULL,
      '');
commit;
end;
/


