set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '4234410',
      NULL,
      0.294603,
      NULL,
      1,
      '0012',
      1.886172,
      0,
      NULL,
      NULL,
      ' 3- 1-1975',
      NULL,
      NULL,
      4,
      2.797096,
      2.715988,
      NULL,
      46,
      3,
      143,
      115.505832,
      2,
      ' 9-10-1974',
      ' 7- 8-1987',
      NULL,
      3.618197,
      NULL,
      0,
      1.303258,
      1.245337,
      1.563011,
      NULL,
      3.220153,
      NULL,
      NULL,
      NULL,
      5.090296,
      0.866121,
      29.900578,
      34,
      0,
      12.643236,
      2,
      0,
      2,
      1.897939,
      1,
      1,
      0.383488,
      0.272689,
      NULL,
      0.007757,
      1.098590,
      NULL,
      NULL,
      1.519625,
      4,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      0.107579,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1.675281,
      0.730924,
      NULL,
      1,
      1.168422,
      NULL,
      0.178094,
      1,
      NULL,
      0,
      0.487565,
      0.847431,
      0,
      0.988303,
      1,
      1,
      NULL,
      0,
      9,
      1,
      NULL,
      3,
      1.303570,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      1.917469,
      NULL,
      1,
      2,
      1,
      0,
      1,
      1,
      5,
      4,
      5,
      2,
      1,
      3,
      3,
      5,
      0,
      0,
      4,
      4,
      0,
      0,
      2,
      0,
      NULL,
      3,
      3,
      4,
      3,
      3,
      ' 9-10-1981',
      NULL,
      '10- 3-1994',
      0.944832,
      3.051556,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      305.801204,
      1.145472,
      2.326906,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      2.956619,
      7.441310,
      3,
      3.771360,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.702146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.560772,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      0,
      0,
      3,
      2,
      NULL,
      3,
      0,
      2,
      2,
      1,
      1,
      NULL,
      NULL,
      2,
      1.738317,
      1.077035,
      1.051748,
      1.443695,
      NULL,
      0.431802,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0.073238,
      NULL,
      1,
      6,
      9,
      1.030028,
      4.863016,
      4.334880,
      3,
      0,
      1,
      2.920424,
      NULL,
      NULL,
      2.450344,
      21,
      3,
      3.678577,
      NULL,
      3,
      49,
      14,
      2,
      4.934948,
      2.176760,
      NULL,
      NULL,
      '',
      1.695193,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      3,
      21.261717,
      49,
      41.338867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.296252,
      0.236934,
      NULL,
      NULL,
      0.226360,
      NULL,
      NULL,
      1.983907,
      NULL,
      NULL,
      0.956364,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.669408,
      NULL,
      NULL,
      1.662125,
      NULL,
      NULL,
      3,
      0,
      4.758170,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.899313,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      0.595301,
      0,
      NULL,
      NULL,
      0.124745,
      NULL,
      NULL,
      4,
      4,
      1.883654,
      0.744207,
      NULL,
      NULL,
      1.577912,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.889225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.994565,
      NULL,
      NULL,
      1.737569,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3.483811,
      1,
      4,
      7.471521,
      2.616796,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.066435,
      0,
      0.668499,
      1.663296,
      11.825742,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      2.088599,
      2.486528,
      3,
      NULL,
      3,
      NULL,
      2.648780,
      NULL,
      1.407446,
      NULL,
      NULL,
      3,
      2.361449,
      2,
      2.563278,
      3,
      0,
      0,
      NULL,
      1,
      0.702894,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596214,
      NULL,
      NULL,
      1.512798,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.802393,
      NULL,
      NULL,
      0.946832,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.870864,
      0.483779,
      NULL,
      0.665301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.787880,
      NULL,
      NULL,
      NULL,
      303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.015986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503156,
      NULL,
      NULL,
      NULL,
      3.163874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.296757,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.782171,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      2,
      3,
      4,
      3.740014,
      2.686394,
      1,
      1,
      19.414677,
      5,
      1.881718,
      NULL,
      NULL,
      1.652354,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760790,
      168.334673,
      0,
      0,
      NULL,
      0.100273,
      0.395843,
      1,
      1.084883,
      0,
      0.408965,
      NULL,
      0.539283,
      0.824953,
      1.806130,
      1.367266,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.060633,
      0.065683,
      1,
      1,
      NULL,
      12.282635,
      0.321423,
      2,
      0.425996,
      1.225914,
      NULL,
      NULL,
      1,
      1.132258,
      NULL,
      1.083529,
      1.052797,
      NULL,
      1.923545,
      1.181477,
      NULL,
      2,
      0,
      NULL,
      0.413561,
      0,
      NULL,
      0.383202,
      0.025428,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.880254,
      NULL,
      NULL,
      1,
      NULL,
      1.792240,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.785882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.096329,
      NULL,
      0,
      NULL,
      0.151912,
      NULL,
      3.578092,
      NULL,
      1,
      NULL,
      1.738078,
      NULL,
      NULL,
      NULL,
      6.966191,
      0.422186,
      104.737555,
      1.013182,
      NULL,
      1,
      NULL,
      3.514099,
      NULL,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      14.987797,
      83.156354,
      NULL,
      NULL,
      2.168959,
      '01411',
      '',
      '',
      0.783280,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


