set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9901901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      1.205416,
      2,
      2.733913,
      0.070089,
      0,
      1,
      NULL,
      '34412142',
      NULL,
      53,
      NULL,
      1.582991,
      0,
      NULL,
      2,
      '1304',
      1.056634,
      1,
      NULL,
      NULL,
      NULL,
      6,
      46,
      NULL,
      1.159640,
      9,
      ' 9-11-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 4-23-1998',
      ' 4-23-1980',
      NULL,
      2.748508,
      1,
      NULL,
      3,
      1,
      0.176170,
      7,
      NULL,
      0.249309,
      104.864860,
      4,
      19,
      3.017465,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.457398,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      1,
      3,
      2,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.683784,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.439408,
      0,
      1.613673,
      0,
      NULL,
      1.212390,
      2,
      0.304598,
      1,
      NULL,
      1.674420,
      0,
      0.968416,
      3,
      NULL,
      2,
      NULL,
      0,
      1,
      8,
      1,
      2,
      2,
      1.253821,
      NULL,
      NULL,
      1.884408,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      0,
      5,
      4,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      0.236312,
      NULL,
      1.383012,
      1,
      4,
      0,
      4,
      NULL,
      1,
      3,
      1,
      3,
      0,
      3,
      4,
      3,
      1,
      2,
      0,
      4,
      4,
      NULL,
      NULL,
      3,
      5,
      1,
      1,
      3,
      1.146621,
      2.261098,
      '10- 0-1975',
      228,
      ' 7-17-1977',
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.170933,
      NULL,
      3,
      5,
      0.032850,
      6.625399,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328166,
      2,
      0.117808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.576340,
      NULL,
      1.897805,
      1.911685,
      0.191270,
      3,
      19,
      0.119455,
      1.994825,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.479987,
      3,
      NULL,
      0,
      NULL,
      0,
      2,
      1,
      3,
      2,
      3,
      0.726889,
      2.198965,
      2,
      0,
      0,
      1.856833,
      0.571298,
      1,
      0,
      0.544961,
      0.163271,
      1.924445,
      1.422621,
      NULL,
      1,
      0,
      1.159564,
      0,
      0.252767,
      2.137974,
      NULL,
      4.068098,
      7,
      NULL,
      6,
      2.756275,
      2,
      4,
      3,
      1,
      3,
      57.670510,
      NULL,
      0,
      53,
      NULL,
      NULL,
      21,
      5,
      5,
      1,
      '00043',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.430086,
      NULL,
      '',
      '',
      NULL,
      29,
      110,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.338412,
      2.189063,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869904,
      0.159889,
      1.562185,
      3.761102,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.188286,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136324,
      NULL,
      NULL,
      4.430603,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.242198,
      NULL,
      NULL,
      2.686203,
      0,
      1,
      2.414401,
      0.596015,
      NULL,
      3,
      NULL,
      0.072755,
      NULL,
      1.806795,
      1,
      1,
      0.291657,
      NULL,
      2,
      NULL,
      1,
      0,
      2.689997,
      3.308281,
      1,
      0,
      1.900055,
      0.074535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.758455,
      NULL,
      NULL,
      0,
      0.625810,
      NULL,
      NULL,
      NULL,
      1.041282,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301667,
      NULL,
      NULL,
      1.531071,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.211271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.600034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784410,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.506483,
      NULL,
      NULL,
      0.271986,
      NULL,
      NULL,
      1.762897,
      NULL,
      NULL,
      0.184241,
      NULL,
      NULL,
      1.726745,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2.987467,
      0.556797,
      NULL,
      3,
      2,
      7.754863,
      1.333606,
      0,
      NULL,
      0.163924,
      2.077353,
      2.667169,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.292887,
      3.415100,
      0.057378,
      1.462973,
      NULL,
      1.086718,
      1.763975,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416882,
      1,
      0,
      1.004083,
      0,
      NULL,
      NULL,
      0.786938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659461,
      NULL,
      NULL,
      1.824957,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.750580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.058532,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.912458,
      1.777804,
      1,
      1.988743,
      3.869040,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.154871,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.646106,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.404322,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      0,
      NULL,
      NULL,
      1.820147,
      NULL,
      NULL,
      0.147273,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      77,
      0.545235,
      0,
      NULL,
      0,
      1.795898,
      0.805852,
      1.019908,
      0.188734,
      0,
      0.661800,
      1,
      NULL,
      0,
      1.716022,
      1.418373,
      NULL,
      1.132883,
      0,
      1.961868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      2,
      0,
      1.170641,
      1,
      NULL,
      4.131175,
      0.071068,
      2,
      0,
      0.606298,
      0,
      NULL,
      1.265786,
      2.114909,
      NULL,
      0,
      0,
      NULL,
      1,
      3.968864,
      NULL,
      0.821494,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.808991,
      NULL,
      1.779596,
      1.128415,
      NULL,
      1.456822,
      0.556585,
      NULL,
      1,
      3.031330,
      NULL,
      0.268902,
      0,
      NULL,
      1,
      0.991183,
      1.457890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208965,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      3,
      2,
      1,
      NULL,
      NULL,
      81.718702,
      73.631240,
      2,
      4.443177,
      2.295761,
      NULL,
      '',
      NULL,
      0.097783,
      '',
      NULL,
      '',
      1.597264,
      NULL,
      '',
      '');
commit;
end;
/


