set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8507236';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '3101003',
      3.676801,
      0.521254,
      3,
      NULL,
      '4244',
      NULL,
      NULL,
      5,
      59,
      ' 1- 5-1976',
      4.118002,
      NULL,
      0,
      NULL,
      0.989957,
      ' 3-24-1998',
      NULL,
      1.471018,
      155.812212,
      9.825946,
      NULL,
      NULL,
      NULL,
      ' 3-18-1981',
      3,
      0.091672,
      2.117092,
      NULL,
      1,
      0.460439,
      3,
      1.998223,
      1.663041,
      127.119409,
      2,
      9,
      0.906550,
      NULL,
      10.596606,
      NULL,
      3,
      4,
      NULL,
      9.602421,
      3.004483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      2,
      2,
      0,
      0,
      0,
      1,
      0,
      4,
      1,
      NULL,
      0,
      1,
      0,
      4,
      0,
      0,
      0,
      NULL,
      0.413366,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1.136296,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      5,
      1,
      1,
      NULL,
      1,
      0,
      0,
      2,
      0,
      NULL,
      1.830858,
      1,
      0,
      1,
      3,
      1,
      NULL,
      5,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      NULL,
      3,
      0,
      2,
      5,
      4.230942,
      3.171710,
      ' 0- 8-1976',
      1214.560010,
      ' 3-17-1990',
      148.405118,
      3,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.414486,
      NULL,
      1,
      4.677859,
      1,
      NULL,
      NULL,
      NULL,
      0.553550,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289463,
      0.390548,
      0.906775,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.833258,
      NULL,
      NULL,
      NULL,
      2,
      1.635421,
      0.125844,
      1,
      1,
      0,
      NULL,
      3,
      2,
      0,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      3.810488,
      NULL,
      NULL,
      NULL,
      1.889454,
      0,
      1.905282,
      1,
      NULL,
      0,
      0,
      1.922052,
      NULL,
      0.425265,
      NULL,
      0,
      4.118615,
      5,
      2.678188,
      NULL,
      2.421146,
      0.377459,
      4.460955,
      3,
      NULL,
      2,
      3,
      0.598115,
      0,
      1,
      0.342017,
      4,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      '32310',
      NULL,
      NULL,
      0.585461,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      5.241791,
      84.072965,
      14.637845,
      3,
      21,
      18.472835,
      10,
      5,
      2.671626,
      0.921878,
      2.667202,
      1.096525,
      NULL,
      NULL,
      1.572534,
      NULL,
      0,
      1.454282,
      2.486121,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.843344,
      NULL,
      NULL,
      1.196940,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      8.204749,
      8.318881,
      4.662247,
      0,
      0.545814,
      0.937346,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.318641,
      0,
      0.403998,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.709548,
      0,
      0,
      0.387619,
      0.745804,
      2.607742,
      1.750033,
      0.538576,
      0,
      0.122988,
      1,
      0.179269,
      NULL,
      NULL,
      1.686413,
      2,
      NULL,
      2.341696,
      0,
      NULL,
      NULL,
      NULL,
      0.438658,
      NULL,
      NULL,
      0.696940,
      1,
      2.758193,
      1,
      0,
      NULL,
      0.552083,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.251688,
      NULL,
      NULL,
      NULL,
      0.396089,
      1.810820,
      2.009843,
      0.087617,
      2.056608,
      3.838520,
      9.787302,
      NULL,
      NULL,
      4,
      4.889100,
      1,
      2.933423,
      2,
      2.581190,
      0.669573,
      1,
      7,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.558765,
      NULL,
      NULL,
      1.791112,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      7.150514,
      2,
      0,
      1.656349,
      NULL,
      NULL,
      0.851192,
      0.553058,
      0,
      7.527402,
      2.835237,
      2.683510,
      0.959332,
      NULL,
      3.102999,
      NULL,
      2.261035,
      7,
      2,
      NULL,
      NULL,
      2,
      3,
      0.886476,
      2.403476,
      1,
      3.747313,
      11,
      6.734976,
      NULL,
      NULL,
      NULL,
      0,
      0.691421,
      2.131505,
      3,
      1.141770,
      0.931237,
      3,
      3.888508,
      1,
      0,
      4,
      10.306986,
      6.278688,
      5,
      5,
      2.471710,
      1,
      4,
      0,
      NULL,
      3,
      1,
      0,
      3.823144,
      0.298370,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.712213,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0.192589,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.160296,
      1,
      NULL,
      3.112936,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0.331380,
      0.072245,
      NULL,
      3.289067,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801501,
      0.531013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.761741,
      0,
      NULL,
      NULL,
      2.902316,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      2.752346,
      NULL,
      NULL,
      0.797665,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.854967,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1.238219,
      NULL,
      NULL,
      NULL,
      9.328852,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.928464,
      141,
      17,
      2,
      3,
      2.346087,
      1.180863,
      NULL,
      NULL,
      1.231896,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      2,
      81,
      10.324715,
      0.532086,
      NULL,
      1,
      1207.566895,
      37.218083,
      NULL,
      0,
      0,
      1,
      1.989357,
      2,
      1.078677,
      NULL,
      NULL,
      0,
      1.765758,
      2,
      NULL,
      0,
      0.040679,
      0,
      1.459901,
      2.478040,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      3.223635,
      2.425392,
      NULL,
      0,
      1,
      3.658499,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.806414,
      NULL,
      2.260678,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.088541,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.814742,
      NULL,
      0.034471,
      NULL,
      0.262389,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.489299,
      1.153197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.615768,
      NULL,
      1.396038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.824251,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.078450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.045348,
      2.700641,
      NULL,
      3.452873,
      NULL,
      3.157203,
      NULL,
      80,
      NULL,
      2,
      NULL,
      1.333956,
      NULL,
      1.011044,
      1,
      3,
      7,
      37.900909,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.073129,
      4,
      1,
      7.135226,
      3,
      0.814365,
      2.204888,
      0.568705,
      1,
      NULL,
      1.262728,
      2,
      2,
      0.334932,
      3.598248,
      1.123132,
      1,
      0,
      0.255071,
      3.380432,
      1.806700,
      1.570281,
      NULL,
      NULL,
      0.410753,
      0.705087,
      NULL,
      2.996772,
      1.792291,
      3,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1.505677,
      2.833375,
      0.846255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.466473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999919,
      0,
      0,
      1,
      0.638587,
      1.743971,
      2,
      0,
      NULL,
      2.338664,
      1,
      3,
      30,
      23.738801,
      2,
      0,
      5.231349,
      '42113',
      '42231',
      '23203',
      0.991251,
      '',
      NULL,
      '',
      3.851776,
      '4112',
      '3412',
      '');
commit;
end;
/


