set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9664148';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03',
      NULL,
      17.575056,
      27,
      NULL,
      0,
      0,
      1,
      3,
      NULL,
      2,
      0.340514,
      NULL,
      NULL,
      '10- 8-1990',
      192,
      4.302721,
      NULL,
      2,
      0,
      '10- 6-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-26-1979',
      ' 3- 1-1975',
      '10- 4-1983',
      3.708492,
      NULL,
      1.933336,
      1,
      1.015322,
      1,
      3,
      1,
      1,
      14.478466,
      5,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.963062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      3,
      NULL,
      1,
      11,
      NULL,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      0.726075,
      1,
      0.590012,
      2,
      1,
      NULL,
      NULL,
      1,
      2.669785,
      2,
      0,
      0,
      NULL,
      2,
      0.871376,
      3.239087,
      NULL,
      NULL,
      1,
      0,
      4.552185,
      1,
      1,
      0,
      1.026223,
      NULL,
      NULL,
      1.562515,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      5,
      0,
      1,
      0,
      3,
      1,
      1,
      0,
      1,
      5.964420,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0.925026,
      1,
      0,
      0,
      0,
      0,
      3,
      5,
      0,
      NULL,
      NULL,
      0,
      5,
      5,
      0,
      NULL,
      4,
      NULL,
      2,
      0,
      2,
      NULL,
      5,
      5,
      1,
      2,
      1,
      0,
      ' 1-10-1977',
      4670,
      NULL,
      4658,
      0.438411,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      0,
      1,
      4,
      NULL,
      0.423144,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.314955,
      0,
      2,
      1.433487,
      0.682623,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.198570,
      0.569590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.378275,
      0,
      NULL,
      0,
      0,
      NULL,
      7.883143,
      0,
      0.894588,
      60.618290,
      193.093869,
      6,
      3,
      2,
      0.293225,
      3,
      3,
      2,
      NULL,
      3,
      0,
      3,
      2,
      NULL,
      3,
      3,
      NULL,
      NULL,
      1.545154,
      0.787106,
      0,
      0,
      0.223556,
      0,
      0.685150,
      0.100142,
      1,
      0,
      0,
      NULL,
      0,
      0.480242,
      NULL,
      1.880984,
      5,
      2.371470,
      5,
      3.496263,
      8.427277,
      NULL,
      2.972038,
      1,
      4.825292,
      3,
      1.020949,
      NULL,
      65.354484,
      2,
      2,
      7,
      NULL,
      NULL,
      2,
      1,
      5,
      NULL,
      '41011',
      '13024',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '12030',
      '34014',
      '',
      3.586822,
      9.965836,
      896,
      11.069351,
      3,
      16.253963,
      5.919400,
      NULL,
      0,
      1.242181,
      NULL,
      NULL,
      1.340267,
      NULL,
      NULL,
      0.466585,
      NULL,
      NULL,
      3.727336,
      0.728712,
      0,
      2,
      0.514099,
      0,
      2.643007,
      0.553914,
      0.820629,
      NULL,
      2,
      0,
      NULL,
      0.764308,
      1,
      0.399360,
      1,
      0,
      1.555620,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      0,
      3.971355,
      4.433668,
      1,
      3,
      1,
      1.722629,
      NULL,
      NULL,
      NULL,
      1.522318,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.691111,
      NULL,
      NULL,
      0.359097,
      1,
      2.861561,
      1,
      3.337260,
      0.546687,
      NULL,
      0,
      2,
      NULL,
      1.835355,
      0.800464,
      1,
      1,
      2,
      3.782970,
      1,
      0.830777,
      NULL,
      NULL,
      NULL,
      0.227175,
      NULL,
      NULL,
      NULL,
      3.792915,
      1.577663,
      7,
      3,
      7,
      NULL,
      0.145381,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      2,
      3.446410,
      0.475070,
      3.723406,
      2,
      1.202159,
      1.615230,
      NULL,
      NULL,
      1.886950,
      2.766580,
      3,
      NULL,
      3.906931,
      1,
      0,
      3,
      0.608897,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      0.037298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.766032,
      0,
      1.542470,
      0,
      0,
      0.849954,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      3.319872,
      1.668921,
      NULL,
      NULL,
      0,
      3,
      3.798068,
      NULL,
      2,
      2,
      2,
      0.884841,
      1.708948,
      NULL,
      4,
      2.888543,
      1,
      2,
      2,
      1.681001,
      0,
      1.723169,
      NULL,
      2,
      2,
      0,
      2,
      1.971394,
      0.143852,
      2.817903,
      NULL,
      5.553962,
      NULL,
      0,
      0,
      3,
      2,
      0.718879,
      1.216189,
      0.515526,
      NULL,
      0.331374,
      3.217770,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.595566,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.393854,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093733,
      0,
      0.651839,
      NULL,
      2,
      0.501143,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.594688,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.315983,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.074405,
      NULL,
      NULL,
      NULL,
      0.355051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527664,
      NULL,
      NULL,
      NULL,
      NULL,
      968,
      24,
      0.713717,
      36.380376,
      1.921461,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.583432,
      NULL,
      NULL,
      1,
      13.486471,
      0,
      140,
      11.606256,
      NULL,
      1.255718,
      0,
      NULL,
      0.241091,
      1,
      1,
      3,
      1.245211,
      2,
      1,
      0,
      1.903972,
      2,
      1.734752,
      0,
      1,
      2,
      NULL,
      0,
      NULL,
      0.626919,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      183,
      NULL,
      3.482980,
      14.830641,
      28.046246,
      1.779055,
      1.366283,
      NULL,
      NULL,
      1.270930,
      NULL,
      0.861457,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.030584,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.529134,
      NULL,
      NULL,
      0.464867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      2,
      2.099371,
      3.439090,
      3,
      2,
      3,
      2.840943,
      1,
      NULL,
      NULL,
      NULL,
      1.346219,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.494526,
      NULL,
      0,
      1,
      NULL,
      1.929510,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.187842,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0.490735,
      0.570404,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      2,
      1,
      NULL,
      NULL,
      70,
      8.510348,
      4,
      4.220755,
      1.039953,
      NULL,
      '40003',
      '',
      0,
      '',
      NULL,
      NULL,
      0.790865,
      NULL,
      '24220',
      '');
commit;
end;
/


