set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      0.234046,
      4,
      2,
      '1404',
      2,
      1,
      NULL,
      NULL,
      ' 6- 9-1986',
      30.111898,
      NULL,
      0,
      1,
      0,
      ' 1-28-2000',
      0,
      3,
      NULL,
      85.225572,
      NULL,
      '11-12-1974',
      ' 6-18-1988',
      ' 5- 4-1984',
      1,
      3,
      NULL,
      1,
      0.852464,
      0,
      NULL,
      0,
      0.091150,
      NULL,
      3,
      NULL,
      4.607389,
      12,
      NULL,
      5,
      NULL,
      2,
      3,
      4.520453,
      0.738416,
      0,
      1,
      1.448303,
      0.040355,
      NULL,
      NULL,
      1.503584,
      1,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0,
      3,
      NULL,
      0,
      3,
      1,
      1,
      5,
      1,
      1,
      5,
      3,
      0,
      NULL,
      0,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828961,
      0.608661,
      1.383280,
      NULL,
      0,
      NULL,
      0.334114,
      0,
      1,
      NULL,
      2.457219,
      1.826983,
      1.034680,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1,
      1,
      1.475099,
      1.843833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      1,
      1,
      5,
      3,
      1,
      NULL,
      1,
      NULL,
      5,
      1,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1.556334,
      NULL,
      0,
      0,
      1,
      0,
      3,
      3,
      1,
      3,
      5,
      0,
      1,
      NULL,
      0,
      0,
      2,
      1,
      1,
      3,
      NULL,
      4,
      3,
      3,
      NULL,
      4,
      3.939881,
      3.110071,
      ' 0- 6-1998',
      0.621466,
      ' 0- 4-1984',
      8.199524,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      5,
      1,
      0,
      2,
      1.595907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      1.333457,
      2,
      0.382725,
      0.021562,
      2,
      NULL,
      NULL,
      NULL,
      3.668678,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      4.981238,
      0.195532,
      NULL,
      NULL,
      1.556744,
      NULL,
      0,
      0.314627,
      12.153408,
      0.483115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.773699,
      1,
      0.926406,
      0.230634,
      NULL,
      1.977891,
      1,
      2.509547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150660,
      0,
      1,
      0,
      NULL,
      2,
      NULL,
      3,
      0,
      3,
      2,
      1,
      NULL,
      0.494096,
      14,
      1,
      0.525022,
      1.633218,
      0.892135,
      1.207665,
      NULL,
      1.834235,
      1,
      1.162960,
      NULL,
      1,
      0.906352,
      1,
      18,
      1,
      0,
      5.056930,
      9,
      0,
      5,
      8,
      1,
      2.814742,
      1.704550,
      NULL,
      3.963003,
      NULL,
      0.940387,
      21.190532,
      1,
      NULL,
      NULL,
      54,
      15,
      46,
      1,
      3,
      5.356870,
      NULL,
      NULL,
      '14144',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      1.385808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.845191,
      0.093260,
      NULL,
      1.888527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.937446,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.115463,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.628006,
      1.486917,
      1,
      1,
      0,
      1,
      0.303909,
      0,
      0.012077,
      NULL,
      1,
      0.800160,
      0.377389,
      NULL,
      1,
      1,
      3.594039,
      0.737429,
      0.219339,
      NULL,
      0,
      0,
      0,
      NULL,
      0.612041,
      NULL,
      0,
      38,
      70.392098,
      0.679294,
      3,
      29,
      NULL,
      3.077016,
      1,
      NULL,
      1.268271,
      0,
      NULL,
      1.845908,
      NULL,
      1.506930,
      NULL,
      NULL,
      1.944302,
      1,
      1.961640,
      0,
      1,
      1,
      0.892092,
      1,
      0,
      0.379669,
      NULL,
      1,
      0.197008,
      1,
      0,
      1.333980,
      0,
      0.347073,
      1.340550,
      0.237884,
      0.379833,
      0.688091,
      0.102231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.330115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.409495,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.395651,
      NULL,
      0,
      NULL,
      1.058263,
      3.264529,
      1.319229,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.707235,
      NULL,
      1.646379,
      1.171390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689936,
      3.960532,
      NULL,
      0,
      NULL,
      0,
      NULL,
      83,
      NULL,
      2,
      1.161108,
      1,
      3.747393,
      NULL,
      1.963894,
      NULL,
      480,
      NULL,
      2,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.760671,
      0.833111,
      31,
      NULL,
      NULL,
      0,
      0.823831,
      NULL,
      3,
      1,
      NULL,
      2,
      3.671648,
      3,
      1.966149,
      3,
      9.542030,
      3.071110,
      2,
      1,
      1,
      0.257268,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0.636372,
      1,
      NULL,
      0.156165,
      1,
      NULL,
      0.359244,
      0,
      NULL,
      0.751484,
      1.536970,
      NULL,
      1,
      NULL,
      NULL,
      1.494864,
      0.388941,
      NULL,
      2.446032,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068815,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      '03210',
      NULL,
      '43241',
      1,
      '',
      '',
      '',
      1.881931,
      '',
      '',
      '');
commit;
end;
/


