set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      2.737201,
      2,
      0.991632,
      1.147276,
      1,
      2,
      NULL,
      '11',
      NULL,
      32.446364,
      1.399374,
      '4102304',
      1.649142,
      1,
      1,
      NULL,
      '0014',
      4,
      0,
      NULL,
      NULL,
      ' 2-25-1980',
      82,
      NULL,
      NULL,
      2,
      1,
      ' 8-25-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 3-25-1983',
      ' 2-21-1983',
      NULL,
      1.767653,
      2.357018,
      0,
      0.718086,
      3.422938,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      1,
      0.052506,
      0,
      NULL,
      0.367349,
      1,
      0,
      1.719460,
      0.017826,
      3,
      2,
      1,
      3,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      2,
      4,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.223253,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      3,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1.829633,
      NULL,
      0,
      0,
      0,
      3,
      0,
      1,
      3,
      4,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1,
      5,
      0,
      0,
      3,
      3,
      NULL,
      0,
      4,
      4,
      0,
      ' 1-25-1986',
      8,
      ' 3-19-2000',
      9,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      3.306736,
      3,
      1.889679,
      1.893820,
      1,
      NULL,
      0,
      4,
      0.017573,
      0,
      2.921343,
      NULL,
      NULL,
      NULL,
      0.910541,
      1.901946,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.840535,
      NULL,
      0.417035,
      0.641030,
      NULL,
      5,
      0,
      0.957715,
      NULL,
      NULL,
      NULL,
      3,
      1.319144,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      3,
      1,
      3,
      3.851067,
      NULL,
      1,
      NULL,
      NULL,
      0.619393,
      1.133494,
      0.564434,
      0,
      1,
      1.109755,
      0.220457,
      1.735921,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.266532,
      7,
      9,
      4,
      1.146089,
      2,
      1,
      5,
      0.151414,
      NULL,
      3.065872,
      11.677645,
      NULL,
      NULL,
      32,
      NULL,
      33,
      46,
      2,
      5,
      NULL,
      '02224',
      '21330',
      '',
      0.308233,
      '',
      NULL,
      '',
      1.957812,
      '',
      NULL,
      '',
      1,
      3.921632,
      58.974320,
      11,
      3,
      NULL,
      5,
      1.284800,
      3,
      3,
      1.488637,
      1,
      1,
      NULL,
      1.374906,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      2.573649,
      NULL,
      1,
      0.822466,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0.911092,
      NULL,
      1.630994,
      1,
      2,
      1.219923,
      NULL,
      NULL,
      0.980172,
      0,
      0.339786,
      1.838912,
      8,
      NULL,
      0.915493,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850728,
      0.338629,
      0,
      0,
      1.851006,
      3.254449,
      0,
      0.169199,
      0,
      NULL,
      3.004851,
      0,
      0.752588,
      0,
      2.757390,
      0,
      1,
      1.708405,
      3.112910,
      1,
      NULL,
      0.191177,
      0,
      6,
      1.742604,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.807911,
      1.262011,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951749,
      1.638650,
      3,
      2.837803,
      1.932016,
      0.122651,
      NULL,
      NULL,
      4.433864,
      3.543761,
      0,
      NULL,
      1.308174,
      0,
      0,
      NULL,
      NULL,
      4,
      7,
      1.617238,
      0.274750,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.707208,
      NULL,
      NULL,
      0.483032,
      NULL,
      NULL,
      0.083366,
      NULL,
      NULL,
      2,
      NULL,
      1.780820,
      1.043410,
      0.805733,
      0,
      NULL,
      3.893266,
      NULL,
      3,
      3,
      5,
      2,
      1,
      0.224418,
      3.311676,
      3,
      NULL,
      0.347887,
      NULL,
      2.328663,
      0,
      NULL,
      2.706713,
      2.561211,
      9.016334,
      7.096182,
      2,
      3,
      0,
      3,
      2,
      NULL,
      NULL,
      3.037979,
      NULL,
      1.509648,
      1.224322,
      2.930531,
      NULL,
      NULL,
      2,
      7,
      6.914723,
      3.755932,
      0.184518,
      NULL,
      3,
      1.761535,
      0,
      1.907425,
      1,
      1.380663,
      0.592000,
      NULL,
      NULL,
      0.152961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.675661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.499621,
      1.589805,
      3,
      1.867525,
      2.862587,
      3,
      0,
      NULL,
      NULL,
      4.230961,
      3,
      NULL,
      0,
      3,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.945237,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038115,
      NULL,
      1.330590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798126,
      NULL,
      NULL,
      NULL,
      1,
      0.063413,
      1,
      NULL,
      2,
      1,
      1.678607,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1.295869,
      NULL,
      1,
      0,
      0.922593,
      NULL,
      1.667386,
      2.371942,
      1.286952,
      NULL,
      NULL,
      1,
      0.106531,
      NULL,
      8.139486,
      0,
      NULL,
      NULL,
      3.359116,
      0.223263,
      NULL,
      NULL,
      NULL,
      2.733376,
      NULL,
      6.302934,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      1,
      0.833277,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.616159,
      NULL,
      1,
      0,
      0,
      1.440168,
      NULL,
      0,
      NULL,
      0,
      1.965743,
      0.411768,
      2.301441,
      0.902648,
      NULL,
      0.005781,
      0.101978,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.094675,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      23.834419,
      1.974271,
      0.136368,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.346551,
      NULL,
      0.252827,
      NULL,
      NULL,
      NULL,
      1.033742,
      NULL,
      NULL,
      NULL,
      0.831062,
      NULL,
      0.352167,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.867148,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.027433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854653,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.821223,
      NULL,
      0.695321,
      NULL,
      0,
      NULL,
      0,
      1.441089,
      3.685113,
      NULL,
      1.349818,
      NULL,
      0,
      NULL,
      673,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1.764364,
      NULL,
      1.729583,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531326,
      1.236257,
      NULL,
      3.371636,
      NULL,
      1.568662,
      NULL,
      62,
      NULL,
      NULL,
      NULL,
      1,
      1.189991,
      1,
      0,
      2.430189,
      69.024120,
      NULL,
      3.271533,
      1,
      0.380578,
      NULL,
      1.086067,
      1.565406,
      1,
      0,
      22.643962,
      NULL,
      3,
      0,
      0.568573,
      NULL,
      1,
      1,
      0,
      4,
      NULL,
      1.159771,
      0,
      0,
      5,
      0.295245,
      NULL,
      1,
      NULL,
      0,
      0.961230,
      NULL,
      NULL,
      1.646150,
      2,
      NULL,
      NULL,
      0.674191,
      0,
      0.340995,
      0.963582,
      1.551205,
      0,
      1.100791,
      0,
      0.989357,
      0,
      1.539884,
      NULL,
      NULL,
      0,
      1.748946,
      1.659656,
      NULL,
      0.846985,
      NULL,
      NULL,
      1.344311,
      0,
      NULL,
      0.846232,
      3.764940,
      NULL,
      1.893907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359654,
      0,
      0.976565,
      0,
      1,
      2,
      1,
      2,
      1.432161,
      NULL,
      NULL,
      112,
      NULL,
      NULL,
      1,
      1,
      '31312',
      NULL,
      '42344',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


