set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102851';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '4023210',
      0,
      1.875181,
      1,
      2,
      '0331',
      1.646062,
      0.568399,
      NULL,
      NULL,
      ' 3- 8-1999',
      57,
      NULL,
      2,
      NULL,
      1,
      ' 9-25-2001',
      5.156435,
      1.953764,
      NULL,
      13,
      3,
      ' 3-20-1980',
      ' 4-11-1990',
      '10-23-1986',
      3,
      1,
      0,
      1,
      0.471110,
      1,
      1,
      NULL,
      1,
      33,
      4,
      6,
      7.460214,
      4,
      21.063510,
      1,
      9,
      0,
      1,
      5,
      0.258858,
      0,
      1,
      1,
      NULL,
      1.338985,
      0.345457,
      NULL,
      0,
      1.789256,
      0.293287,
      1,
      4,
      0,
      NULL,
      2,
      0,
      1,
      1,
      1,
      3,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1.461265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.878393,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.871090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      5,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1.726638,
      0,
      0,
      NULL,
      1,
      1.650496,
      NULL,
      1.498562,
      5,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1,
      5,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      4,
      0,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      '11- 8-1984',
      153.174408,
      ' 9-28-1986',
      49,
      2.459552,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297865,
      1,
      NULL,
      NULL,
      0.302816,
      1,
      NULL,
      2.115567,
      3.866363,
      2,
      NULL,
      1.240854,
      0.389923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.657372,
      1.945480,
      1.493047,
      3,
      9.145147,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810481,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2,
      3,
      2,
      0,
      1,
      0,
      NULL,
      3,
      3.849937,
      1,
      1.668670,
      1,
      1,
      1.773352,
      1,
      0.299068,
      1,
      1.371973,
      1,
      NULL,
      5.522273,
      1,
      8.847467,
      11,
      2,
      7.440832,
      2.267418,
      NULL,
      NULL,
      3.597478,
      3.419846,
      3,
      2.967130,
      0,
      68,
      2,
      3,
      NULL,
      NULL,
      54,
      45,
      1,
      1.168215,
      2,
      '43422',
      NULL,
      '',
      1.289139,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      8,
      49,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.881920,
      0.254564,
      2.951946,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.302600,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2.222286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519881,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.872242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.533712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.795555,
      NULL,
      NULL,
      0.687547,
      NULL,
      NULL,
      1.838447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.724628,
      1,
      0.369158,
      NULL,
      NULL,
      NULL,
      0.197250,
      2.237799,
      2,
      0.423415,
      6.002162,
      2,
      1.589839,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.096842,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966706,
      NULL,
      NULL,
      1.930954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.920512,
      0,
      0,
      1.006611,
      NULL,
      NULL,
      1.883242,
      3.195904,
      0.316889,
      3,
      NULL,
      4,
      1.401209,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.472975,
      NULL,
      0.291932,
      1,
      NULL,
      NULL,
      3,
      NULL,
      4,
      0.351649,
      0,
      3,
      0,
      NULL,
      NULL,
      3.615162,
      NULL,
      2,
      NULL,
      2.358441,
      1,
      3.322396,
      1.422771,
      1,
      0,
      NULL,
      NULL,
      2,
      3,
      1,
      0.993638,
      0.554021,
      1.036231,
      1,
      0.917134,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.104635,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530713,
      NULL,
      NULL,
      1.509956,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.513630,
      0.465279,
      0.480535,
      0,
      2.752886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.300522,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.519499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735812,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.111286,
      NULL,
      NULL,
      NULL,
      2.232062,
      NULL,
      NULL,
      NULL,
      1.143675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906949,
      2.185924,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.988307,
      NULL,
      NULL,
      0.819122,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.224145,
      NULL,
      NULL,
      1.437466,
      NULL,
      0.540197,
      12,
      1.412626,
      1.500657,
      NULL,
      1.062306,
      0.508466,
      1,
      0,
      1.062606,
      NULL,
      0.022019,
      1.693817,
      1.744091,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      10,
      2.450840,
      1.087065,
      5,
      1,
      15.653747,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1.443745,
      NULL,
      1,
      0.900429,
      NULL,
      NULL,
      0,
      NULL,
      3.567584,
      3.293128,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1.956793,
      NULL,
      1,
      NULL,
      NULL,
      1.489932,
      1.558542,
      NULL,
      1.799191,
      1.521302,
      NULL,
      3.839031,
      0.311120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146047,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      119.543395,
      5,
      1,
      NULL,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      0.432034,
      '',
      '',
      '');
commit;
end;
/


