set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102851';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '2322',
      3.997898,
      1.907231,
      NULL,
      NULL,
      ' 8-11-1983',
      NULL,
      NULL,
      NULL,
      0,
      4.201309,
      ' 4-19-1999',
      NULL,
      4,
      93.939345,
      44,
      2,
      ' 7-28-2002',
      ' 1- 1-1982',
      '10- 0-1998',
      0.233978,
      NULL,
      NULL,
      2,
      0,
      1.597022,
      NULL,
      0,
      1,
      21,
      6,
      6,
      3,
      NULL,
      26,
      3,
      23.654235,
      3,
      1,
      5,
      0,
      2,
      1,
      1.419490,
      1.976253,
      1,
      0.189207,
      NULL,
      1.925949,
      0,
      0.822372,
      2,
      NULL,
      NULL,
      3,
      2,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.890303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      3,
      5,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1.916975,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0.062818,
      4,
      3,
      NULL,
      1,
      0,
      2,
      2,
      1,
      0,
      1,
      1,
      NULL,
      4,
      0,
      1,
      2,
      2,
      NULL,
      2,
      NULL,
      4,
      5,
      5,
      0,
      0,
      NULL,
      0.543499,
      NULL,
      NULL,
      '11-20-1998',
      60,
      3,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0.165771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.661646,
      0.588188,
      7.151242,
      1,
      NULL,
      NULL,
      NULL,
      0.827260,
      3,
      NULL,
      1.459585,
      6.734114,
      1.268326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.959312,
      0,
      0,
      1.419216,
      0.681154,
      0.726320,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869341,
      0,
      0,
      3,
      0,
      NULL,
      2,
      NULL,
      1,
      3,
      1,
      NULL,
      1.376956,
      1.193329,
      2.317894,
      NULL,
      1,
      1,
      0,
      1,
      1.379907,
      0.915640,
      NULL,
      0,
      1,
      NULL,
      0,
      3.252341,
      1,
      NULL,
      NULL,
      9.328982,
      NULL,
      4.612792,
      10,
      0.986863,
      4,
      1.281919,
      NULL,
      2,
      2.749326,
      NULL,
      3,
      1,
      3,
      NULL,
      4,
      33,
      68.426310,
      4,
      NULL,
      1,
      '',
      '',
      '',
      1.779415,
      '21441',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      31.144089,
      4,
      34,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.528891,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987889,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.239299,
      NULL,
      NULL,
      1.065246,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154236,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.796926,
      NULL,
      NULL,
      1.837977,
      NULL,
      NULL,
      0.176056,
      NULL,
      NULL,
      1.847277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.717260,
      NULL,
      NULL,
      2.064319,
      2,
      1.831012,
      NULL,
      2.252697,
      2.444826,
      3.940306,
      3.266325,
      1.683601,
      0.189043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.637649,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.991518,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      4,
      3.715105,
      5,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.161963,
      1.779165,
      NULL,
      NULL,
      7.789439,
      4.179850,
      7,
      1,
      0.313320,
      3,
      3.644817,
      NULL,
      0.736451,
      2,
      NULL,
      1.985138,
      0,
      0.666699,
      2.100839,
      5,
      8.787374,
      5.656603,
      0.914221,
      NULL,
      NULL,
      0.906515,
      NULL,
      NULL,
      1.072747,
      1,
      1.926770,
      0,
      0.168520,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.187383,
      NULL,
      NULL,
      1.363515,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.256399,
      1,
      NULL,
      1.228457,
      0.845566,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.900272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866191,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.416574,
      NULL,
      NULL,
      NULL,
      1.705495,
      NULL,
      NULL,
      NULL,
      2.317541,
      NULL,
      NULL,
      NULL,
      0.249879,
      NULL,
      NULL,
      NULL,
      1.155080,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0.851106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.182751,
      NULL,
      0.471418,
      26,
      1,
      1.262355,
      NULL,
      1.642203,
      0.133880,
      0.955364,
      1,
      0.651077,
      1.973577,
      1,
      0,
      1,
      1.085567,
      0.814501,
      0,
      0,
      0.001453,
      1.735665,
      0.989052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      6,
      3.342767,
      0.682857,
      1.244321,
      1,
      3,
      2,
      2.073411,
      0,
      1,
      1.587442,
      NULL,
      0.466526,
      NULL,
      NULL,
      1.465611,
      2.331196,
      NULL,
      1.355734,
      0.018764,
      NULL,
      2,
      2.129874,
      NULL,
      1.697874,
      1,
      NULL,
      1,
      3.341545,
      NULL,
      1,
      3.889164,
      NULL,
      0.523796,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058724,
      NULL,
      3,
      1,
      0.977371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268933,
      NULL,
      NULL,
      NULL,
      0.712896,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      NULL,
      83.127012,
      96.161653,
      0,
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '13204',
      '',
      NULL,
      1.585528,
      '',
      '',
      '');
commit;
end;
/


