set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7317977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-10-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '3103120',
      3,
      1.224924,
      NULL,
      0,
      '3021',
      NULL,
      0.437725,
      NULL,
      NULL,
      NULL,
      61.511823,
      NULL,
      3,
      1.108896,
      2.423171,
      ' 4- 1-1996',
      25,
      1.014018,
      NULL,
      NULL,
      0,
      ' 9-28-1993',
      ' 9-17-1979',
      ' 1-25-2002',
      1,
      1,
      NULL,
      0.216104,
      1.701600,
      NULL,
      2,
      NULL,
      0,
      87,
      3,
      16,
      7,
      NULL,
      NULL,
      1,
      16,
      5,
      2,
      6,
      NULL,
      1,
      1,
      0.684487,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      0,
      2,
      1,
      1,
      2,
      0,
      NULL,
      1,
      3,
      3,
      3,
      4,
      NULL,
      1,
      NULL,
      1,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      3,
      NULL,
      NULL,
      1,
      2,
      0.915786,
      NULL,
      NULL,
      NULL,
      1.484859,
      1,
      2.937644,
      0.798759,
      2.894522,
      0.941068,
      2,
      NULL,
      5,
      1,
      NULL,
      5.694683,
      NULL,
      0,
      3.288498,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      0,
      5,
      1,
      3,
      0,
      1.427661,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0.969447,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      1,
      0,
      2,
      0,
      0,
      2,
      NULL,
      1,
      1,
      4,
      4.204083,
      2,
      NULL,
      43.740060,
      ' 2-20-1993',
      10.601103,
      3,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.745528,
      1,
      4,
      1,
      0.822952,
      NULL,
      1,
      NULL,
      5,
      1,
      0.656366,
      0.218842,
      1.471528,
      0,
      3,
      1.962551,
      NULL,
      4,
      0,
      5.317245,
      2.100316,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398368,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698276,
      0.393806,
      0,
      1.271602,
      0.462107,
      0,
      0.149073,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      NULL,
      3,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      1,
      2,
      0.401130,
      0.961372,
      2.685056,
      0.474691,
      1,
      0,
      1,
      1.286420,
      1,
      NULL,
      NULL,
      1,
      1.621301,
      1.885219,
      0,
      NULL,
      3,
      0,
      NULL,
      8.695249,
      NULL,
      2.131395,
      4.142717,
      NULL,
      2.043355,
      0.581450,
      3.317993,
      3.615411,
      1.678810,
      2.809799,
      NULL,
      NULL,
      NULL,
      NULL,
      59,
      28,
      18.779412,
      NULL,
      0.862494,
      2.649246,
      '30010',
      '',
      '',
      0.938567,
      '',
      '',
      '',
      1.381646,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.804033,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.466436,
      NULL,
      NULL,
      1.421088,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.712937,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      1.197150,
      0.356813,
      0,
      NULL,
      0.959269,
      1,
      1.274319,
      NULL,
      1.137658,
      NULL,
      NULL,
      0.663577,
      0,
      1.294143,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.051050,
      NULL,
      1.947976,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.599542,
      25.163831,
      32,
      1,
      2.889277,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.165056,
      NULL,
      0.300274,
      NULL,
      0.272848,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.750305,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.792517,
      NULL,
      1,
      2.028902,
      0.300410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2.278612,
      NULL,
      3,
      NULL,
      197.511790,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.031917,
      NULL,
      1.608255,
      0,
      1,
      NULL,
      0,
      NULL,
      3.048010,
      NULL,
      578.060943,
      NULL,
      2.083381,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.358103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.344284,
      NULL,
      3.662695,
      NULL,
      405.194895,
      NULL,
      2,
      1.651517,
      0,
      NULL,
      1,
      NULL,
      1.040283,
      NULL,
      220.799142,
      NULL,
      0.388397,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      14,
      37,
      1,
      0.528118,
      1,
      0.319139,
      1,
      2,
      1,
      4,
      0,
      3.597270,
      NULL,
      1,
      9,
      3,
      2.730676,
      NULL,
      0,
      2,
      NULL,
      0,
      1.664151,
      NULL,
      0.273528,
      1,
      NULL,
      0,
      2,
      NULL,
      0.110986,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.582641,
      0,
      NULL,
      2.638886,
      3.118078,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      0.747772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      6,
      0.096111,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      '31023',
      '42240',
      '',
      1.343841,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


