set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9708246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      2,
      2.870338,
      '324',
      '12003104',
      16,
      41,
      '2420410',
      2.617044,
      1.914503,
      NULL,
      NULL,
      '3013',
      2.424353,
      0.142409,
      NULL,
      NULL,
      ' 1-10-1975',
      127.234165,
      NULL,
      NULL,
      3.844059,
      3.835267,
      ' 4-29-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-17-2001',
      ' 8-16-1977',
      '11-23-2002',
      3.619605,
      1,
      0.242156,
      3.271621,
      0.979769,
      0.561344,
      2,
      2.865357,
      NULL,
      NULL,
      NULL,
      5.158594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0.214127,
      0.488116,
      NULL,
      0.370605,
      NULL,
      1.773913,
      1.850419,
      0,
      NULL,
      5,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      5,
      0,
      0,
      0,
      0,
      0,
      2,
      0,
      2,
      1,
      0,
      1.451822,
      NULL,
      NULL,
      1.542157,
      NULL,
      NULL,
      3,
      4,
      1,
      NULL,
      1,
      0,
      0,
      1.089195,
      1,
      2.045047,
      0.457111,
      0.973970,
      1,
      3.972107,
      1,
      NULL,
      1.623810,
      1.652613,
      NULL,
      5,
      0,
      4,
      6.691296,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      1.936258,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0.869536,
      NULL,
      1,
      1,
      1,
      0.129573,
      NULL,
      1,
      0,
      NULL,
      1,
      3,
      1,
      2,
      4,
      0,
      1,
      5,
      3,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      NULL,
      NULL,
      1,
      2,
      5,
      0,
      NULL,
      0,
      1.808833,
      NULL,
      ' 0-27-1995',
      285,
      ' 1- 3-1989',
      242.078607,
      3.807126,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.721884,
      0.710232,
      NULL,
      NULL,
      3,
      1.830410,
      0,
      0.471932,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.086891,
      1,
      NULL,
      NULL,
      0,
      1,
      4,
      0.148317,
      NULL,
      NULL,
      0,
      1.683396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697138,
      0.023404,
      0,
      3.294422,
      NULL,
      0.368660,
      NULL,
      2,
      34,
      NULL,
      1.401459,
      NULL,
      NULL,
      NULL,
      3,
      1.538854,
      1,
      1,
      NULL,
      0,
      1,
      3,
      0,
      1,
      3,
      1,
      1,
      4.408844,
      2.450498,
      2.752237,
      3.743624,
      0,
      1.423180,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.682772,
      0.297721,
      1,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      6,
      4,
      NULL,
      5.186279,
      2,
      NULL,
      2,
      5.657754,
      NULL,
      1.962937,
      3,
      65.603357,
      3,
      NULL,
      NULL,
      NULL,
      38,
      3.407466,
      5,
      1,
      1.478476,
      NULL,
      '',
      '',
      0.897260,
      '',
      '',
      NULL,
      NULL,
      '01102',
      '',
      NULL,
      0.949368,
      6,
      94.705780,
      12.913998,
      0,
      2.011789,
      2,
      6,
      1,
      0,
      0.188838,
      2.677098,
      0.338744,
      NULL,
      NULL,
      1.862145,
      NULL,
      NULL,
      1,
      1.784315,
      0.874392,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.792500,
      2.666567,
      1.291138,
      NULL,
      NULL,
      3.962675,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996616,
      NULL,
      NULL,
      1.940719,
      NULL,
      NULL,
      1.539735,
      3.549118,
      1.061087,
      0,
      1.722452,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.743878,
      3.512913,
      NULL,
      2.567337,
      2,
      NULL,
      0.490833,
      0.894708,
      NULL,
      1,
      2,
      2,
      NULL,
      0,
      2.197889,
      1.764815,
      1.051781,
      NULL,
      1.096329,
      1.120185,
      3.522435,
      NULL,
      0,
      0,
      1,
      0.701713,
      0.580490,
      0,
      0,
      3.606112,
      1,
      NULL,
      NULL,
      3.702453,
      1,
      1,
      NULL,
      3,
      0.366146,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.691998,
      1.531094,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.921677,
      2,
      0.615296,
      NULL,
      2.897926,
      1.206972,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.600084,
      NULL,
      0,
      1.941505,
      NULL,
      NULL,
      2.430794,
      1,
      1.311331,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721888,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.100880,
      1,
      0,
      1.655064,
      NULL,
      NULL,
      1,
      NULL,
      0,
      6.135086,
      NULL,
      0.721657,
      NULL,
      NULL,
      NULL,
      1.861117,
      0.321296,
      0,
      2.302133,
      0,
      2.678725,
      1.979508,
      1,
      1,
      3.114632,
      5,
      4,
      1,
      1.991653,
      NULL,
      NULL,
      2.690761,
      NULL,
      0.255724,
      NULL,
      1,
      3.294763,
      0,
      0,
      7,
      0,
      3.059537,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0.805178,
      1.754155,
      0.969163,
      0,
      0.085508,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.033312,
      NULL,
      NULL,
      1.320573,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.572425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.882883,
      1.946500,
      0.872277,
      3,
      1,
      0,
      NULL,
      NULL,
      5.810950,
      NULL,
      NULL,
      9.120487,
      2.618427,
      NULL,
      NULL,
      0.634225,
      3.770851,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308804,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      2.360509,
      3.099728,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.509374,
      NULL,
      NULL,
      1.048269,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.552462,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.915740,
      NULL,
      NULL,
      1.607193,
      1,
      NULL,
      NULL,
      0.196639,
      3,
      NULL,
      NULL,
      NULL,
      1,
      2.197265,
      6,
      5,
      NULL,
      49,
      0,
      0,
      0.461606,
      2,
      1.961954,
      NULL,
      NULL,
      1.783997,
      44.205857,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973333,
      NULL,
      NULL,
      1,
      NULL,
      1,
      24.835460,
      NULL,
      NULL,
      2.049857,
      1,
      2,
      1,
      0,
      1,
      0.764296,
      1,
      3.405682,
      1,
      1,
      1,
      2.600260,
      1,
      1.712328,
      0.027690,
      NULL,
      NULL,
      0.163528,
      NULL,
      1,
      NULL,
      0.240187,
      NULL,
      0.881606,
      NULL,
      3.710494,
      NULL,
      NULL,
      NULL,
      0.886296,
      15.559004,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.812892,
      NULL,
      0,
      NULL,
      0.502613,
      NULL,
      0.205150,
      NULL,
      NULL,
      NULL,
      2.843147,
      NULL,
      0,
      NULL,
      1.030476,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.486471,
      NULL,
      0.134071,
      NULL,
      NULL,
      0.074839,
      0,
      0.420788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.480831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      210.992395,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.484095,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.795363,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      182.390070,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      1.613843,
      1,
      24,
      27.528525,
      3.798094,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1.025500,
      0.157659,
      NULL,
      2,
      3,
      6.767282,
      0,
      3,
      0.948397,
      1,
      0,
      NULL,
      1.285053,
      1,
      3.787950,
      1.780170,
      2.513555,
      1.023991,
      0,
      2.072092,
      3.595318,
      NULL,
      0.938736,
      2.124293,
      1,
      0.203462,
      NULL,
      0,
      2.922120,
      NULL,
      1.133052,
      NULL,
      2,
      0,
      0,
      0,
      0.186642,
      0.255689,
      0,
      0.533607,
      1.403175,
      3,
      0.402934,
      0.982614,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.998755,
      0,
      NULL,
      0.384750,
      0.395166,
      1,
      NULL,
      1,
      2.372291,
      1.931749,
      2,
      2.337337,
      0,
      NULL,
      3,
      3,
      NULL,
      1,
      1.022086,
      0.884984,
      1,
      0.300250,
      0.425491,
      NULL,
      2.264850,
      NULL,
      0.646066,
      29,
      2,
      NULL,
      NULL,
      0,
      3,
      3,
      0.640718,
      1.116328,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      62,
      NULL,
      5,
      NULL,
      5.786532,
      NULL,
      '30120',
      NULL,
      1.793707,
      '',
      '',
      '',
      2.586090,
      '33311',
      '',
      '');
commit;
end;
/


