set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9682902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      '22',
      14,
      14,
      '3032004',
      0,
      0,
      1,
      0,
      '0201',
      5,
      1,
      NULL,
      NULL,
      ' 7- 5-1979',
      NULL,
      45.333777,
      NULL,
      NULL,
      5.135368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 2-17-1980',
      ' 2-24-1986',
      ' 6-22-1986',
      1,
      3.044272,
      2,
      0,
      NULL,
      3,
      5,
      1,
      NULL,
      7.460774,
      5,
      1,
      6.893530,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      1.264326,
      0,
      0,
      0.027861,
      1.248058,
      0.046474,
      NULL,
      1.160444,
      1.360214,
      1,
      NULL,
      0,
      1,
      2,
      0,
      0,
      NULL,
      4,
      0,
      0,
      5,
      0,
      0,
      1,
      5,
      5,
      NULL,
      4.106935,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      5.900295,
      0,
      1.028145,
      1.766302,
      NULL,
      NULL,
      3.036310,
      1.550004,
      0,
      0.693086,
      2,
      2.153180,
      1.405693,
      0.183555,
      1.889887,
      3,
      2.149329,
      NULL,
      0,
      0,
      1.075764,
      NULL,
      NULL,
      1,
      1.552476,
      NULL,
      NULL,
      1.565400,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      5,
      NULL,
      2,
      2,
      1,
      3,
      5,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      5,
      3,
      4,
      3,
      NULL,
      NULL,
      2,
      3,
      1,
      6.594818,
      3.590510,
      ' 5-21-1981',
      18,
      '10- 0-2001',
      NULL,
      3,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0.068643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      18.718821,
      1.298795,
      NULL,
      NULL,
      NULL,
      NULL,
      3.692528,
      3,
      11.546136,
      0,
      1.036415,
      1.119852,
      1,
      1.933742,
      0,
      0.499585,
      0.707985,
      3.002735,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      2,
      5.298640,
      3,
      NULL,
      5,
      2,
      0.611935,
      '11-17-2001',
      NULL,
      ' 1- 3-1976',
      7,
      NULL,
      0,
      1,
      2,
      2.954368,
      1,
      2,
      NULL,
      0,
      1.848900,
      3,
      NULL,
      1.744090,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.379978,
      2,
      3,
      2,
      2,
      0,
      NULL,
      0,
      0,
      0,
      0,
      3,
      1.181126,
      NULL,
      0,
      1,
      NULL,
      3.904890,
      1,
      1.914178,
      1.103058,
      1,
      1,
      0.085909,
      1.214097,
      0,
      0,
      1,
      NULL,
      0.990479,
      4.144941,
      8.360058,
      6.524514,
      NULL,
      0.995459,
      1.202343,
      3.864294,
      1.293561,
      NULL,
      2.023484,
      NULL,
      1.915956,
      12,
      2,
      1.277795,
      28,
      NULL,
      55,
      43,
      2,
      2,
      0.493876,
      NULL,
      NULL,
      NULL,
      NULL,
      '14031',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      27,
      1.942641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.280535,
      2.335922,
      3,
      0.147524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.284133,
      NULL,
      1,
      58,
      0.998184,
      1,
      1.221854,
      1,
      1.298474,
      0,
      0.104049,
      NULL,
      NULL,
      0,
      0.456458,
      1.542024,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      10,
      5.566900,
      4.369458,
      4,
      3,
      10.072510,
      0,
      NULL,
      1,
      1.287773,
      0.620447,
      NULL,
      1.257281,
      1,
      NULL,
      1.807245,
      3,
      NULL,
      1,
      1.909531,
      NULL,
      0,
      3.336110,
      NULL,
      2,
      0.757669,
      NULL,
      1.445891,
      2,
      NULL,
      1,
      1.325178,
      NULL,
      NULL,
      3.927703,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.898516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.014805,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.697199,
      NULL,
      1.506874,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.157553,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9.255626,
      0.379362,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      1.013202,
      NULL,
      NULL,
      NULL,
      119.469596,
      5,
      3,
      6.111837,
      '03032',
      '13003',
      NULL,
      0.575013,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


