set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0130661';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.468354,
      0.091476,
      0.932466,
      2,
      2.740995,
      3,
      NULL,
      0,
      '244',
      '40220101',
      7,
      47,
      '0203142',
      1,
      1.526149,
      NULL,
      0,
      '0124',
      4,
      0.813151,
      NULL,
      NULL,
      NULL,
      22.133787,
      NULL,
      NULL,
      0,
      2.894557,
      ' 9-28-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 5- 4-1981',
      0.640070,
      0,
      0.633436,
      NULL,
      1.164475,
      1.495079,
      1,
      0.418519,
      0,
      1,
      2,
      13,
      4.458559,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.728184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.235458,
      2,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.790565,
      2,
      0,
      1,
      1,
      1.516343,
      1.298787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      0,
      2,
      0,
      0.617525,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      3,
      0,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      0.144932,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      5,
      4,
      1,
      1,
      1,
      0,
      NULL,
      3,
      5,
      3,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      2,
      3,
      4,
      0,
      4,
      NULL,
      1,
      NULL,
      0,
      '10-27-1975',
      540.816186,
      NULL,
      NULL,
      0.690566,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3.991557,
      NULL,
      1,
      0,
      0.983756,
      0.850599,
      NULL,
      1,
      5,
      0,
      3,
      0.467728,
      NULL,
      2,
      4.839468,
      0.248298,
      NULL,
      1.111175,
      1.399680,
      7.347130,
      4.669244,
      0.673236,
      NULL,
      NULL,
      0,
      6.433893,
      3,
      1,
      0,
      3,
      5.979644,
      ' 5-15-1979',
      46.224402,
      NULL,
      66,
      0.500157,
      0,
      1.220446,
      NULL,
      0,
      NULL,
      0.892246,
      0,
      0,
      1,
      3.881068,
      12,
      3,
      0.499088,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      1,
      2,
      NULL,
      0,
      NULL,
      3,
      3,
      NULL,
      3,
      NULL,
      3.471974,
      1.142090,
      2,
      NULL,
      0.393451,
      0.960135,
      1.657515,
      1,
      NULL,
      0,
      0.256663,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.480057,
      13,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      '20032',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      1.175978,
      '',
      '',
      NULL,
      1,
      NULL,
      3.000722,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144590,
      3.381106,
      2.373589,
      0,
      NULL,
      NULL,
      1.457633,
      NULL,
      NULL,
      1.284256,
      NULL,
      NULL,
      0.762441,
      NULL,
      NULL,
      1.293233,
      NULL,
      NULL,
      0.971187,
      0.495763,
      NULL,
      1,
      NULL,
      NULL,
      0.498875,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.670195,
      NULL,
      NULL,
      5.320638,
      5.836868,
      6.699260,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.783401,
      NULL,
      3.189763,
      3.299102,
      1.491192,
      NULL,
      NULL,
      0.313129,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274767,
      NULL,
      NULL,
      3.092989,
      1.774225,
      1.103426,
      1,
      NULL,
      NULL,
      9.988080,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.386887,
      1,
      2,
      1.065294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386334,
      NULL,
      0.839170,
      1,
      NULL,
      NULL,
      1.322887,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152698,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.933880,
      NULL,
      NULL,
      0.678744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.060768,
      1,
      0.324743,
      NULL,
      NULL,
      NULL,
      0,
      1.478481,
      2,
      3.596900,
      4.523092,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.519537,
      0.044427,
      3.112094,
      NULL,
      9.324687,
      3,
      1.216342,
      3.963410,
      NULL,
      1.240807,
      0.360060,
      0,
      NULL,
      NULL,
      2,
      1,
      3.580112,
      0,
      NULL,
      3,
      5,
      4,
      NULL,
      NULL,
      NULL,
      0.215235,
      2,
      1,
      1,
      1,
      1.062014,
      0.889355,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.669359,
      1,
      3.683766,
      3,
      1,
      NULL,
      4,
      2.643506,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.851286,
      0.603272,
      NULL,
      NULL,
      0.303813,
      2.453244,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618467,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.321075,
      3,
      NULL,
      NULL,
      NULL,
      1.994501,
      NULL,
      NULL,
      1,
      1.068231,
      NULL,
      NULL,
      1,
      3.354799,
      NULL,
      NULL,
      NULL,
      1.126495,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      8,
      0,
      NULL,
      NULL,
      1,
      0.696997,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      2,
      5,
      1.098802,
      0.487903,
      NULL,
      NULL,
      0.760535,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.471895,
      96,
      2,
      1.044144,
      0,
      0,
      NULL,
      0,
      0.440808,
      0,
      1.436613,
      1.475411,
      1.905081,
      1,
      1,
      0,
      0.219597,
      1.383732,
      1,
      1.264380,
      0.938028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      4,
      3.631783,
      NULL,
      1.814600,
      2,
      5,
      3,
      2,
      3,
      1,
      0,
      1,
      0,
      0,
      3,
      1.974874,
      0.968163,
      NULL,
      0.407891,
      1.335440,
      0.057930,
      3,
      0,
      2,
      3,
      NULL,
      1,
      1,
      0,
      3.568892,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      2.532731,
      3,
      NULL,
      1.514004,
      NULL,
      1,
      2,
      3,
      0.628904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.307506,
      NULL,
      NULL,
      0,
      0.630539,
      2,
      NULL,
      7,
      0,
      1,
      2,
      81,
      32.922686,
      3,
      3,
      0.803159,
      NULL,
      '',
      '',
      1.042149,
      '',
      '',
      '',
      1.244945,
      '',
      '',
      '');
commit;
end;
/


