set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134183';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '1443402',
      3,
      0.172782,
      0,
      3,
      '1030',
      3,
      1,
      NULL,
      NULL,
      ' 9-27-1977',
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      20.267388,
      NULL,
      176.252596,
      8,
      1,
      ' 7-18-2001',
      NULL,
      '11-20-2002',
      2.487189,
      NULL,
      2,
      0.935019,
      1,
      1,
      0,
      NULL,
      NULL,
      4.466453,
      7,
      19,
      0.968457,
      10,
      38.019439,
      4,
      10.910962,
      5,
      NULL,
      4,
      0.779755,
      0,
      NULL,
      0,
      NULL,
      1,
      1.241746,
      1.938945,
      1,
      1.533882,
      0,
      0,
      5,
      0,
      NULL,
      0,
      0,
      2,
      4,
      0,
      0,
      0,
      0,
      0,
      2,
      NULL,
      0,
      0.454448,
      0,
      2,
      2,
      1,
      1.008440,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      0.555474,
      2.229262,
      1,
      1,
      0,
      NULL,
      2.422886,
      1.818573,
      2,
      1,
      0,
      0.286023,
      1.676788,
      1.790441,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      NULL,
      0.421400,
      0.110923,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      4,
      1,
      NULL,
      0,
      4,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0.629531,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      5,
      NULL,
      1,
      0,
      0,
      0,
      1,
      3,
      4,
      4,
      2,
      1,
      4,
      3,
      NULL,
      2,
      NULL,
      0,
      0,
      1,
      NULL,
      3,
      2,
      ' 4-25-1986',
      198.909569,
      ' 9- 1-1989',
      8,
      3.391775,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      72.788019,
      1.581509,
      1.822917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      3,
      4,
      2.203692,
      6.931948,
      1.471926,
      NULL,
      NULL,
      3.143638,
      0.611676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.832421,
      1,
      2.300844,
      0.561763,
      1.925610,
      1,
      NULL,
      14.533977,
      1.348664,
      0.774560,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      3,
      0,
      3,
      2,
      0,
      1,
      2,
      3,
      0,
      3.997203,
      2.091276,
      0,
      0.824474,
      1.660065,
      1,
      0,
      0,
      0,
      0,
      1.855516,
      0,
      0,
      0.688504,
      NULL,
      NULL,
      1.427403,
      0,
      1.436209,
      2,
      NULL,
      3,
      11,
      NULL,
      1,
      5,
      3,
      3.670710,
      0,
      1.310134,
      3.055135,
      48,
      2,
      0.262663,
      NULL,
      9,
      23,
      NULL,
      NULL,
      1.939781,
      5,
      '43104',
      '03443',
      NULL,
      1.183807,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3,
      NULL,
      77.803094,
      32.728557,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.867250,
      0.351800,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      1,
      1,
      0,
      2.992722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      2,
      0,
      0.752174,
      0,
      0.294161,
      3.348559,
      0.702644,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.950337,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.317209,
      0,
      1.079981,
      0.955397,
      3,
      NULL,
      NULL,
      2,
      2.040623,
      1.821216,
      NULL,
      1,
      3.628967,
      1.520525,
      0,
      1.297473,
      0,
      NULL,
      NULL,
      0.862621,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.904328,
      7,
      8.632825,
      0,
      0.886342,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.094997,
      NULL,
      NULL,
      NULL,
      3.374920,
      3,
      0.642166,
      3,
      2,
      1.423578,
      NULL,
      NULL,
      2.331421,
      NULL,
      4.348583,
      1,
      NULL,
      3.249683,
      0.660190,
      NULL,
      NULL,
      3,
      NULL,
      3.500645,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.201581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      1,
      2,
      4,
      4,
      NULL,
      0,
      NULL,
      3,
      4.531109,
      7,
      6,
      1.231799,
      1,
      0,
      1.281786,
      0.751655,
      NULL,
      NULL,
      0.240072,
      3.642948,
      0,
      6.646642,
      NULL,
      3.576955,
      0.994848,
      NULL,
      0,
      NULL,
      NULL,
      0.444776,
      1.805306,
      0,
      NULL,
      2.643492,
      2.478896,
      3,
      2.462181,
      3,
      2,
      2.556528,
      0.369706,
      2.434652,
      NULL,
      1,
      0,
      NULL,
      0.894820,
      1.447342,
      0.076916,
      3,
      NULL,
      NULL,
      0.394615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.549258,
      NULL,
      NULL,
      1.690305,
      NULL,
      NULL,
      3.497378,
      0.139312,
      0,
      NULL,
      0.459806,
      NULL,
      0.986660,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.438285,
      NULL,
      NULL,
      NULL,
      3.258239,
      NULL,
      NULL,
      NULL,
      1.941461,
      NULL,
      NULL,
      NULL,
      1.856491,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.618190,
      NULL,
      NULL,
      NULL,
      1.477373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.750657,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.670482,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304631,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.511326,
      1.224423,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.824829,
      0.657069,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.319975,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.542192,
      0,
      0,
      1,
      1,
      1.238298,
      1.126276,
      0,
      0.877682,
      NULL,
      1,
      0.634481,
      0.026778,
      1.734384,
      0,
      NULL,
      0.408999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.557345,
      1,
      1.640649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164704,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531071,
      0,
      NULL,
      1.789504,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.617663,
      NULL,
      NULL,
      NULL,
      1.215328,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306356,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      107,
      NULL,
      3,
      1,
      2,
      NULL,
      0.494886,
      NULL,
      2.787590,
      NULL,
      42,
      NULL,
      NULL,
      NULL,
      1.929690,
      NULL,
      NULL,
      0,
      NULL,
      21,
      8,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      5,
      3.677790,
      1.246588,
      2,
      3,
      10.349960,
      NULL,
      1,
      0.996829,
      0,
      1.906284,
      NULL,
      NULL,
      1.182619,
      NULL,
      0.043756,
      0,
      NULL,
      NULL,
      1.503899,
      NULL,
      1.157744,
      1,
      NULL,
      0.406278,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0.736268,
      NULL,
      0.987251,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.508926,
      0,
      NULL,
      2,
      1.959691,
      1.824466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.359022,
      NULL,
      1.422102,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.170825,
      NULL,
      0.387977,
      NULL,
      NULL,
      NULL,
      3.203318,
      NULL,
      3,
      NULL,
      1,
      3.825805,
      NULL,
      0,
      NULL,
      0.059106,
      NULL,
      0,
      NULL,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      54,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '22212',
      NULL,
      1,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


