set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7101619';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1,
      1,
      3.086185,
      4,
      4.994791,
      1,
      0.214909,
      '224',
      NULL,
      NULL,
      6.396322,
      NULL,
      0.967240,
      1,
      0,
      0,
      NULL,
      2,
      0.182653,
      NULL,
      NULL,
      ' 1- 6-1989',
      NULL,
      162,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10-21-2000',
      ' 4-29-1974',
      NULL,
      3.699958,
      1.671977,
      NULL,
      0.301795,
      2,
      2.627507,
      7,
      0.394988,
      NULL,
      9.650315,
      3,
      18.174341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0.061267,
      NULL,
      0,
      1,
      1.019571,
      NULL,
      2,
      1,
      2,
      NULL,
      4,
      1,
      1,
      1,
      1,
      4,
      1,
      0,
      NULL,
      0,
      0,
      0,
      4.775786,
      0,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      0.577233,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.188843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      5.325840,
      1,
      2,
      1.026542,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      3,
      2,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      3.131217,
      1,
      1,
      1,
      NULL,
      1.051852,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      2,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      5,
      0,
      2,
      0,
      NULL,
      0,
      2,
      1,
      1,
      0.524055,
      2,
      ' 5-17-1983',
      102,
      NULL,
      822,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0.334193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11.392743,
      3,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.848653,
      0.004403,
      1.996813,
      1.320049,
      1.082473,
      3.975135,
      41,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.780319,
      0,
      2,
      0,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      2,
      2,
      NULL,
      1,
      3.321481,
      1.341554,
      0.397875,
      0,
      0.547293,
      0.694883,
      1,
      1.454938,
      1,
      1,
      1,
      0,
      1.231449,
      2,
      NULL,
      NULL,
      0,
      4,
      NULL,
      7,
      8,
      4,
      5.636528,
      4.176297,
      2.052533,
      5.331679,
      NULL,
      2,
      3,
      56.461382,
      0,
      NULL,
      24,
      NULL,
      16,
      79.547605,
      NULL,
      NULL,
      1.501201,
      '43242',
      '',
      '',
      0.247904,
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      '',
      2.207447,
      11.379519,
      276.540190,
      7.330800,
      0,
      NULL,
      1.467361,
      2.505760,
      4,
      1.498710,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097313,
      NULL,
      NULL,
      0.012241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.344804,
      1,
      NULL,
      NULL,
      1.481150,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.133241,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      6,
      5.667357,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.754131,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.721258,
      1.761916,
      NULL,
      NULL,
      0.845054,
      NULL,
      NULL,
      1.129880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.254776,
      NULL,
      NULL,
      9,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.208050,
      0.117279,
      1.658429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1.927741,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.006414,
      0,
      1.743172,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.766299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711199,
      NULL,
      NULL,
      2.501578,
      NULL,
      1.437803,
      0.015375,
      NULL,
      NULL,
      0.216601,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      2,
      NULL,
      1.116939,
      NULL,
      NULL,
      NULL,
      0.596216,
      1,
      1,
      1,
      3.057652,
      NULL,
      NULL,
      NULL,
      2,
      4.072785,
      0.748477,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.496339,
      1,
      1.110277,
      1,
      3.916655,
      1,
      3,
      0,
      0.848025,
      0.323881,
      NULL,
      NULL,
      0.032289,
      1,
      2,
      1.913892,
      1,
      NULL,
      NULL,
      0.478152,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.343915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335397,
      0,
      1,
      0,
      0.434988,
      1.470227,
      1,
      NULL,
      NULL,
      0.840097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.278483,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.008215,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.259364,
      5,
      2,
      0,
      NULL,
      0,
      1.149035,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.221200,
      0,
      20,
      0,
      3.914066,
      NULL,
      NULL,
      NULL,
      1.188297,
      1.735033,
      0.538484,
      0,
      3,
      1.283508,
      1.927248,
      0.879419,
      NULL,
      1,
      NULL,
      NULL,
      2.301938,
      NULL,
      1,
      NULL,
      0.312005,
      NULL,
      1,
      NULL,
      1.159216,
      NULL,
      NULL,
      NULL,
      68,
      NULL,
      0,
      79,
      NULL,
      0.794804,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.140573,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.156311,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.349745,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.358296,
      NULL,
      0,
      NULL,
      0,
      1.676906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      14.192682,
      2.382291,
      7,
      1.902152,
      0,
      6.906975,
      3,
      2,
      0.517487,
      1,
      1,
      NULL,
      1,
      0.374544,
      NULL,
      1.696675,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.876369,
      NULL,
      1,
      1,
      NULL,
      2,
      3,
      NULL,
      3.062708,
      2.591962,
      NULL,
      0.866543,
      1,
      NULL,
      1.308657,
      2.377149,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.251306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.811747,
      NULL,
      0,
      NULL,
      1,
      6,
      2,
      0.103905,
      0,
      0.938547,
      4.150005,
      NULL,
      5,
      2.588300,
      0.110445,
      '24032',
      '',
      '',
      0.520733,
      '',
      '',
      '',
      1.450479,
      '',
      '',
      NULL);
commit;
end;
/


