set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7501963';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      '10',
      0.531106,
      34,
      '2404402',
      1.195304,
      1,
      2,
      3,
      '1443',
      1,
      0.695083,
      NULL,
      NULL,
      '11-21-2001',
      32.119501,
      13,
      NULL,
      NULL,
      0,
      ' 3- 6-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 0-17-1978',
      ' 9- 4-1984',
      ' 0- 8-1997',
      0.320005,
      1.816455,
      1.827113,
      1.703791,
      1,
      2,
      0,
      0.165590,
      1.886562,
      1,
      0,
      4.862215,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0.507414,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0.298754,
      2,
      1,
      6,
      NULL,
      5,
      0,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      2,
      6,
      NULL,
      1,
      3,
      0.695465,
      3,
      0.550644,
      3.274539,
      2.137675,
      0.192606,
      3,
      NULL,
      NULL,
      0,
      1.951474,
      1.271870,
      0.526088,
      3,
      0,
      0,
      3.773079,
      NULL,
      2,
      3,
      1.313850,
      NULL,
      NULL,
      1.458800,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      0.543506,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      1,
      0,
      4,
      4,
      NULL,
      1,
      2,
      3,
      3,
      NULL,
      NULL,
      0,
      1,
      4,
      0,
      1,
      1.490738,
      NULL,
      ' 9-18-1987',
      1116.314100,
      ' 5- 7-1977',
      397.207628,
      2,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9,
      0,
      0.348156,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.508998,
      2,
      0.910279,
      2,
      2,
      0,
      3,
      4.093034,
      NULL,
      8,
      5.099194,
      0.915367,
      NULL,
      NULL,
      3,
      8,
      2,
      1,
      1,
      3,
      5,
      '11- 1-1975',
      11,
      ' 9- 7-1976',
      3,
      1,
      2,
      NULL,
      3.869812,
      1,
      1.581546,
      0.273925,
      0,
      0,
      0.386365,
      1.131955,
      21.089199,
      0.957737,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.569055,
      2,
      NULL,
      0,
      1,
      3,
      1,
      3,
      NULL,
      1,
      3,
      3,
      0.058485,
      1.268550,
      1.882293,
      4.791360,
      0,
      NULL,
      NULL,
      1.697914,
      1.268905,
      2,
      1,
      1,
      NULL,
      3,
      0,
      3,
      0.301275,
      2.004915,
      0.014590,
      NULL,
      1.379768,
      4,
      2.010138,
      8.596866,
      2,
      0.210010,
      NULL,
      4,
      3.391654,
      NULL,
      0,
      15.583303,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      '23320',
      '02134',
      '',
      0,
      NULL,
      '',
      '',
      1.738963,
      '',
      '',
      '',
      0,
      24.655531,
      417,
      NULL,
      NULL,
      NULL,
      41.822006,
      6,
      2,
      0,
      0.986571,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.563914,
      NULL,
      1.477106,
      0,
      0.251459,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.593372,
      1,
      1.814344,
      1,
      0.646782,
      0,
      NULL,
      NULL,
      NULL,
      0.700137,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      0.498004,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.118852,
      0.055414,
      0.541205,
      1.246227,
      NULL,
      1,
      3,
      1.496522,
      2,
      NULL,
      NULL,
      1.633897,
      0.791461,
      NULL,
      3,
      1.003140,
      0,
      2.686199,
      1,
      1,
      2.536843,
      1,
      0.506842,
      3.326273,
      3,
      2.296003,
      NULL,
      1,
      NULL,
      NULL,
      1.291431,
      0.355904,
      3,
      6,
      NULL,
      1,
      0,
      3,
      1.338127,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      1.020443,
      1,
      0,
      0.559044,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.774959,
      1.212600,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154194,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119281,
      NULL,
      NULL,
      1.751325,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.051265,
      0,
      7.538685,
      1.919476,
      NULL,
      NULL,
      1,
      3.739671,
      1,
      0.672041,
      0,
      0,
      3,
      3,
      3,
      7,
      1.693731,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1,
      1,
      0.453287,
      NULL,
      NULL,
      3.277784,
      3.217399,
      1.306487,
      4.295478,
      4,
      7.812016,
      0.191995,
      NULL,
      NULL,
      2.314596,
      1,
      0,
      NULL,
      NULL,
      1.390514,
      1.720357,
      0.188464,
      1.876338,
      NULL,
      1.465059,
      0,
      NULL,
      9,
      NULL,
      NULL,
      3.360485,
      NULL,
      NULL,
      1.619851,
      NULL,
      NULL,
      1.268522,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.454171,
      NULL,
      0.071902,
      2.935229,
      NULL,
      0.232928,
      NULL,
      NULL,
      0.786975,
      3,
      NULL,
      NULL,
      5,
      NULL,
      0,
      2.685038,
      3.457883,
      1.538778,
      0,
      NULL,
      3.345352,
      0.922428,
      NULL,
      3.651268,
      NULL,
      NULL,
      NULL,
      14,
      9,
      NULL,
      NULL,
      0,
      3.270254,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.333140,
      NULL,
      NULL,
      NULL,
      0.843270,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.041153,
      0.318473,
      NULL,
      NULL,
      0.299176,
      NULL,
      NULL,
      NULL,
      0.829614,
      3,
      NULL,
      NULL,
      1.849351,
      NULL,
      NULL,
      NULL,
      0.401010,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0.661710,
      1,
      NULL,
      NULL,
      1.043374,
      NULL,
      NULL,
      NULL,
      1.996720,
      0.498940,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      8.204435,
      NULL,
      NULL,
      NULL,
      0.876125,
      NULL,
      1,
      NULL,
      0,
      3,
      70,
      32,
      3.607150,
      NULL,
      0,
      0.867225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      12,
      14.231053,
      1.948193,
      NULL,
      NULL,
      0,
      NULL,
      1,
      245.334208,
      NULL,
      1,
      3.986468,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      3,
      0.440854,
      0,
      0.477120,
      3.191980,
      0,
      1.322917,
      1,
      0,
      NULL,
      1.707858,
      NULL,
      NULL,
      NULL,
      2.525867,
      NULL,
      2,
      NULL,
      1.452033,
      NULL,
      91,
      NULL,
      3,
      51,
      19,
      0,
      1,
      NULL,
      NULL,
      2.867400,
      NULL,
      1.315145,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.520297,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.280429,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.165577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310564,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.256041,
      NULL,
      0,
      1.995703,
      0,
      NULL,
      1.930285,
      NULL,
      0.725562,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.126877,
      NULL,
      0.002163,
      NULL,
      0,
      0,
      0.006745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333690,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.447093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906201,
      NULL,
      0,
      NULL,
      NULL,
      1.408036,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      4.798874,
      3.299599,
      6.315634,
      NULL,
      1,
      12,
      1,
      3,
      0.218143,
      0.458926,
      0,
      NULL,
      0.976911,
      1,
      NULL,
      3.392894,
      0.160044,
      NULL,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      0.677897,
      0.710557,
      NULL,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.446972,
      NULL,
      1.327293,
      0,
      NULL,
      0.700169,
      1,
      3,
      2.539711,
      NULL,
      0.508412,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.041651,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.407163,
      NULL,
      2.040712,
      NULL,
      2.167799,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      15.562048,
      0,
      NULL,
      3.458334,
      1,
      NULL,
      1.536454,
      NULL,
      2,
      NULL,
      1.574300,
      NULL,
      2.854614,
      NULL,
      1.236398,
      NULL,
      1.771287,
      NULL,
      1,
      NULL,
      0.511389,
      NULL,
      NULL,
      NULL,
      3.355857,
      NULL,
      3.937605,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.180073,
      NULL,
      NULL,
      5,
      2,
      NULL,
      0.714873,
      3.093677,
      NULL,
      22,
      0,
      5,
      7.054241,
      '32210',
      '03231',
      '34430',
      NULL,
      '',
      NULL,
      NULL,
      0,
      NULL,
      '',
      '');
commit;
end;
/


