set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9012810';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '1143243',
      NULL,
      NULL,
      2,
      1,
      '1444',
      3.188247,
      NULL,
      NULL,
      NULL,
      ' 5-26-2001',
      63,
      NULL,
      0,
      1.621625,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '11- 8-1976',
      ' 1-10-2001',
      ' 4-15-2000',
      0.226650,
      NULL,
      NULL,
      1.659395,
      1,
      0,
      0,
      1.461558,
      1,
      682,
      2,
      10,
      3,
      54.134605,
      165,
      5,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      0.728329,
      0.869644,
      0,
      0,
      NULL,
      0,
      1,
      120,
      5,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      3,
      0,
      1,
      7,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.237039,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.082058,
      0.380795,
      NULL,
      2.211273,
      NULL,
      1.182662,
      0,
      0,
      0.985629,
      0.225752,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.709455,
      NULL,
      NULL,
      4,
      1,
      0,
      NULL,
      2,
      4,
      1,
      NULL,
      2,
      NULL,
      0,
      5,
      3,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      1.404885,
      1,
      1,
      0,
      NULL,
      0,
      4,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      4,
      2,
      4,
      4,
      0,
      5,
      0,
      2,
      4,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      ' 3- 5-1996',
      1864.675576,
      3,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      2.554957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220722,
      2,
      NULL,
      1.676247,
      1.093540,
      1.274107,
      1.857645,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.852912,
      1,
      NULL,
      1.923941,
      NULL,
      0.076511,
      1,
      564,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.158535,
      1,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      3,
      2,
      4,
      2,
      1,
      1.343003,
      0,
      NULL,
      NULL,
      0.199925,
      1.345559,
      0.866260,
      NULL,
      1.712779,
      0,
      0,
      NULL,
      0,
      1,
      0,
      4.284232,
      NULL,
      NULL,
      8.119429,
      7.653485,
      4,
      1.957017,
      NULL,
      0,
      NULL,
      1,
      NULL,
      51,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      12.090572,
      NULL,
      0.514860,
      5.436363,
      '32113',
      '13421',
      '',
      0,
      '',
      '',
      NULL,
      6,
      NULL,
      '0032',
      '3342',
      1,
      29,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.026146,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.433429,
      2.994023,
      0,
      1,
      2.807763,
      0,
      0,
      2.111441,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962649,
      3.759583,
      1,
      1.207316,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.725567,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.769289,
      2,
      NULL,
      13.306176,
      19,
      NULL,
      NULL,
      NULL,
      0.198362,
      0.038786,
      NULL,
      1.964400,
      0.703634,
      NULL,
      1,
      1.307383,
      2.329695,
      1,
      0,
      1,
      2.814235,
      1,
      0,
      1.377348,
      NULL,
      NULL,
      0.571292,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.792039,
      4,
      9,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.808313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672326,
      1.048561,
      2.568755,
      0.558706,
      3.941806,
      NULL,
      1,
      NULL,
      NULL,
      3.988810,
      9.928565,
      0.941081,
      2,
      1,
      1,
      2.649765,
      3.716960,
      NULL,
      2.078569,
      9.332039,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621717,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.118804,
      NULL,
      NULL,
      1.865767,
      NULL,
      NULL,
      1.503284,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.159517,
      1,
      0.973770,
      NULL,
      4.346238,
      NULL,
      NULL,
      5,
      3,
      2,
      6,
      NULL,
      1.927401,
      0,
      1,
      1,
      2,
      NULL,
      0.330258,
      1,
      NULL,
      6.536165,
      3.734202,
      7.406544,
      2,
      1,
      1,
      3.070249,
      1,
      1.744109,
      0,
      3.439543,
      NULL,
      0,
      1.015878,
      1,
      NULL,
      7,
      NULL,
      NULL,
      3,
      2,
      1.851877,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1.214422,
      2,
      NULL,
      NULL,
      3.437444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355017,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.251759,
      NULL,
      NULL,
      1.518797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627775,
      NULL,
      0.750266,
      0.474001,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194404,
      NULL,
      NULL,
      NULL,
      0.276291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.786887,
      NULL,
      NULL,
      NULL,
      1.018196,
      NULL,
      NULL,
      NULL,
      0.527412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.361378,
      225,
      249.364317,
      0,
      NULL,
      NULL,
      0.329816,
      NULL,
      NULL,
      1.793551,
      14,
      3.707539,
      3,
      10.775607,
      1.814769,
      1,
      NULL,
      NULL,
      1.728417,
      NULL,
      2,
      430,
      19.049265,
      0,
      1,
      0.810707,
      1,
      1.331203,
      1.551498,
      0,
      1,
      1.393967,
      1.371681,
      0,
      0.273177,
      0,
      0,
      1.694942,
      0.423192,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      3,
      0.723699,
      NULL,
      3,
      2.101963,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.348327,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.355908,
      NULL,
      NULL,
      0.737185,
      NULL,
      NULL,
      1,
      3.365884,
      NULL,
      0.382469,
      1.468726,
      NULL,
      1.861706,
      0,
      NULL,
      1.219967,
      NULL,
      NULL,
      1.787122,
      0.997528,
      1.123947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187871,
      NULL,
      1.142609,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.953673,
      3,
      28,
      NULL,
      3,
      0.934588,
      4.521021,
      NULL,
      '40132',
      '',
      0,
      NULL,
      '',
      NULL,
      2,
      '1130',
      '1200',
      NULL);
commit;
end;
/


