set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7836064';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      1,
      0.243802,
      NULL,
      1,
      '2101',
      1.551625,
      0,
      NULL,
      NULL,
      ' 4-16-1975',
      61.197504,
      NULL,
      0,
      2.265450,
      1.347825,
      ' 7-19-1982',
      41.893083,
      2,
      83.920380,
      145.046634,
      1,
      '10- 2-1983',
      ' 0- 3-1987',
      ' 4-21-2002',
      3,
      0.824523,
      2,
      1,
      0.503409,
      1,
      1,
      NULL,
      0,
      196,
      0,
      NULL,
      9,
      8,
      14,
      3,
      NULL,
      2,
      0,
      7.379460,
      0.489631,
      0,
      1,
      1.215267,
      1,
      1,
      NULL,
      1,
      0,
      0.429784,
      69.965358,
      8,
      2,
      5,
      3.691722,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.282165,
      NULL,
      NULL,
      1.584422,
      NULL,
      NULL,
      2,
      3,
      8.614018,
      3.556659,
      1,
      1,
      1.110363,
      2.475310,
      NULL,
      0.346761,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.433796,
      0,
      1,
      NULL,
      3,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.074651,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      2,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      3.760330,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      2,
      1,
      1,
      NULL,
      1,
      NULL,
      3,
      1,
      0,
      0,
      1,
      4,
      1,
      0,
      NULL,
      NULL,
      5,
      4,
      3,
      5,
      0,
      NULL,
      1,
      1,
      1.546087,
      1,
      ' 3-24-1996',
      NULL,
      ' 4-11-1998',
      924,
      0.304337,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970938,
      0.650057,
      1.024922,
      1.350225,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620728,
      1.818834,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.003765,
      1,
      1,
      0.053830,
      1.552208,
      1.662398,
      12639.004632,
      1,
      0.951698,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.245658,
      1,
      NULL,
      2,
      NULL,
      3,
      3,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.172157,
      NULL,
      1.182518,
      0.310520,
      0,
      0.290728,
      1.927360,
      0.033704,
      1,
      NULL,
      0.554915,
      0.203423,
      0,
      NULL,
      1,
      1.732137,
      1.910922,
      2,
      0.856055,
      8.767954,
      6,
      NULL,
      3,
      NULL,
      1,
      1.748342,
      1.806748,
      NULL,
      11,
      1,
      3,
      NULL,
      23,
      NULL,
      NULL,
      0,
      1,
      4.892473,
      NULL,
      '11443',
      '',
      0,
      '',
      '',
      '',
      5.453650,
      '02424',
      '21012',
      '',
      3,
      38,
      NULL,
      26.658643,
      1.864507,
      0,
      7.998816,
      375.441400,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603380,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.161695,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3.564288,
      NULL,
      3.016304,
      1.731939,
      NULL,
      3.894713,
      NULL,
      0.648468,
      0,
      0,
      NULL,
      NULL,
      4,
      0,
      0.136314,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.741179,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.575445,
      1,
      0,
      NULL,
      3,
      1,
      1.628266,
      3,
      NULL,
      1.218539,
      2.011809,
      1,
      3.605827,
      NULL,
      1,
      NULL,
      1.048131,
      NULL,
      0.210251,
      1,
      0.276256,
      0.803630,
      1.413395,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.494423,
      NULL,
      NULL,
      9,
      1.183607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.703142,
      NULL,
      1,
      NULL,
      NULL,
      6,
      3,
      4.581525,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4.708352,
      3,
      0,
      0.371237,
      1,
      NULL,
      NULL,
      1.633892,
      NULL,
      NULL,
      0.916103,
      NULL,
      NULL,
      1.508174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.589245,
      0.354592,
      3,
      5,
      1.041064,
      1,
      NULL,
      3.324449,
      6.398582,
      NULL,
      NULL,
      NULL,
      0.880819,
      NULL,
      NULL,
      3,
      NULL,
      3.005015,
      2.005047,
      1,
      1,
      NULL,
      7.583745,
      NULL,
      0.677243,
      3.745612,
      0,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      0.773604,
      1,
      5.711586,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0.208234,
      1.396322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      1,
      1.014647,
      0.090465,
      0.719042,
      3,
      1.817655,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653149,
      NULL,
      NULL,
      NULL,
      0.658702,
      NULL,
      NULL,
      NULL,
      1.662530,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.514644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.828174,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062360,
      NULL,
      NULL,
      NULL,
      1,
      751,
      134.611102,
      1.196606,
      NULL,
      4,
      0.085953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      942.517573,
      NULL,
      50,
      NULL,
      1.067616,
      1,
      1.147538,
      1,
      1,
      1,
      0.585682,
      0,
      1,
      NULL,
      1,
      1,
      1.671672,
      NULL,
      1.726405,
      1.353055,
      NULL,
      1.325189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.987159,
      1,
      2,
      1,
      11,
      3.902735,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      1.642361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.263112,
      NULL,
      0,
      0.572123,
      NULL,
      1,
      1,
      NULL,
      1,
      1.333640,
      NULL,
      1.973287,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      7,
      1,
      0,
      2.725237,
      54,
      42,
      3,
      NULL,
      NULL,
      '12201',
      '12241',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      4,
      '44000',
      '32432',
      '');
commit;
end;
/


