set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8312986';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '1042240',
      0.639169,
      0,
      NULL,
      NULL,
      '0133',
      NULL,
      1,
      NULL,
      NULL,
      ' 7- 8-1976',
      30,
      NULL,
      5,
      0,
      1.353891,
      ' 7-28-1986',
      103,
      1,
      NULL,
      48.456870,
      3,
      '10- 6-1997',
      ' 6- 8-1988',
      ' 7-15-1976',
      1,
      2,
      1.185574,
      0.735115,
      1,
      3.084980,
      2,
      0,
      0,
      143.496442,
      7,
      3,
      1.173580,
      6.629654,
      NULL,
      4,
      NULL,
      5,
      2,
      7,
      1.837644,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0.953545,
      0,
      NULL,
      124.538459,
      NULL,
      6,
      6,
      NULL,
      5,
      1,
      3,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      2,
      0,
      0.391711,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      3.560777,
      NULL,
      0,
      5,
      NULL,
      9,
      3.346567,
      NULL,
      NULL,
      1.444637,
      3,
      3.706814,
      3.823455,
      NULL,
      1,
      0.882974,
      0.880029,
      1.502494,
      0.899586,
      2,
      2,
      3.695289,
      1,
      NULL,
      2,
      9.974793,
      0,
      0,
      1.228359,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      2,
      4,
      4,
      1,
      5,
      5,
      0,
      1,
      0,
      5,
      NULL,
      0,
      1.177780,
      0,
      0,
      NULL,
      1,
      0.588366,
      NULL,
      0,
      4,
      2,
      1,
      NULL,
      1,
      1,
      3,
      3,
      1,
      2,
      NULL,
      3,
      0,
      1,
      4,
      4,
      2,
      2,
      1,
      2,
      4,
      NULL,
      1,
      1,
      3,
      NULL,
      3,
      ' 3- 1-1992',
      75.655049,
      NULL,
      366,
      1,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      0,
      2,
      0,
      1.172417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.234312,
      2.993210,
      3,
      3,
      2,
      0,
      1.868846,
      4,
      1,
      4,
      5,
      0.705356,
      1,
      NULL,
      NULL,
      3,
      8.493884,
      NULL,
      2,
      4,
      2,
      6,
      ' 4- 4-1978',
      1472.570708,
      ' 8-23-2000',
      NULL,
      2,
      1,
      NULL,
      1.030741,
      0.098454,
      1,
      0,
      0,
      1.238592,
      1,
      2.297019,
      1461,
      1,
      1.491439,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.655213,
      NULL,
      0,
      NULL,
      3,
      3,
      2,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      103,
      151,
      104,
      167.730310,
      46,
      82,
      1.183618,
      NULL,
      NULL,
      0.845454,
      0.335760,
      1,
      1,
      1,
      13,
      0.488996,
      1.723475,
      9,
      1,
      3,
      10,
      0.753452,
      2.367897,
      2,
      0.060550,
      3,
      3.816870,
      1,
      NULL,
      NULL,
      1,
      NULL,
      12,
      37,
      42,
      NULL,
      NULL,
      1,
      '44221',
      '',
      NULL,
      1,
      '10100',
      '31033',
      '',
      1,
      '0412',
      '',
      '',
      NULL,
      NULL,
      NULL,
      0.402907,
      1,
      63.878654,
      8,
      37,
      0,
      1.184530,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.048885,
      0.860947,
      0,
      NULL,
      NULL,
      0.260713,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.967726,
      1,
      NULL,
      NULL,
      NULL,
      1.638755,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.316584,
      0.647251,
      0.869607,
      NULL,
      NULL,
      8,
      3.677511,
      4,
      1,
      2,
      NULL,
      NULL,
      2,
      0.293061,
      3.523016,
      1,
      3.039886,
      2.899491,
      1.372534,
      2.011604,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      3,
      1.437281,
      0.005876,
      NULL,
      1,
      3,
      1,
      0.727794,
      2,
      2,
      1,
      0.099638,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.072269,
      0.159242,
      1.799573,
      9.617184,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3.134052,
      3,
      1,
      NULL,
      1.636995,
      1,
      1.328547,
      NULL,
      NULL,
      3.343695,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.934207,
      1.543782,
      1.951644,
      0.176120,
      NULL,
      1.974920,
      1.632066,
      0.895078,
      0.077575,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.147380,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.196688,
      NULL,
      NULL,
      1.848379,
      NULL,
      NULL,
      0,
      1,
      1.612885,
      NULL,
      1.377855,
      1.932104,
      NULL,
      1,
      3,
      NULL,
      2.437555,
      1.848781,
      1,
      NULL,
      NULL,
      2.207309,
      NULL,
      1,
      2,
      1,
      NULL,
      3,
      NULL,
      0.590258,
      NULL,
      0,
      7,
      3.199532,
      0,
      1.198941,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      0.640290,
      2,
      3,
      11.258392,
      1.766202,
      0.352205,
      5,
      0,
      2.156301,
      3,
      2,
      1,
      1,
      1.296154,
      1.779724,
      0.647537,
      1,
      0,
      NULL,
      3.263968,
      3,
      NULL,
      48,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.905460,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.541792,
      1.215271,
      NULL,
      1,
      1.160278,
      NULL,
      2,
      2.116496,
      NULL,
      1.635429,
      NULL,
      NULL,
      1.814130,
      0.048029,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0.949517,
      NULL,
      0,
      2,
      NULL,
      4.540277,
      1.186872,
      NULL,
      1,
      NULL,
      1,
      3.276929,
      0,
      4,
      NULL,
      2,
      3.276058,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.038358,
      NULL,
      NULL,
      NULL,
      3.211384,
      NULL,
      1.051365,
      0.640257,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2.477542,
      NULL,
      2,
      NULL,
      2.717924,
      1,
      3,
      NULL,
      3,
      NULL,
      2,
      NULL,
      2.682679,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.822618,
      NULL,
      0,
      NULL,
      2.066272,
      NULL,
      2.535741,
      0,
      1,
      NULL,
      NULL,
      1.775208,
      0.700730,
      NULL,
      3.585403,
      NULL,
      NULL,
      NULL,
      1.482146,
      1,
      2.404704,
      NULL,
      3,
      0.425731,
      0.088795,
      NULL,
      2.543705,
      1.632384,
      0.591377,
      NULL,
      3.160940,
      1,
      2,
      NULL,
      11.002189,
      5,
      NULL,
      NULL,
      0,
      1,
      1,
      5,
      1.073669,
      NULL,
      599.798698,
      0.319575,
      60.526675,
      7,
      0.429062,
      NULL,
      NULL,
      2.755094,
      25,
      NULL,
      NULL,
      3.920413,
      2,
      1,
      71.685126,
      11,
      0,
      NULL,
      NULL,
      462.618296,
      7,
      NULL,
      0.650786,
      1.151157,
      0,
      NULL,
      1.026336,
      1,
      1.424753,
      1.456185,
      0,
      1.584710,
      0.325418,
      1.045827,
      0,
      1.581671,
      1,
      0.770776,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      0.084435,
      3.469834,
      NULL,
      0,
      9,
      0,
      0.382582,
      0,
      0.645396,
      1,
      1,
      0.672320,
      3,
      0,
      NULL,
      1.740347,
      NULL,
      0,
      1,
      0.100902,
      0.944945,
      1,
      3.128603,
      0,
      1.228183,
      0.249670,
      0.831110,
      0,
      3.598317,
      0.449329,
      1,
      0,
      1,
      NULL,
      1.966045,
      1,
      NULL,
      1.950332,
      NULL,
      1,
      0,
      3,
      2,
      0,
      0.377506,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1.683759,
      1.792816,
      0,
      1.063438,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.224832,
      0,
      1.598621,
      3,
      3.652169,
      0,
      1,
      0,
      0.247591,
      0,
      0,
      NULL,
      0.088867,
      1,
      1.758968,
      8.120046,
      0.915667,
      NULL,
      1,
      0.698392,
      0.429300,
      1,
      NULL,
      1.318430,
      0,
      0,
      2,
      2.610989,
      0,
      2,
      0,
      1.520739,
      NULL,
      1,
      1,
      '30401',
      NULL,
      NULL,
      NULL,
      NULL,
      '03110',
      '',
      1,
      '0311',
      NULL,
      NULL);
commit;
end;
/


