set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8817415';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '3110223',
      3.902426,
      0.704143,
      NULL,
      1,
      '3244',
      0,
      0.065409,
      NULL,
      NULL,
      ' 3-24-1981',
      5.317507,
      NULL,
      4,
      0.773630,
      0,
      ' 5-17-1981',
      60.454151,
      2.382456,
      349.470150,
      125,
      1,
      NULL,
      ' 6-22-1975',
      ' 5-14-1996',
      1.182644,
      1.666664,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      106.332038,
      4,
      10,
      0,
      NULL,
      181.283399,
      NULL,
      17.313129,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0.431406,
      0.448350,
      1,
      NULL,
      3,
      8,
      6,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.041424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.291641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      5.805464,
      0,
      NULL,
      1,
      1,
      0.151916,
      NULL,
      0.029133,
      NULL,
      1,
      NULL,
      NULL,
      3,
      5,
      1,
      NULL,
      NULL,
      4,
      1,
      1,
      2,
      2,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      5.004761,
      0.860185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      37,
      NULL,
      0.370108,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.214481,
      NULL,
      0.823314,
      3,
      0.443550,
      6.706020,
      NULL,
      5.606500,
      6,
      3,
      NULL,
      NULL,
      NULL,
      0.893861,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962980,
      NULL,
      2.692425,
      NULL,
      1,
      NULL,
      0,
      41,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090099,
      NULL,
      29,
      10,
      10.655474,
      1,
      0,
      3,
      '14320',
      '04434',
      '',
      NULL,
      '',
      '',
      '',
      1.845293,
      NULL,
      '',
      '',
      0.454821,
      4.150030,
      NULL,
      4.384671,
      1,
      9,
      17.344010,
      43,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765141,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644234,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.513947,
      NULL,
      NULL,
      1.736778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841691,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.990767,
      2,
      3.070643,
      NULL,
      0,
      1,
      3,
      3,
      0,
      10,
      NULL,
      0.455214,
      3,
      2,
      1.202701,
      3.529813,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392026,
      NULL,
      NULL,
      1.722884,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.009918,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.318125,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.242524,
      4,
      3,
      NULL,
      NULL,
      3.450544,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3,
      NULL,
      1.418997,
      0,
      NULL,
      NULL,
      9.241126,
      3,
      10,
      0.745036,
      1.431742,
      NULL,
      1,
      NULL,
      3,
      0.223202,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.631254,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1.677572,
      0,
      0,
      1,
      0.667822,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079685,
      1,
      NULL,
      0.484929,
      1.095486,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.083826,
      7,
      NULL,
      2,
      1.975544,
      8,
      NULL,
      2.748094,
      106,
      20.258949,
      1.739134,
      NULL,
      NULL,
      NULL,
      67.470464,
      36,
      0,
      NULL,
      NULL,
      1.927014,
      NULL,
      NULL,
      1,
      NULL,
      1,
      18280.211535,
      NULL,
      1,
      NULL,
      1,
      1.299814,
      1.912411,
      0,
      0.977100,
      1.766172,
      1.069694,
      0,
      0,
      0.416155,
      0,
      0.765239,
      1,
      1,
      1.179571,
      2.218669,
      NULL,
      0,
      NULL,
      2.918116,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      99,
      NULL,
      2,
      30,
      19,
      0.439448,
      3,
      2.660895,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.190581,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.081925,
      NULL,
      0,
      NULL,
      0.335711,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.427774,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      14,
      2.844908,
      3.857827,
      3,
      0,
      NULL,
      3.442454,
      1.989579,
      0,
      0.939660,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584016,
      NULL,
      NULL,
      1.006457,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3.676021,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.516348,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.665756,
      0,
      NULL,
      NULL,
      62,
      NULL,
      0.541593,
      2,
      '12211',
      '01223',
      '',
      0,
      '',
      '',
      '',
      1.670298,
      '',
      NULL,
      '');
commit;
end;
/


