set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9131717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '2021422',
      0.227095,
      NULL,
      0,
      0,
      '2332',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      NULL,
      3,
      3,
      1.561442,
      ' 1-28-1976',
      8.010321,
      NULL,
      NULL,
      63.202590,
      0,
      ' 6-26-1978',
      ' 7- 8-1978',
      '10-20-1989',
      3,
      NULL,
      2,
      3.916027,
      0,
      3,
      NULL,
      0.407002,
      1,
      8.971739,
      6,
      NULL,
      5,
      13,
      0,
      2,
      22.030207,
      4,
      2,
      9,
      NULL,
      NULL,
      0,
      1.731139,
      NULL,
      NULL,
      1.625100,
      NULL,
      1.134145,
      1,
      1.591743,
      3,
      2,
      5,
      3.754794,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0.554469,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1.461071,
      0.071207,
      3,
      NULL,
      1.570334,
      NULL,
      0.720492,
      1.849244,
      1,
      0,
      0.076512,
      1,
      0.945566,
      2,
      0,
      4,
      1,
      0,
      4.469355,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.160627,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      5,
      5,
      NULL,
      1,
      1,
      1,
      4,
      0,
      1,
      7,
      0,
      0,
      0,
      0,
      1.607624,
      NULL,
      1,
      3,
      2,
      3,
      0,
      1,
      1,
      4,
      NULL,
      NULL,
      2,
      1,
      2,
      NULL,
      3,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      4,
      2,
      5,
      1,
      ' 7-25-1987',
      565.471456,
      ' 3-11-1992',
      428.510410,
      NULL,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      3,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.952393,
      0.415987,
      3.188182,
      0.071365,
      0,
      0.038497,
      NULL,
      3,
      NULL,
      5.157185,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.650713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.731470,
      NULL,
      0,
      0,
      3.445983,
      42,
      0.243485,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      2,
      1,
      2,
      NULL,
      1,
      0,
      3,
      3,
      1.280777,
      3,
      NULL,
      2.209208,
      1,
      1.975417,
      0,
      NULL,
      0.985101,
      1.935662,
      NULL,
      1.094085,
      1,
      0.511007,
      1,
      NULL,
      1.459815,
      NULL,
      NULL,
      NULL,
      5,
      1.311455,
      2.339107,
      4.673208,
      6,
      1.637193,
      1.706252,
      NULL,
      3,
      2.876597,
      0.219978,
      NULL,
      2,
      3,
      NULL,
      45,
      34,
      29,
      3,
      0,
      0,
      '21303',
      NULL,
      '',
      0.517799,
      '',
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      3.543311,
      9,
      130,
      27,
      2.462214,
      NULL,
      NULL,
      3.179214,
      2,
      2.045198,
      2,
      NULL,
      0.487912,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.384679,
      NULL,
      NULL,
      2,
      3.227287,
      0,
      2,
      NULL,
      0.971748,
      2,
      0.632363,
      1,
      NULL,
      NULL,
      NULL,
      0.121612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164991,
      NULL,
      NULL,
      0,
      9,
      4,
      1,
      0.212767,
      NULL,
      NULL,
      NULL,
      0.480301,
      NULL,
      NULL,
      NULL,
      2,
      0.466320,
      0.953944,
      NULL,
      NULL,
      NULL,
      13.744911,
      NULL,
      NULL,
      1,
      0,
      0.642502,
      2,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.259498,
      1,
      3,
      NULL,
      NULL,
      0.630995,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.519343,
      NULL,
      NULL,
      7.686566,
      5.106071,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.303519,
      NULL,
      NULL,
      NULL,
      0.220609,
      NULL,
      NULL,
      2,
      0.954526,
      2,
      NULL,
      NULL,
      NULL,
      1.240453,
      NULL,
      NULL,
      NULL,
      3.848104,
      NULL,
      0.733881,
      0,
      NULL,
      3,
      0,
      NULL,
      2.643656,
      9.613255,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484067,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.836961,
      1.650086,
      NULL,
      1,
      0,
      0,
      0.576562,
      NULL,
      0.428048,
      3,
      0.917058,
      3,
      1.596528,
      1.317097,
      3,
      0,
      0,
      NULL,
      1.200942,
      NULL,
      1,
      1.062588,
      NULL,
      3.309939,
      5.970818,
      NULL,
      0,
      3.353010,
      2.628693,
      2,
      1,
      3,
      2.288526,
      2.843410,
      2.128302,
      NULL,
      2,
      0.619704,
      NULL,
      NULL,
      7.351784,
      1,
      0.144537,
      4,
      1.512114,
      3,
      1,
      3,
      1,
      0,
      0.436544,
      0.613216,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.046481,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424873,
      1.587024,
      0.835911,
      NULL,
      1,
      NULL,
      1.370710,
      NULL,
      NULL,
      1.257936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.923413,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.408165,
      NULL,
      NULL,
      NULL,
      1.481163,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.295334,
      NULL,
      NULL,
      NULL,
      1.184008,
      NULL,
      NULL,
      NULL,
      0.318690,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1.540333,
      NULL,
      NULL,
      NULL,
      2.160826,
      177.837591,
      11,
      1.365880,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.984268,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.545376,
      7342,
      NULL,
      0,
      0,
      0,
      1.598906,
      1,
      1,
      0,
      0,
      0.550459,
      1.134507,
      NULL,
      1,
      1.428685,
      1,
      1,
      0,
      NULL,
      1.771504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412086,
      NULL,
      0.644005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.329985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.911529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262404,
      NULL,
      0.229381,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192670,
      NULL,
      1,
      NULL,
      1.681416,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.473734,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.577281,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838626,
      NULL,
      1.872960,
      NULL,
      0.422253,
      NULL,
      0.974835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.064061,
      NULL,
      1,
      1.698906,
      1,
      0.940398,
      NULL,
      2,
      0.116738,
      0,
      1,
      NULL,
      0.035642,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.468942,
      0.533700,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203052,
      1,
      NULL,
      1.445652,
      0,
      NULL,
      1.714027,
      0.852244,
      NULL,
      0.763283,
      NULL,
      NULL,
      0,
      0.953168,
      NULL,
      1,
      0,
      0.591298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.765342,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      11.389739,
      NULL,
      0,
      NULL,
      3.624015,
      '12001',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.975059,
      '',
      NULL,
      '');
commit;
end;
/


