set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102383';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      '1441',
      1.147630,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1994',
      34,
      NULL,
      1,
      1.645682,
      2,
      ' 0-10-2001',
      25,
      NULL,
      66.549242,
      62.803833,
      2,
      ' 5- 1-1987',
      ' 6-13-1978',
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0.705775,
      1,
      1.855431,
      1,
      12.428300,
      8,
      13.098830,
      0,
      5,
      20,
      0,
      18.300932,
      3,
      3,
      8.263437,
      0.946329,
      NULL,
      1,
      NULL,
      0,
      0.240345,
      0,
      1,
      NULL,
      0.897237,
      0,
      2,
      4,
      0,
      3.677224,
      4,
      NULL,
      1,
      0,
      1,
      0,
      4,
      1,
      1,
      0,
      0,
      0,
      5.518458,
      0,
      NULL,
      0,
      0,
      0.245254,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.176230,
      5,
      1,
      1,
      1,
      3,
      5,
      0,
      0,
      NULL,
      4,
      1,
      0,
      0,
      0,
      NULL,
      4,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      5,
      2.534715,
      1.065994,
      ' 5- 7-1976',
      39.498825,
      ' 2-24-1987',
      28,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      0,
      1.031861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      2,
      7,
      NULL,
      NULL,
      1.502230,
      1,
      0.773483,
      NULL,
      1,
      1,
      9.632373,
      2.363913,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.074623,
      1.430869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325552,
      NULL,
      1,
      NULL,
      1.869222,
      NULL,
      1.772320,
      1.070138,
      6,
      1,
      0.821111,
      NULL,
      NULL,
      NULL,
      3,
      0.290971,
      1.403827,
      NULL,
      2,
      3,
      NULL,
      2,
      NULL,
      3,
      2,
      3,
      0,
      1,
      2.773449,
      1.756227,
      NULL,
      1,
      0,
      NULL,
      1.581538,
      1.978891,
      0.720109,
      1.967674,
      0.257987,
      1.407052,
      NULL,
      NULL,
      NULL,
      1.578766,
      1.334709,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.788242,
      NULL,
      21,
      14,
      2,
      2,
      0.203079,
      3.070568,
      NULL,
      '22014',
      '',
      1.979202,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      28,
      21.561796,
      29,
      0.273687,
      NULL,
      NULL,
      NULL,
      NULL,
      3.469985,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.666467,
      NULL,
      0.919833,
      3.885789,
      NULL,
      3.605866,
      1.273512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.890389,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.738049,
      NULL,
      NULL,
      9.590048,
      0.446290,
      5.110019,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.995963,
      NULL,
      NULL,
      NULL,
      0.399248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310722,
      NULL,
      NULL,
      0.232070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.777632,
      NULL,
      NULL,
      0.745846,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.126319,
      0,
      1.620831,
      NULL,
      NULL,
      0.383165,
      NULL,
      NULL,
      0.751373,
      2.555370,
      NULL,
      0.898454,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180634,
      NULL,
      NULL,
      0.481815,
      NULL,
      NULL,
      1.978334,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.274321,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.376703,
      3.700125,
      1,
      NULL,
      NULL,
      5.012796,
      NULL,
      3,
      NULL,
      5.647330,
      4,
      1.578931,
      NULL,
      NULL,
      0.136752,
      NULL,
      NULL,
      2.201673,
      2.511956,
      1,
      3.117193,
      3.139399,
      3.564859,
      0.924344,
      NULL,
      4,
      3.184336,
      0,
      0.144233,
      3,
      3.588728,
      3.626651,
      0.393412,
      NULL,
      NULL,
      0,
      3.152478,
      NULL,
      4.687016,
      7.439394,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.409968,
      0.699190,
      0.782058,
      0.936798,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444167,
      NULL,
      NULL,
      1.355342,
      NULL,
      NULL,
      0.670919,
      NULL,
      NULL,
      0.257208,
      NULL,
      NULL,
      0.603648,
      NULL,
      NULL,
      0.509840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.784544,
      1,
      1,
      1.538602,
      NULL,
      1.616467,
      NULL,
      NULL,
      1.900784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.046731,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.053906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.198863,
      NULL,
      NULL,
      NULL,
      0.789803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.688998,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1.622001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014201,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.824336,
      NULL,
      1,
      NULL,
      0,
      0.682434,
      1,
      1,
      0.588133,
      0,
      0.432487,
      1.635237,
      3.441858,
      0,
      NULL,
      1,
      0.961483,
      NULL,
      0.811012,
      1.709645,
      NULL,
      1.702212,
      3,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.481456,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      2.065642,
      35,
      14.581705,
      1.063828,
      0.364571,
      NULL,
      NULL,
      0.200712,
      NULL,
      0.261440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620921,
      NULL,
      0.429854,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.099911,
      NULL,
      1.955467,
      NULL,
      1.684035,
      NULL,
      0.114609,
      NULL,
      1,
      NULL,
      1,
      1.384308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      5.270211,
      NULL,
      0,
      NULL,
      1,
      5.552838,
      1,
      1.010686,
      NULL,
      0.501051,
      1,
      NULL,
      1,
      3.627545,
      NULL,
      0,
      3,
      NULL,
      1,
      1,
      NULL,
      3,
      0.623510,
      NULL,
      0.504288,
      0,
      NULL,
      NULL,
      3.730646,
      NULL,
      NULL,
      1,
      NULL,
      1.554136,
      3.174510,
      NULL,
      1,
      NULL,
      NULL,
      0.059489,
      0,
      NULL,
      3.140544,
      1.240707,
      0.285110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.361285,
      NULL,
      4,
      4,
      0,
      0.946540,
      NULL,
      NULL,
      76.227628,
      36.026219,
      4,
      0.279815,
      NULL,
      '12423',
      NULL,
      '',
      1.365658,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


