set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102383';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '0034331',
      NULL,
      1,
      2,
      2,
      '0100',
      NULL,
      0,
      NULL,
      NULL,
      ' 9- 7-1988',
      NULL,
      NULL,
      2,
      NULL,
      1,
      ' 1-16-1977',
      NULL,
      3.896672,
      NULL,
      76.731413,
      0,
      '10-22-1992',
      '10-17-1977',
      ' 0-23-1977',
      NULL,
      NULL,
      NULL,
      2.276938,
      0.774572,
      NULL,
      2,
      1.321592,
      0,
      21.065836,
      NULL,
      NULL,
      3.163023,
      5.341090,
      12,
      5,
      2,
      0,
      2,
      7.850706,
      1.249811,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.090956,
      3,
      0,
      0,
      1,
      1,
      2,
      2,
      NULL,
      0,
      0,
      1,
      1,
      1,
      4,
      4,
      NULL,
      0,
      2,
      5,
      3,
      NULL,
      1,
      0,
      1,
      2,
      1.141264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1.849053,
      1.013379,
      0,
      NULL,
      0,
      0,
      1.083395,
      0,
      1,
      NULL,
      0.175431,
      1.985444,
      0,
      1.785859,
      1,
      1,
      0,
      0,
      5,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.912708,
      NULL,
      NULL,
      1,
      2,
      0,
      1,
      3,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.756018,
      5,
      1,
      1,
      2,
      0,
      0,
      0,
      1,
      1,
      5,
      1,
      NULL,
      5,
      1,
      1,
      NULL,
      1,
      4,
      3,
      3,
      NULL,
      5,
      NULL,
      1,
      1,
      0.379078,
      0,
      ' 4-16-2001',
      44.657675,
      ' 5- 6-1989',
      15.247355,
      2.489935,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.818516,
      0.685434,
      NULL,
      0,
      1.859991,
      3,
      2.314751,
      1,
      2,
      0.494540,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      6.705063,
      2,
      0,
      1.221382,
      0.218483,
      NULL,
      NULL,
      NULL,
      0.225854,
      5.925180,
      1.065233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173869,
      1,
      1.302470,
      NULL,
      1,
      1,
      1.198315,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.437367,
      3,
      NULL,
      0,
      1,
      2,
      NULL,
      3,
      NULL,
      0,
      2,
      1,
      0,
      1,
      NULL,
      0.969768,
      1.658350,
      1,
      0,
      0,
      0.355168,
      0,
      NULL,
      1.401981,
      0.401815,
      0.012524,
      NULL,
      0,
      0,
      1,
      0,
      7,
      NULL,
      6.042917,
      3,
      NULL,
      7,
      5.872906,
      1.899562,
      6,
      0,
      NULL,
      1.275793,
      44,
      2,
      3,
      NULL,
      NULL,
      48,
      52,
      3,
      0,
      3.786419,
      '43441',
      '13131',
      '',
      1.528569,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      11.036173,
      NULL,
      14.450175,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.808164,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.887568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.677204,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2.379718,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.816179,
      2,
      NULL,
      3.911687,
      3,
      11.415983,
      0,
      2,
      18.230478,
      4.508926,
      NULL,
      5,
      0,
      0.482675,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.542917,
      3.332329,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1.744321,
      1,
      1.950247,
      1.222156,
      0,
      1,
      1,
      0,
      1,
      0.808830,
      0.185297,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338347,
      NULL,
      NULL,
      4,
      2.880040,
      4.680828,
      0,
      1.203346,
      NULL,
      NULL,
      NULL,
      1.871542,
      NULL,
      NULL,
      NULL,
      0.814015,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.654060,
      NULL,
      NULL,
      0.284100,
      2,
      3,
      0,
      NULL,
      NULL,
      1.937259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.654644,
      NULL,
      NULL,
      1.026105,
      NULL,
      NULL,
      0.703542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137203,
      NULL,
      NULL,
      NULL,
      1.273726,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8,
      0.052991,
      1,
      NULL,
      NULL,
      0.788272,
      NULL,
      NULL,
      0.557520,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2.241546,
      1,
      2,
      NULL,
      6,
      3,
      0,
      0.627749,
      1.810992,
      2.848260,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.313183,
      9.292050,
      9.648426,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.969059,
      1,
      0,
      0,
      1.333820,
      1.279268,
      NULL,
      NULL,
      1.443977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991753,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.522729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.844084,
      1,
      0.417207,
      0.061332,
      1,
      0.581335,
      0.785684,
      NULL,
      NULL,
      2.924526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.559695,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625679,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.777256,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.864509,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.983857,
      NULL,
      0.004527,
      1,
      NULL,
      NULL,
      0.156212,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.755300,
      NULL,
      1.201966,
      259,
      1,
      1,
      0.704010,
      1.273480,
      1,
      0,
      1,
      NULL,
      3.072446,
      0,
      0,
      0.281264,
      NULL,
      1,
      1,
      1.959491,
      0.975626,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.059622,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      19,
      0.133502,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762942,
      NULL,
      1.886566,
      NULL,
      0.686922,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.564458,
      NULL,
      1.610391,
      NULL,
      1.051324,
      NULL,
      0,
      NULL,
      1.248310,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      1.271423,
      0,
      0,
      0.431857,
      NULL,
      2,
      3,
      3,
      0,
      NULL,
      0,
      NULL,
      0.328676,
      2.698328,
      NULL,
      1,
      1.251194,
      NULL,
      1.420600,
      NULL,
      NULL,
      1.550760,
      3.357236,
      NULL,
      1,
      1,
      NULL,
      0.615335,
      3.712873,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.225372,
      NULL,
      4,
      1,
      0,
      0,
      NULL,
      NULL,
      42,
      115,
      5,
      1.132545,
      NULL,
      '42304',
      '10110',
      '',
      0.649914,
      '',
      '',
      '',
      1.171877,
      '',
      '',
      '');
commit;
end;
/


