set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9026442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '1314321',
      0,
      NULL,
      3,
      NULL,
      NULL,
      0.131482,
      1,
      NULL,
      NULL,
      '10-25-2002',
      6,
      NULL,
      4,
      2.050939,
      0,
      ' 1-25-1985',
      NULL,
      NULL,
      184.988806,
      NULL,
      3,
      ' 2-24-1985',
      '10- 1-1995',
      ' 1- 2-1990',
      1.357532,
      0,
      1.098266,
      NULL,
      1.522139,
      1.249711,
      1,
      1.689984,
      0,
      23,
      4,
      3.830769,
      7,
      143.534017,
      53,
      4,
      3,
      3,
      1,
      6.299700,
      0,
      1,
      0,
      0.134455,
      0,
      1.436046,
      1,
      3.652490,
      0.132716,
      1,
      NULL,
      3,
      5,
      0,
      1.744793,
      4,
      1,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      NULL,
      1.077920,
      NULL,
      NULL,
      0.456645,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.759040,
      1,
      0,
      NULL,
      0.478501,
      0,
      NULL,
      3,
      0,
      0,
      0.628852,
      0.516740,
      0,
      NULL,
      0.927303,
      1,
      1,
      1,
      7.854165,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      4,
      1,
      0,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      1.669749,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1.612318,
      0,
      3,
      NULL,
      2,
      0,
      4,
      0,
      3,
      3,
      1,
      0,
      3,
      3,
      1,
      NULL,
      1,
      2,
      2,
      3,
      4,
      2,
      4,
      NULL,
      4,
      2,
      2,
      3.417380,
      ' 3- 5-1994',
      95,
      NULL,
      10.433335,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1.727884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      16,
      0,
      0.698953,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.350719,
      1.189195,
      NULL,
      NULL,
      NULL,
      1,
      1.124936,
      7,
      9.800150,
      3,
      6.386422,
      1.715162,
      NULL,
      NULL,
      NULL,
      1.647937,
      0.466150,
      0.951882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.619750,
      0,
      0.277578,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.223522,
      0,
      1,
      3,
      2,
      1,
      0,
      2,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.970827,
      0.899573,
      1.200295,
      1.583951,
      0,
      1,
      0,
      1.196108,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.657604,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      0,
      '31300',
      '13214',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.721448,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661721,
      4517,
      NULL,
      0,
      0.469033,
      1.402392,
      0,
      0,
      0,
      NULL,
      0.722398,
      NULL,
      1.750502,
      0,
      NULL,
      NULL,
      1,
      1,
      0.200692,
      NULL,
      2.776800,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.119598,
      NULL,
      NULL,
      NULL,
      1.579541,
      NULL,
      3.300933,
      NULL,
      1.992777,
      15,
      NULL,
      0,
      NULL,
      3.956328,
      NULL,
      0.085194,
      NULL,
      1.050099,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.095328,
      NULL,
      0.067767,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.408005,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.703068,
      NULL,
      0,
      2,
      0,
      1.570628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507849,
      1.813634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.306293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.315597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.976974,
      2.608798,
      NULL,
      1,
      NULL,
      3.463529,
      NULL,
      13.820879,
      NULL,
      3.645223,
      NULL,
      NULL,
      NULL,
      0.132126,
      0,
      3.393356,
      25.806342,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      13,
      4,
      1,
      5.645918,
      2,
      19.044800,
      NULL,
      0,
      NULL,
      1,
      0.937055,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.955361,
      NULL,
      0.826422,
      0.479604,
      NULL,
      NULL,
      NULL,
      NULL,
      1.567651,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.496434,
      0.682101,
      NULL,
      0.129126,
      NULL,
      NULL,
      0.403675,
      2.635731,
      NULL,
      1,
      0.606943,
      NULL,
      2.357464,
      0.527905,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.660413,
      1,
      NULL,
      0.899550,
      NULL,
      3.956877,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.662573,
      NULL,
      0.396978,
      NULL,
      1.457159,
      NULL,
      1,
      NULL,
      NULL,
      1.436908,
      NULL,
      0.965032,
      NULL,
      3,
      NULL,
      1.513002,
      NULL,
      1,
      1,
      4,
      0.563040,
      NULL,
      NULL,
      38,
      37.481010,
      4,
      1,
      5.280601,
      NULL,
      '03023',
      '44034',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


