set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650054';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      NULL,
      23,
      6.375903,
      '4310404',
      3,
      0,
      4,
      2,
      '3310',
      NULL,
      1,
      NULL,
      NULL,
      ' 9-21-1994',
      39,
      50.402085,
      NULL,
      NULL,
      0,
      ' 2- 3-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 9-14-1988',
      ' 4-25-1981',
      2.212212,
      2,
      NULL,
      NULL,
      1.475585,
      0.444474,
      3,
      NULL,
      1,
      171.314597,
      1,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.551696,
      NULL,
      1,
      0.155110,
      1.506013,
      0.795058,
      NULL,
      0,
      1,
      0,
      1,
      1,
      2,
      NULL,
      2.636541,
      1,
      0,
      3,
      NULL,
      NULL,
      4,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1.071597,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.369568,
      1.627348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.522580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      3,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      6,
      0,
      2,
      1,
      1,
      0,
      NULL,
      4.380779,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      4,
      0,
      2,
      0,
      5,
      2,
      2,
      0,
      4,
      2,
      4.956056,
      3.004979,
      ' 5- 3-1983',
      NULL,
      ' 1-27-1998',
      205.910040,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      0,
      0,
      1,
      1.373719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.582595,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129272,
      3.563352,
      0.122609,
      3.272365,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.526172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.401793,
      0,
      0,
      NULL,
      7.433900,
      1.070468,
      1.582835,
      NULL,
      NULL,
      NULL,
      0,
      1.432811,
      NULL,
      0,
      3,
      0,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      3,
      1.669746,
      NULL,
      NULL,
      1,
      1,
      NULL,
      5.504088,
      0,
      0.792777,
      0,
      1.898545,
      0.983067,
      NULL,
      NULL,
      NULL,
      0,
      1.775892,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.569171,
      2.221238,
      0,
      0.033258,
      3.395848,
      NULL,
      3,
      2.137922,
      59.664249,
      0,
      2,
      NULL,
      NULL,
      56,
      49.741728,
      1,
      NULL,
      0.440610,
      NULL,
      '',
      '',
      0.824320,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      3.326791,
      14.766393,
      126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.199840,
      NULL,
      NULL,
      0.726183,
      0.572732,
      1,
      1.420697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      2.766018,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472323,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      5,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.096716,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.090363,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.541143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029169,
      0,
      2.602780,
      3,
      3,
      1.709440,
      NULL,
      NULL,
      0.126930,
      NULL,
      NULL,
      NULL,
      5.995811,
      2,
      0.046788,
      3.899442,
      1,
      1.201499,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1.749778,
      NULL,
      NULL,
      3,
      1,
      0.733148,
      NULL,
      NULL,
      NULL,
      1.118802,
      NULL,
      NULL,
      0.360784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384036,
      NULL,
      NULL,
      0.671799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.947039,
      2.817872,
      3,
      0.435814,
      0.648009,
      1.715104,
      2,
      4.667246,
      5.980456,
      2.775377,
      3.510030,
      NULL,
      2.040198,
      NULL,
      3,
      2,
      NULL,
      1,
      3.932667,
      1,
      3.349013,
      3.026107,
      NULL,
      3,
      2,
      5,
      1.582564,
      4.622029,
      0.543439,
      4,
      3,
      NULL,
      1,
      0.675120,
      1,
      0.093319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.017901,
      NULL,
      NULL,
      3.196422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.329770,
      1.823070,
      1,
      0,
      0,
      1.976540,
      NULL,
      NULL,
      0.038704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.269351,
      NULL,
      NULL,
      NULL,
      1.851574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.740164,
      NULL,
      NULL,
      NULL,
      2.436754,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.000317,
      NULL,
      NULL,
      NULL,
      0.599919,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.953372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.210141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161426,
      NULL,
      NULL,
      NULL,
      0.307849,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.860159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      0.649472,
      NULL,
      1,
      1,
      1.213413,
      0,
      0,
      1.031694,
      1,
      1,
      1,
      0.271012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1,
      3,
      0.589539,
      4.659121,
      1,
      3,
      3,
      3.339092,
      NULL,
      0.448262,
      NULL,
      1,
      NULL,
      1.969510,
      0.453490,
      NULL,
      NULL,
      1.909618,
      NULL,
      NULL,
      2.175047,
      NULL,
      0.691554,
      0.954306,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      0.494612,
      NULL,
      0.952239,
      1.541884,
      NULL,
      1.810531,
      3.001270,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.437854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.215861,
      0,
      0,
      21.611134,
      69.585207,
      2,
      5,
      NULL,
      '43200',
      '',
      '',
      1.234743,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


