set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8330912';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1.621967,
      1,
      3,
      3,
      '1030',
      NULL,
      1.307599,
      NULL,
      NULL,
      '11-25-1975',
      36,
      NULL,
      5,
      1.500849,
      0.334476,
      ' 5-15-1985',
      48,
      0,
      215.780963,
      11,
      NULL,
      ' 1-25-1980',
      ' 9-13-1974',
      ' 0- 2-1998',
      3,
      3.613011,
      NULL,
      2,
      NULL,
      1.368984,
      1,
      0.359127,
      0.246132,
      5.027175,
      8,
      NULL,
      1.985045,
      4.805698,
      22.438382,
      5,
      21.220580,
      5,
      2,
      4.888533,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      0,
      3,
      2,
      NULL,
      1.525709,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      4,
      2,
      NULL,
      NULL,
      2.656433,
      0,
      0,
      NULL,
      1,
      0.136365,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      1.144798,
      1.917949,
      0.058638,
      0.412643,
      3,
      NULL,
      0.027176,
      NULL,
      3.694231,
      3.127198,
      2.727909,
      NULL,
      1,
      1.245371,
      1.860712,
      3,
      NULL,
      3,
      NULL,
      1,
      3.331724,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0.411130,
      0,
      2,
      NULL,
      4,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      5,
      1,
      3,
      1,
      0,
      4,
      4,
      0,
      5,
      NULL,
      0,
      0,
      1,
      3.934094,
      ' 2- 7-1984',
      NULL,
      NULL,
      139.365201,
      3.684425,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      1,
      3,
      0.689556,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.654983,
      0.752256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.965622,
      3,
      1,
      0,
      1,
      0.847218,
      1.842513,
      0.379382,
      48.692521,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      2,
      NULL,
      1,
      NULL,
      1,
      2,
      3,
      0,
      3,
      NULL,
      NULL,
      2,
      3.176545,
      0,
      0.829999,
      5.893475,
      1.361556,
      1.832526,
      NULL,
      NULL,
      1,
      1,
      1.913628,
      0.095378,
      0,
      1.142592,
      0,
      0.374124,
      1,
      5,
      2,
      NULL,
      5,
      NULL,
      2,
      3,
      NULL,
      1.993088,
      2.750099,
      1,
      58,
      1,
      2,
      NULL,
      71,
      70,
      24.075450,
      NULL,
      0,
      1,
      NULL,
      '21101',
      '20241',
      1.005742,
      '',
      '',
      '',
      1,
      '40403',
      '',
      NULL,
      NULL,
      33.929440,
      NULL,
      40.354299,
      NULL,
      19,
      5,
      0.288518,
      2,
      NULL,
      1.657374,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.058949,
      3,
      NULL,
      0.386981,
      NULL,
      1,
      1.563098,
      1,
      3.699378,
      0,
      NULL,
      0,
      NULL,
      0.458923,
      NULL,
      0.604199,
      1,
      1,
      NULL,
      NULL,
      5.875276,
      NULL,
      NULL,
      1,
      1.693576,
      NULL,
      NULL,
      NULL,
      1.587980,
      NULL,
      NULL,
      NULL,
      3.282218,
      NULL,
      2,
      3,
      NULL,
      1.940955,
      0.427593,
      NULL,
      1,
      NULL,
      1.554996,
      0,
      3,
      1.754746,
      1,
      0.124249,
      3,
      1.269061,
      3.274100,
      3,
      1.599714,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.859068,
      3.524531,
      1,
      NULL,
      NULL,
      2.676549,
      3.199463,
      0,
      0.793140,
      6,
      2,
      1,
      0.400045,
      NULL,
      NULL,
      NULL,
      0.138989,
      NULL,
      NULL,
      NULL,
      1.768603,
      NULL,
      NULL,
      3,
      1.479195,
      NULL,
      0.009887,
      0,
      2.054766,
      0,
      NULL,
      NULL,
      1,
      1.338420,
      5,
      1.636665,
      0.533101,
      0,
      NULL,
      0,
      0.644710,
      2.322167,
      0,
      0,
      1.511112,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.228910,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.127985,
      0,
      NULL,
      NULL,
      NULL,
      1.935586,
      1.042572,
      0,
      3.541761,
      1.009437,
      NULL,
      2.950376,
      3.929344,
      5,
      0.440621,
      NULL,
      NULL,
      1,
      NULL,
      0.991174,
      1.297388,
      NULL,
      NULL,
      3,
      0.969633,
      2.600278,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.562362,
      2,
      1,
      NULL,
      2,
      1,
      1,
      4,
      NULL,
      2,
      0.653776,
      NULL,
      NULL,
      1,
      1,
      4,
      1.886753,
      1.663486,
      0.458088,
      NULL,
      1.957338,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.038896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.013301,
      NULL,
      NULL,
      1.921421,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.467801,
      0,
      1.560510,
      3,
      1.537530,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      1.518275,
      NULL,
      NULL,
      NULL,
      2.923103,
      NULL,
      NULL,
      NULL,
      0.350188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.017527,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877087,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.248765,
      NULL,
      NULL,
      NULL,
      0.479253,
      7,
      1.976081,
      NULL,
      24,
      0,
      1,
      NULL,
      NULL,
      1.888914,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      407.744678,
      13,
      0,
      3.617755,
      1,
      NULL,
      NULL,
      0,
      0.110337,
      2,
      1.279064,
      3.523856,
      0.221342,
      1.226160,
      1,
      NULL,
      1,
      0,
      NULL,
      1.219749,
      NULL,
      1,
      NULL,
      1.416963,
      NULL,
      1,
      NULL,
      2.148256,
      NULL,
      1.425091,
      NULL,
      36,
      NULL,
      NULL,
      18.917060,
      7.514050,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.339199,
      NULL,
      0.750465,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.427222,
      NULL,
      0.809344,
      NULL,
      1.144976,
      NULL,
      0.809664,
      NULL,
      0,
      2.206957,
      0.079438,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.094867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.848595,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.338027,
      1.558317,
      2.900263,
      NULL,
      2.661314,
      NULL,
      1.484957,
      NULL,
      1010.162828,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.005582,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.472083,
      NULL,
      3.394182,
      NULL,
      3.593149,
      NULL,
      9.655796,
      NULL,
      0,
      1,
      1.329502,
      NULL,
      2.938271,
      NULL,
      3.094758,
      NULL,
      NULL,
      NULL,
      0.331198,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.814547,
      12.989662,
      36.966847,
      2.054271,
      0,
      1.968363,
      1,
      1,
      1,
      NULL,
      1.098814,
      1,
      NULL,
      0.733060,
      1,
      0,
      2,
      2.877546,
      1.594720,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.835391,
      0,
      NULL,
      1,
      0.507415,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.669609,
      1.696483,
      NULL,
      1,
      3,
      NULL,
      1.147246,
      1,
      NULL,
      0,
      1.962518,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.231035,
      NULL,
      1,
      5,
      2,
      1.178699,
      NULL,
      NULL,
      15.138083,
      102.936177,
      1,
      1.952170,
      6.903631,
      '44112',
      '33133',
      '21223',
      1.706303,
      '',
      '',
      '',
      2.121557,
      '32413',
      '',
      '');
commit;
end;
/


