set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9014854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '4021030',
      1,
      0.857853,
      3,
      3,
      '0020',
      2,
      0.800503,
      NULL,
      NULL,
      ' 9- 8-1989',
      NULL,
      NULL,
      3,
      1,
      1.385182,
      ' 2-21-1988',
      32,
      1.425185,
      234.081480,
      NULL,
      2,
      ' 5-14-1987',
      ' 3-22-1992',
      ' 8-16-1993',
      1.093153,
      1.256942,
      0.198277,
      1,
      0,
      3.271240,
      0,
      0.056030,
      NULL,
      618.191831,
      0,
      2,
      3.852271,
      7.642980,
      9.488335,
      0,
      10.290147,
      NULL,
      1,
      9.247535,
      1,
      NULL,
      NULL,
      NULL,
      1.274214,
      1,
      1,
      1.871072,
      1.476276,
      1,
      98.589384,
      6,
      5,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      2,
      NULL,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.719750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      4,
      1,
      4,
      1,
      0,
      0,
      0,
      3,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1.458369,
      4,
      1,
      NULL,
      1,
      4,
      5,
      5,
      2,
      1,
      1,
      NULL,
      0,
      NULL,
      2,
      3,
      1,
      4,
      1,
      4,
      2,
      0,
      0,
      4,
      NULL,
      2,
      NULL,
      2,
      ' 1- 3-1975',
      1874.786905,
      ' 5-12-1979',
      NULL,
      NULL,
      0,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969444,
      3.196546,
      NULL,
      0.898414,
      NULL,
      2.910799,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642603,
      0,
      0.681173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714046,
      0,
      1.901788,
      0,
      0.552836,
      0.120098,
      0,
      0.591042,
      17405.291239,
      1.518098,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2,
      1,
      2,
      2,
      1,
      2,
      3,
      NULL,
      0,
      3,
      1.288188,
      NULL,
      1,
      0,
      0.123428,
      0.353031,
      9,
      1.531576,
      0.999605,
      0,
      1,
      1.184602,
      0.419607,
      1.997144,
      0,
      0,
      0.344124,
      0,
      1.911400,
      2,
      NULL,
      1.867825,
      3,
      1.007783,
      0.835096,
      0.479811,
      NULL,
      1,
      1,
      NULL,
      0,
      29,
      1,
      2,
      NULL,
      32,
      2,
      17.005743,
      NULL,
      1.863516,
      4.531678,
      NULL,
      '33334',
      '',
      1.969881,
      '',
      '',
      '',
      NULL,
      '0320',
      '',
      '',
      1.582754,
      31.687782,
      309.153088,
      0.662869,
      0.116969,
      NULL,
      NULL,
      NULL,
      NULL,
      2.917972,
      1.486337,
      0,
      0.698595,
      NULL,
      NULL,
      1.174582,
      NULL,
      NULL,
      0.030974,
      3,
      3.019902,
      1.792876,
      NULL,
      NULL,
      0.108355,
      NULL,
      NULL,
      NULL,
      3,
      0.729816,
      0.031836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988516,
      NULL,
      NULL,
      1.725883,
      6.946907,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.922212,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.783992,
      1,
      1.926264,
      0.139782,
      1,
      NULL,
      0,
      1.741888,
      1,
      0.399486,
      1.794217,
      1.050580,
      0,
      0.689432,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      6.003678,
      0.600957,
      1,
      0.632803,
      NULL,
      NULL,
      NULL,
      0.516480,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.257833,
      1,
      1.953605,
      NULL,
      NULL,
      NULL,
      7.280002,
      1,
      NULL,
      NULL,
      1,
      1.912395,
      NULL,
      NULL,
      6,
      1.413897,
      1.572613,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.398901,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.295947,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.832632,
      0.448557,
      2,
      2,
      2,
      6.522429,
      0,
      NULL,
      0.624433,
      0,
      9.741710,
      1.363694,
      0,
      NULL,
      NULL,
      1,
      2,
      2,
      0.805680,
      2,
      NULL,
      9.230626,
      3,
      NULL,
      1,
      NULL,
      3.919998,
      2,
      3.574610,
      2,
      2,
      1.533652,
      1,
      3,
      NULL,
      1,
      1.602561,
      8,
      3.545647,
      8.189095,
      4,
      5.487051,
      1,
      2,
      NULL,
      1.160476,
      1.722859,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.840728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.721176,
      NULL,
      NULL,
      1.582768,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.989339,
      NULL,
      NULL,
      1.982732,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.954731,
      1.679165,
      2,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      1.438954,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.349951,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.266449,
      NULL,
      NULL,
      NULL,
      0.250735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.273601,
      NULL,
      NULL,
      NULL,
      1.267331,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.214852,
      NULL,
      NULL,
      NULL,
      11.417117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.420529,
      462.674378,
      108.845538,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.411333,
      NULL,
      NULL,
      0.501858,
      NULL,
      NULL,
      1.301192,
      NULL,
      NULL,
      1.425223,
      91,
      1,
      13893,
      1930,
      0,
      NULL,
      0.663035,
      1,
      NULL,
      1.731067,
      0.769135,
      1.567491,
      1.294580,
      1,
      0.798473,
      0,
      0,
      0,
      1,
      1,
      0.258915,
      0.366873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0.669708,
      0.126103,
      0.987604,
      1,
      5.612962,
      3,
      3.795339,
      1,
      0,
      NULL,
      NULL,
      3,
      1.768299,
      NULL,
      2.856778,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0.163582,
      NULL,
      NULL,
      3.340626,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.054164,
      NULL,
      NULL,
      1,
      0.008774,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.281390,
      NULL,
      1.179916,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3,
      34.819329,
      39.825114,
      5,
      0.716128,
      1.722564,
      '03131',
      '43141',
      '',
      0,
      '',
      '',
      '',
      2.935931,
      '3332',
      '',
      '');
commit;
end;
/


