set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8700949';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30',
      '41',
      24.691425,
      NULL,
      '3041233',
      0.181884,
      0.751517,
      3,
      1,
      '0220',
      4.778323,
      0,
      NULL,
      NULL,
      NULL,
      92.760167,
      9,
      NULL,
      0,
      1.175529,
      ' 9-12-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 6- 6-1986',
      ' 6-20-1976',
      '10-14-1978',
      1,
      3.142981,
      1,
      2,
      1.689495,
      NULL,
      4,
      1,
      0.894784,
      NULL,
      NULL,
      17,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      0,
      1,
      1,
      0,
      1,
      3.540506,
      NULL,
      0,
      1.569990,
      1.017953,
      1,
      2,
      1,
      2,
      1.429033,
      4,
      0,
      0,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0,
      NULL,
      0,
      2,
      1,
      2,
      NULL,
      2,
      0.389020,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      1.256347,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1.037183,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      1,
      1,
      NULL,
      0,
      1,
      2,
      1,
      0,
      3,
      1,
      1,
      2,
      2,
      5,
      4,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      681,
      ' 4- 1-1990',
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      2,
      NULL,
      0,
      0,
      1.441481,
      4,
      0.778917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.137119,
      1.519412,
      NULL,
      NULL,
      NULL,
      1.602129,
      0.309801,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672910,
      1.838703,
      NULL,
      0.594601,
      0.111104,
      0.205783,
      1.564282,
      2.982239,
      40,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.096241,
      2,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.462516,
      NULL,
      0,
      NULL,
      1,
      5.523379,
      1,
      NULL,
      3,
      1.025174,
      0,
      NULL,
      0.171732,
      0,
      NULL,
      1.162441,
      NULL,
      NULL,
      NULL,
      NULL,
      4.649634,
      9,
      10,
      1.773938,
      2.881141,
      0.640043,
      NULL,
      0,
      NULL,
      1.547427,
      NULL,
      0,
      NULL,
      3,
      NULL,
      47,
      45,
      4,
      NULL,
      3.255428,
      '30430',
      NULL,
      '',
      1.155226,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      18.251186,
      NULL,
      NULL,
      NULL,
      0,
      1.716024,
      3,
      3,
      0.846904,
      3,
      1.307889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879990,
      NULL,
      NULL,
      1,
      0.620884,
      0,
      NULL,
      2.336202,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537389,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.746700,
      8.359112,
      1.720440,
      1,
      0.852106,
      NULL,
      NULL,
      NULL,
      0.894929,
      NULL,
      NULL,
      NULL,
      1,
      3.090443,
      1,
      0.471273,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.838309,
      1,
      1.225831,
      1,
      0.862509,
      1,
      1,
      2,
      1,
      0.036235,
      1,
      NULL,
      1,
      0.791433,
      1.733779,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231055,
      1,
      0.976087,
      4,
      7,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.408059,
      1.622672,
      NULL,
      2,
      3.762386,
      1,
      0.864591,
      NULL,
      NULL,
      6.474542,
      NULL,
      2.982391,
      0.672146,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.268660,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.678010,
      NULL,
      NULL,
      7.790656,
      1,
      2.761287,
      1,
      NULL,
      NULL,
      0.701888,
      NULL,
      NULL,
      2.192662,
      2,
      1.418984,
      2.695585,
      0,
      0,
      7.928732,
      0.904672,
      NULL,
      NULL,
      0.516803,
      0.391653,
      1,
      3.599678,
      NULL,
      3,
      NULL,
      0.564191,
      NULL,
      3,
      3,
      0.074721,
      1,
      2.881015,
      2.338230,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.049688,
      NULL,
      NULL,
      2.232503,
      NULL,
      NULL,
      1.766177,
      NULL,
      NULL,
      7.870417,
      NULL,
      NULL,
      0.720146,
      0.620502,
      1.482953,
      NULL,
      0,
      3.228977,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.769870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.577547,
      NULL,
      NULL,
      NULL,
      0.917336,
      NULL,
      NULL,
      NULL,
      0.705395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.326251,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9.157553,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.668823,
      NULL,
      NULL,
      3,
      5.881521,
      0,
      NULL,
      NULL,
      NULL,
      1.467715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      66,
      NULL,
      NULL,
      NULL,
      1.144246,
      1,
      NULL,
      0,
      0,
      0.592125,
      0.491071,
      0.873377,
      0.790054,
      0,
      NULL,
      NULL,
      1,
      1.275795,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.994592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443146,
      0.277514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380227,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.254649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.366586,
      NULL,
      1,
      1.831883,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.435122,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      6.048719,
      0,
      13.006226,
      2,
      0,
      1,
      0,
      1.649531,
      NULL,
      NULL,
      1.568364,
      NULL,
      2,
      3,
      NULL,
      1,
      0,
      NULL,
      0.577245,
      3,
      NULL,
      0.863929,
      0,
      NULL,
      1.647309,
      2.290227,
      NULL,
      2,
      3,
      NULL,
      1.019615,
      0,
      NULL,
      1,
      2.255675,
      NULL,
      0.795466,
      0,
      NULL,
      3,
      1.227119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348186,
      NULL,
      1.966616,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      3,
      0,
      1,
      18.158893,
      51.702331,
      NULL,
      2,
      1,
      '02202',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.483077,
      NULL,
      '',
      '');
commit;
end;
/


