set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6850715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.544898,
      3.307662,
      3.166800,
      2.109039,
      NULL,
      0,
      NULL,
      NULL,
      '242',
      '33121311',
      52.116845,
      10.795408,
      '0323130',
      NULL,
      NULL,
      NULL,
      2,
      '3231',
      0,
      NULL,
      NULL,
      NULL,
      ' 2- 3-1993',
      20,
      86,
      NULL,
      0,
      4,
      ' 1- 1-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1990',
      ' 9-21-1992',
      ' 1-11-2001',
      2.976977,
      3.504435,
      1.833032,
      0,
      1.936533,
      1,
      NULL,
      0.052741,
      1.926911,
      NULL,
      5,
      0.695262,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      1,
      NULL,
      1,
      1.985212,
      1.911161,
      0.283532,
      1.141889,
      0,
      0.576477,
      NULL,
      NULL,
      NULL,
      6,
      6,
      NULL,
      1,
      1,
      2,
      0,
      5,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      8.515393,
      2,
      1,
      1,
      NULL,
      0.864634,
      NULL,
      NULL,
      1.479535,
      1,
      1,
      3,
      0,
      NULL,
      0,
      1,
      NULL,
      3,
      1.193742,
      0.954343,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.197223,
      NULL,
      2.856564,
      0.885993,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.002093,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      4,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1.397369,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      1,
      NULL,
      4,
      0,
      1,
      0,
      0,
      NULL,
      2,
      2,
      2,
      5,
      1,
      NULL,
      NULL,
      3,
      3,
      ' 8-18-1986',
      2257.967138,
      NULL,
      1555,
      0,
      0,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      1,
      1.974733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.658755,
      1,
      0.664500,
      5,
      NULL,
      0,
      3.683555,
      NULL,
      9,
      5,
      0.306185,
      NULL,
      1.572963,
      NULL,
      0,
      5,
      1,
      6.797708,
      NULL,
      NULL,
      0.452890,
      2.211672,
      NULL,
      NULL,
      NULL,
      0.582369,
      8,
      3,
      1,
      0,
      2,
      7.971600,
      ' 8-13-1996',
      855.938372,
      '11- 7-1993',
      1192.827014,
      0.478859,
      2,
      1.185221,
      1,
      1,
      NULL,
      0.345455,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2,
      1.691718,
      NULL,
      NULL,
      NULL,
      1,
      1.972851,
      0.598058,
      2,
      0,
      NULL,
      3,
      2,
      3,
      2,
      2,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.550844,
      1.154756,
      0.136554,
      0.182957,
      NULL,
      0.371152,
      NULL,
      NULL,
      0,
      0.234088,
      9,
      0,
      2.010782,
      NULL,
      11,
      0,
      1,
      NULL,
      NULL,
      1.535357,
      1,
      NULL,
      44.978669,
      3,
      1.755092,
      38,
      NULL,
      24,
      NULL,
      3,
      3.585798,
      NULL,
      '04334',
      NULL,
      '',
      1.318057,
      NULL,
      NULL,
      '',
      3,
      '3411',
      NULL,
      '',
      1,
      8.421674,
      73,
      56,
      0,
      42.905336,
      8,
      0.344698,
      0,
      2.120560,
      3,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      2,
      1.519243,
      2.861618,
      0,
      0,
      1.739699,
      3,
      0,
      1,
      0,
      2,
      3.751476,
      0.684034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4.364084,
      1,
      0.097081,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.037525,
      0,
      1.257627,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.562718,
      NULL,
      NULL,
      0,
      1,
      1.436082,
      3,
      NULL,
      0,
      1.626426,
      0.673175,
      1,
      0,
      1,
      0.585713,
      1.375294,
      2.484992,
      0.513974,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.726451,
      1.545605,
      0.808197,
      1.541240,
      0,
      8,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.913473,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.291248,
      NULL,
      NULL,
      NULL,
      2.369142,
      1.992147,
      0,
      3,
      1.614607,
      5,
      2.993594,
      1.202349,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.615176,
      NULL,
      NULL,
      0.481024,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      4.903290,
      5,
      0.157070,
      1,
      4,
      1,
      0.191313,
      2,
      0.324286,
      1,
      0,
      NULL,
      1.864533,
      2,
      3.668748,
      3.088455,
      NULL,
      3,
      5,
      0.685529,
      1,
      3.321824,
      3,
      3.266683,
      1.008481,
      3,
      3.313655,
      NULL,
      2,
      NULL,
      0,
      2.273027,
      NULL,
      4,
      4,
      2,
      2,
      3.738050,
      0,
      3,
      NULL,
      0,
      1,
      0.111014,
      1.902373,
      NULL,
      NULL,
      NULL,
      0.680271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362284,
      NULL,
      NULL,
      0.497229,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.235313,
      NULL,
      NULL,
      1.806872,
      NULL,
      NULL,
      2.045533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      3,
      3,
      1,
      NULL,
      1,
      7,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      3.880724,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.601612,
      NULL,
      NULL,
      NULL,
      2.069606,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.438113,
      NULL,
      1.456231,
      NULL,
      1.384528,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.636240,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.292345,
      NULL,
      NULL,
      NULL,
      1.974783,
      NULL,
      0.023729,
      NULL,
      3,
      NULL,
      1.678142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.498014,
      NULL,
      1,
      NULL,
      0.577428,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3.347806,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.377372,
      NULL,
      12,
      NULL,
      15.337440,
      NULL,
      0,
      NULL,
      NULL,
      3.862040,
      NULL,
      3,
      2.070599,
      NULL,
      16,
      1.723459,
      11.730238,
      2.600700,
      0.145286,
      NULL,
      NULL,
      2.270694,
      4,
      9,
      0,
      0.255656,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.714558,
      0,
      NULL,
      0,
      NULL,
      1.277919,
      NULL,
      0,
      NULL,
      0.116524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.481947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.611736,
      1,
      0.894926,
      1.608364,
      1,
      4.178626,
      1,
      NULL,
      0,
      0,
      0.432295,
      NULL,
      2,
      3,
      NULL,
      0,
      1.232444,
      NULL,
      NULL,
      0.667360,
      NULL,
      2,
      2.583462,
      NULL,
      NULL,
      3,
      NULL,
      2.588882,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264735,
      0,
      NULL,
      0.332264,
      NULL,
      NULL,
      NULL,
      0.979879,
      NULL,
      NULL,
      0.529755,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.245216,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.888116,
      NULL,
      2,
      NULL,
      0.295916,
      NULL,
      1,
      NULL,
      52,
      NULL,
      NULL,
      0.800275,
      NULL,
      3,
      NULL,
      1.943539,
      NULL,
      2,
      2,
      6,
      1.938624,
      NULL,
      NULL,
      25,
      42,
      1,
      2,
      2.991477,
      NULL,
      '44030',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '');
commit;
end;
/


