set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9612120';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '1103334',
      3.040832,
      1,
      6,
      3,
      '1441',
      NULL,
      1,
      NULL,
      NULL,
      ' 6-13-1998',
      10,
      NULL,
      1,
      3,
      3.971774,
      ' 3- 6-1991',
      25.226838,
      1,
      343.678807,
      68,
      NULL,
      ' 0- 1-1991',
      ' 9- 0-1985',
      ' 9- 7-1997',
      NULL,
      0,
      1,
      NULL,
      1.529254,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.966744,
      25.130865,
      24.867959,
      1,
      16.131739,
      3,
      3,
      4.621028,
      0,
      1,
      1,
      1,
      1.677239,
      0.600020,
      1,
      1.066812,
      0,
      2,
      1,
      0,
      2,
      6,
      1.108685,
      4,
      NULL,
      1,
      NULL,
      4,
      5,
      3,
      0,
      0,
      2,
      0,
      1,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.559210,
      NULL,
      NULL,
      NULL,
      0,
      0.303775,
      NULL,
      2,
      0,
      3,
      NULL,
      NULL,
      3.195383,
      NULL,
      1.783039,
      1.134179,
      NULL,
      NULL,
      1.205658,
      1,
      0,
      1.840245,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      1.002376,
      0,
      NULL,
      NULL,
      0.752358,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1.976650,
      NULL,
      1,
      3,
      0,
      1,
      1,
      NULL,
      3,
      5,
      4,
      2,
      2,
      1,
      0,
      3,
      0,
      1,
      0,
      0,
      NULL,
      5,
      0,
      NULL,
      5,
      5,
      0,
      1,
      6,
      0.494074,
      NULL,
      31,
      ' 2-13-1991',
      3.893440,
      1,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.815493,
      0.162724,
      2,
      3,
      5.000467,
      0,
      NULL,
      NULL,
      0,
      3.190752,
      NULL,
      6,
      0.694106,
      NULL,
      0.225645,
      1.090509,
      0,
      NULL,
      0.102940,
      NULL,
      NULL,
      1.342940,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.135183,
      NULL,
      1,
      1,
      NULL,
      1,
      1.984118,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.202998,
      3,
      3,
      3,
      0,
      NULL,
      3,
      3,
      NULL,
      2,
      0,
      NULL,
      2.687781,
      1.022261,
      3.654211,
      0.967823,
      1.822904,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.881965,
      0.062658,
      0.507428,
      1,
      3,
      5.502288,
      0.325875,
      7,
      10,
      1.460928,
      6,
      NULL,
      3.464434,
      2.296435,
      NULL,
      NULL,
      3,
      1.362764,
      1.489998,
      26,
      1,
      3,
      NULL,
      26,
      1,
      54,
      4,
      5.966625,
      1.866193,
      '20043',
      '',
      '',
      0.201205,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      3.616253,
      34,
      32,
      44.987608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.764286,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.514901,
      NULL,
      NULL,
      1.529316,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.692997,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.577551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.521644,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.864780,
      NULL,
      NULL,
      1.257428,
      NULL,
      NULL,
      0.435915,
      NULL,
      NULL,
      0.386261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513923,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.116350,
      NULL,
      NULL,
      1.649174,
      NULL,
      NULL,
      NULL,
      1.750058,
      3,
      1.945702,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      3.413625,
      1.318560,
      0,
      NULL,
      NULL,
      1.265626,
      NULL,
      NULL,
      1.925424,
      2,
      1.900844,
      2.722563,
      1,
      2,
      6,
      3.691076,
      7.249796,
      3.091614,
      1.519110,
      3,
      NULL,
      1,
      2.498967,
      1,
      NULL,
      2,
      1.467326,
      1,
      0,
      7.343520,
      NULL,
      7,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.959278,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302514,
      NULL,
      0,
      1.402624,
      1.874433,
      0.346918,
      0.908809,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.064246,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.146103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.374692,
      NULL,
      NULL,
      NULL,
      0.760065,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.438154,
      NULL,
      NULL,
      NULL,
      2.499483,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.427426,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748483,
      NULL,
      NULL,
      NULL,
      2,
      1.532080,
      0.172441,
      0.303819,
      2,
      0.407503,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.318515,
      NULL,
      NULL,
      0.198751,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      17,
      2.959605,
      1,
      NULL,
      2.508827,
      NULL,
      0.937606,
      0,
      0.354039,
      1,
      1.608515,
      1.995832,
      NULL,
      NULL,
      0,
      NULL,
      1.052732,
      2.359702,
      NULL,
      1.113949,
      1,
      0.940785,
      2.403204,
      1.221998,
      NULL,
      NULL,
      1,
      1.688559,
      3.157348,
      NULL,
      25.432100,
      1.234225,
      0.007824,
      2.162680,
      NULL,
      1.587002,
      0.058182,
      1,
      NULL,
      1.546079,
      NULL,
      0,
      NULL,
      0.145102,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.130319,
      NULL,
      1.449081,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.057566,
      NULL,
      1,
      NULL,
      1,
      3.323414,
      0.652391,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703960,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      0.831052,
      NULL,
      26,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.606876,
      0,
      0.978960,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.298607,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.327672,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.921359,
      NULL,
      NULL,
      NULL,
      0.090206,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      3,
      1.331721,
      0.080596,
      NULL,
      NULL,
      NULL,
      0.793768,
      NULL,
      0.283341,
      1.253301,
      1.946084,
      2.777081,
      2,
      8,
      NULL,
      NULL,
      1,
      3.498389,
      NULL,
      0,
      1,
      1,
      NULL,
      0.035717,
      1,
      3.981567,
      2,
      6.415538,
      1.767196,
      1,
      0.549027,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.551319,
      NULL,
      1.275755,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.128714,
      NULL,
      0,
      1.460835,
      NULL,
      1,
      1.751830,
      NULL,
      NULL,
      0.692298,
      1.240411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98,
      55.023388,
      2,
      3,
      1.561493,
      '13322',
      '41203',
      '11430',
      0.230340,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


