set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      2.412990,
      NULL,
      NULL,
      NULL,
      ' 4-19-1975',
      40,
      NULL,
      0,
      NULL,
      2,
      ' 9-22-1981',
      40.917236,
      2.030726,
      6,
      NULL,
      2,
      ' 2-25-1984',
      ' 3-10-1980',
      '11-14-1993',
      0,
      2.140451,
      NULL,
      0.553307,
      1,
      2.030878,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.150211,
      10.117716,
      4.743941,
      NULL,
      21.571547,
      1,
      1,
      NULL,
      0.855414,
      1,
      0,
      1.247047,
      1,
      0,
      0.691882,
      0.023475,
      0,
      2,
      1.971422,
      0,
      1,
      3,
      1,
      5,
      1,
      0,
      5,
      NULL,
      5,
      0,
      0,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1.872714,
      NULL,
      NULL,
      1.025306,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      5,
      6,
      1,
      1,
      1.089788,
      0,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      4,
      3,
      NULL,
      4,
      4,
      1,
      NULL,
      0,
      5,
      0,
      NULL,
      NULL,
      2.778015,
      0,
      NULL,
      1,
      0,
      0.455150,
      NULL,
      NULL,
      0,
      1,
      3,
      3,
      0,
      2,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      2,
      0,
      4,
      3,
      2,
      NULL,
      3,
      0,
      2,
      1,
      5,
      NULL,
      NULL,
      0.520750,
      ' 1-24-1988',
      92.359309,
      ' 0-16-1987',
      10.165821,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      4,
      1,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8,
      2.043032,
      1,
      4,
      1.331492,
      0,
      1,
      0.705922,
      5.968806,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.895241,
      0,
      4.825282,
      NULL,
      5.744671,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      5,
      3,
      6,
      ' 7-13-2000',
      7.561154,
      ' 0- 8-2003',
      7.052328,
      1,
      0,
      0,
      NULL,
      2.638753,
      1,
      2,
      0,
      0.154550,
      1,
      2,
      49,
      1.011527,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      3,
      1,
      1,
      1,
      NULL,
      0,
      2,
      0,
      2,
      1,
      0.306005,
      0.847575,
      3,
      7.664830,
      1.666807,
      NULL,
      4.204114,
      0,
      0,
      NULL,
      0.258745,
      0,
      0.738495,
      0,
      1,
      0,
      0,
      2,
      NULL,
      6.886496,
      NULL,
      NULL,
      NULL,
      0,
      0.363430,
      3,
      1,
      4.380766,
      0,
      NULL,
      2,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      4,
      0,
      NULL,
      '40043',
      '',
      '',
      3.704324,
      '1204',
      '',
      '',
      3,
      '30401',
      '',
      '',
      2,
      47.356764,
      7,
      14,
      1.967045,
      NULL,
      NULL,
      NULL,
      NULL,
      3.943898,
      1,
      1.252375,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.490260,
      3,
      3.980591,
      3.066210,
      3,
      1.704680,
      0.643366,
      2,
      0.581620,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.809421,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.967530,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473629,
      NULL,
      NULL,
      1.728990,
      NULL,
      NULL,
      1.118489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414931,
      NULL,
      NULL,
      1.992250,
      NULL,
      NULL,
      0.961219,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333605,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      1.067796,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.740060,
      NULL,
      NULL,
      0.477144,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.904488,
      NULL,
      NULL,
      2,
      3.687138,
      0.505405,
      3,
      5,
      2,
      0,
      5.371431,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.237966,
      NULL,
      2.978463,
      0,
      2.505044,
      0,
      4,
      2.304212,
      NULL,
      0,
      3.081807,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.587412,
      0.493694,
      NULL,
      2.223090,
      NULL,
      3,
      NULL,
      3.972606,
      NULL,
      NULL,
      4.661556,
      1.846012,
      NULL,
      NULL,
      NULL,
      0,
      1.780899,
      1,
      1,
      0.241252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742254,
      0,
      1,
      1,
      NULL,
      0,
      1.640023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.432365,
      1.597265,
      0.964394,
      1.660432,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.653048,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.772739,
      NULL,
      NULL,
      494,
      12.701430,
      0,
      0.803502,
      NULL,
      1,
      1.633753,
      NULL,
      NULL,
      1,
      1.668340,
      1.918871,
      0.622365,
      1.112317,
      1.769792,
      0.937656,
      1.490773,
      1,
      1.092995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      7.890492,
      4,
      0.669609,
      0,
      1,
      5.458776,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      NULL,
      0.804797,
      3,
      NULL,
      0,
      1.812367,
      NULL,
      NULL,
      1.659106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101749,
      3.968083,
      NULL,
      NULL,
      1,
      NULL,
      1.176682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.666818,
      NULL,
      1.896650,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      35,
      4,
      4.929856,
      2,
      '32314',
      '',
      '',
      0.968415,
      '0322',
      '',
      '',
      2,
      NULL,
      '',
      '');
commit;
end;
/


