set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9507976';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      1.575599,
      NULL,
      2,
      2,
      0,
      0,
      2.914037,
      '202',
      '02030432',
      44,
      9,
      '0101444',
      3,
      NULL,
      1,
      3,
      '4013',
      1.293016,
      1.864626,
      NULL,
      NULL,
      ' 4-16-1999',
      39.347459,
      47,
      NULL,
      3,
      1.502505,
      ' 1-21-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-15-1983',
      0.725523,
      0,
      3.048939,
      NULL,
      NULL,
      0.302545,
      NULL,
      3.104547,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.975861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      2,
      5,
      0,
      0,
      1,
      1,
      NULL,
      4,
      NULL,
      NULL,
      1,
      1,
      1,
      5,
      0,
      2,
      0,
      1,
      1.139404,
      NULL,
      NULL,
      0.854804,
      NULL,
      NULL,
      1,
      1,
      1.687591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.602726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      1,
      4,
      1,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1.044855,
      1,
      0,
      0,
      0,
      1.050726,
      NULL,
      1,
      2,
      3,
      0,
      0,
      0,
      NULL,
      3,
      1,
      1,
      1,
      1,
      3,
      0,
      3,
      0,
      4,
      4,
      2,
      1,
      NULL,
      0,
      0,
      4,
      3,
      1,
      1.100334,
      1.400206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      7,
      1.946943,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717909,
      1,
      3.473193,
      5,
      NULL,
      0.406126,
      0.434113,
      NULL,
      NULL,
      NULL,
      0.336724,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.290675,
      0.104210,
      NULL,
      0.773994,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2,
      0,
      2,
      3,
      1,
      2,
      NULL,
      NULL,
      0,
      2.956016,
      1.392951,
      NULL,
      7,
      0,
      NULL,
      1.689037,
      1,
      0,
      NULL,
      1,
      0,
      1.199514,
      1,
      0.588776,
      1,
      NULL,
      2,
      0.136825,
      10.036095,
      NULL,
      1.427127,
      2.172053,
      NULL,
      5,
      5.463405,
      2,
      4,
      1,
      3,
      0,
      28.037513,
      1,
      0.583657,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5.305257,
      0,
      '10342',
      NULL,
      '',
      NULL,
      '41104',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      2.944042,
      40,
      108,
      NULL,
      3,
      7.529589,
      3,
      4,
      1,
      3.716935,
      3.911133,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.129376,
      0.425008,
      1.510383,
      0,
      NULL,
      0,
      0,
      0,
      1.557635,
      0,
      NULL,
      3.031871,
      0.914508,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.995223,
      7,
      4.860305,
      NULL,
      0.886772,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.451078,
      0.457841,
      1,
      0.284688,
      1.792049,
      0.161752,
      NULL,
      NULL,
      0.854088,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.714038,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118838,
      0,
      5,
      4,
      0.988469,
      1,
      0.582047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1.896709,
      2,
      0.786936,
      NULL,
      0.316439,
      NULL,
      NULL,
      3,
      7.202743,
      NULL,
      3.125851,
      1.252807,
      1.224475,
      0.256074,
      NULL,
      NULL,
      7,
      9,
      0.788014,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.263259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.904542,
      0.385272,
      3.348221,
      0.427394,
      NULL,
      5.009961,
      1.563323,
      5.565105,
      1,
      4,
      3.594378,
      0,
      10,
      1,
      0,
      NULL,
      NULL,
      3,
      0,
      2,
      2,
      3.084810,
      1,
      0,
      6.633348,
      5,
      0.019262,
      1.710834,
      3,
      2.097856,
      3,
      1.828327,
      1.467263,
      0.276776,
      0,
      0.402504,
      1.079562,
      0.976460,
      4,
      6.641212,
      4.857773,
      NULL,
      1,
      0,
      3.420455,
      0,
      3,
      0.924638,
      1.725150,
      1.632888,
      0.244766,
      0.143506,
      3.779283,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.097777,
      NULL,
      NULL,
      0.454295,
      NULL,
      NULL,
      0.748683,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.505499,
      NULL,
      NULL,
      1.696731,
      0,
      2,
      1.512786,
      NULL,
      3,
      1,
      NULL,
      8,
      3.107154,
      3,
      NULL,
      2,
      3,
      12,
      NULL,
      3.429076,
      2,
      NULL,
      NULL,
      0,
      1.255370,
      1.506093,
      NULL,
      0,
      0,
      0.912813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      1,
      NULL,
      1.862899,
      NULL,
      1.694254,
      0.919525,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1.186375,
      1,
      NULL,
      1.431583,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.156600,
      NULL,
      NULL,
      2.635620,
      1,
      NULL,
      3,
      0.673123,
      1.383948,
      NULL,
      0.359064,
      2,
      NULL,
      NULL,
      0.852531,
      0,
      0,
      NULL,
      1,
      2.758433,
      9.172095,
      NULL,
      3.087792,
      0.352764,
      NULL,
      NULL,
      NULL,
      1.215783,
      173.343910,
      18.216859,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.619273,
      NULL,
      NULL,
      0,
      NULL,
      0.239813,
      51,
      2,
      1.070948,
      NULL,
      0,
      1.155096,
      1.372520,
      NULL,
      1,
      NULL,
      0.684393,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0.295755,
      1.423569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      3.912776,
      1,
      3.155476,
      2,
      15,
      1,
      1,
      3.858731,
      NULL,
      0,
      1.690818,
      2.665520,
      3.381708,
      3,
      2.938890,
      0,
      2.681251,
      0.955963,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.844723,
      3,
      0,
      0,
      2.603936,
      NULL,
      3.382799,
      0.469014,
      0.899690,
      1,
      NULL,
      0,
      NULL,
      2,
      1.565255,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445744,
      0,
      1.892317,
      0,
      0.675036,
      1,
      0,
      4,
      3,
      0,
      NULL,
      NULL,
      74,
      NULL,
      2,
      0.732075,
      1.589962,
      '34110',
      NULL,
      NULL,
      2.149209,
      NULL,
      '',
      NULL,
      1.312022,
      '32023',
      '',
      '');
commit;
end;
/


