set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678466';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24',
      '04',
      5.649916,
      NULL,
      '3041021',
      3,
      1.701680,
      1,
      1,
      '0200',
      0,
      0.496906,
      NULL,
      NULL,
      NULL,
      122,
      9.462192,
      NULL,
      0,
      1.518059,
      ' 5-16-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 7- 5-2003',
      ' 3-21-1997',
      3,
      3.849445,
      1,
      1.864068,
      NULL,
      3,
      3,
      1.922882,
      1.737922,
      2,
      2,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      4,
      1,
      5,
      1,
      0,
      NULL,
      1,
      1,
      4,
      0,
      1,
      1,
      0,
      0,
      2,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1.272712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      2,
      0.941813,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      1,
      4,
      NULL,
      NULL,
      0,
      7,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      2,
      0,
      0,
      5,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      3,
      0,
      2,
      1,
      5,
      3,
      NULL,
      NULL,
      NULL,
      4,
      4,
      NULL,
      5,
      0.447650,
      ' 6-14-2000',
      63.721236,
      ' 6-21-1987',
      84,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      3,
      0,
      3.907550,
      1.103085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.170739,
      0,
      NULL,
      1,
      1.769059,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.271283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394410,
      0.758601,
      1,
      1.281352,
      0,
      0,
      1,
      3,
      NULL,
      1,
      0.585878,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      0,
      2,
      1,
      1,
      3,
      0,
      0.138655,
      NULL,
      0,
      1.978628,
      1.598123,
      0,
      NULL,
      NULL,
      1,
      0,
      1.972617,
      0.978644,
      0,
      1,
      NULL,
      0,
      1.605652,
      0,
      0,
      11,
      NULL,
      NULL,
      9.199871,
      2,
      6.856815,
      NULL,
      0.956356,
      3,
      NULL,
      1.993755,
      0,
      44.761477,
      2,
      0,
      33,
      NULL,
      NULL,
      58.771762,
      0,
      4.264696,
      2,
      NULL,
      '33422',
      '',
      0,
      '',
      '',
      '',
      0.323879,
      '21100',
      '',
      NULL,
      1.397679,
      2,
      63.895718,
      43,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.601027,
      3.803114,
      1.201129,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      0.286460,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.524776,
      NULL,
      NULL,
      1.617533,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549046,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.208562,
      3,
      0.732692,
      1.804399,
      NULL,
      NULL,
      1.538072,
      NULL,
      NULL,
      0,
      3.048388,
      8.422494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085790,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.861604,
      0.664034,
      NULL,
      0,
      0.457119,
      NULL,
      NULL,
      NULL,
      1,
      0.719549,
      1,
      1.334333,
      3,
      NULL,
      2.978484,
      NULL,
      1.174109,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.649251,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.858842,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.120109,
      NULL,
      NULL,
      1.203614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786470,
      NULL,
      NULL,
      0.620756,
      NULL,
      NULL,
      3.846356,
      1.411720,
      0,
      3,
      1,
      0.670108,
      0.816908,
      NULL,
      NULL,
      2.898207,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      0,
      1,
      0.153133,
      1.599144,
      NULL,
      0.863944,
      0,
      1.843299,
      7.917188,
      NULL,
      0,
      1.585691,
      1,
      1,
      0.224713,
      1,
      NULL,
      0,
      0,
      0.220893,
      0.164522,
      0,
      1,
      NULL,
      NULL,
      0.846704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.639159,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481758,
      0.751634,
      0,
      NULL,
      1,
      2.906978,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.468364,
      NULL,
      NULL,
      NULL,
      2.696363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.781796,
      NULL,
      NULL,
      NULL,
      0.117196,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.290027,
      NULL,
      NULL,
      NULL,
      0.382817,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.347930,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.654672,
      1,
      8,
      0.272519,
      0.075477,
      1,
      0.470043,
      NULL,
      0.649675,
      1,
      NULL,
      NULL,
      1,
      0,
      1.686577,
      0,
      1.716122,
      0,
      0.018174,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.897683,
      0.441926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.052832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.650235,
      NULL,
      1.232324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.775089,
      NULL,
      1.777180,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.402230,
      2,
      2.820135,
      3.336242,
      NULL,
      202.263219,
      NULL,
      0,
      1,
      0.724203,
      1.904373,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2.130600,
      0.326249,
      0,
      2.104062,
      3,
      1,
      1.718064,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1.390003,
      NULL,
      1.890614,
      0.240630,
      NULL,
      1.556374,
      NULL,
      NULL,
      1.968461,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.521559,
      0.154519,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1.086909,
      NULL,
      1,
      1.209541,
      NULL,
      NULL,
      1.908914,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.049823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754187,
      NULL,
      0.071955,
      NULL,
      1.006240,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      0,
      0.695637,
      40,
      5,
      4,
      NULL,
      '04414',
      '24233',
      '',
      NULL,
      '',
      '',
      '',
      1.184083,
      '12334',
      '',
      '');
commit;
end;
/


