set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8205745';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1.160845,
      '220',
      '00240323',
      NULL,
      72,
      '3411223',
      NULL,
      NULL,
      4,
      0,
      '2431',
      5,
      0.694347,
      NULL,
      NULL,
      ' 4-18-1993',
      33,
      49.929756,
      NULL,
      2.546262,
      1,
      ' 1-10-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-29-1997',
      2.926103,
      1.410491,
      2,
      2.117043,
      NULL,
      0,
      0,
      NULL,
      1,
      7,
      2,
      10.289353,
      3.619848,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.573848,
      1,
      0,
      NULL,
      1,
      0.295633,
      1.446779,
      1.141278,
      2,
      1.987934,
      NULL,
      3,
      1,
      3,
      NULL,
      2,
      0,
      NULL,
      3,
      1,
      3,
      3,
      0,
      0,
      NULL,
      4,
      1,
      5.230664,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      2,
      1.519115,
      0,
      1,
      2,
      1.099983,
      NULL,
      NULL,
      1.237132,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      4,
      3,
      1,
      5.494568,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0,
      3,
      3,
      0,
      NULL,
      2,
      4,
      1,
      5,
      0,
      1,
      0,
      3,
      0,
      0,
      5,
      1,
      3,
      2,
      3,
      0,
      0,
      1.190314,
      ' 2-10-1989',
      942,
      NULL,
      39,
      0.638457,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.293948,
      4.001390,
      5.036155,
      5.714828,
      0.738697,
      1,
      NULL,
      NULL,
      1.841565,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.210521,
      NULL,
      0.035398,
      0,
      1,
      NULL,
      NULL,
      2.506803,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      0,
      3,
      2,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1,
      3.523038,
      0.942007,
      0,
      0.469533,
      1,
      NULL,
      1,
      0,
      0.630195,
      0.002157,
      0.460705,
      1,
      0.325483,
      1,
      1,
      1,
      3.673667,
      0,
      10.124602,
      1.286315,
      2,
      8,
      6.174278,
      5.922434,
      5.398827,
      NULL,
      1.776205,
      1.849375,
      2.275032,
      NULL,
      NULL,
      0,
      1.994889,
      51,
      NULL,
      NULL,
      NULL,
      4,
      3.803739,
      3,
      '24222',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      2,
      '0023',
      '',
      NULL,
      2,
      3,
      223,
      NULL,
      0.661620,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      1,
      NULL,
      NULL,
      1.049960,
      NULL,
      NULL,
      1.527965,
      NULL,
      NULL,
      1.949029,
      NULL,
      NULL,
      2.945134,
      3,
      1.899138,
      1.504712,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.529433,
      4.184490,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.743821,
      2,
      0.341845,
      1,
      NULL,
      NULL,
      0.240369,
      NULL,
      NULL,
      1.021982,
      NULL,
      NULL,
      0.017398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.035911,
      NULL,
      NULL,
      1.001907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.793328,
      1,
      1.167903,
      1,
      NULL,
      NULL,
      1.783487,
      NULL,
      NULL,
      5.500270,
      1.614667,
      5,
      0.321079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.006745,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.543351,
      NULL,
      NULL,
      0.293784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.058094,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.771176,
      1,
      1,
      1.919327,
      0,
      3.918911,
      1,
      2.538380,
      2.506611,
      2,
      4.901112,
      0.629559,
      5,
      3.737223,
      NULL,
      1,
      0.359243,
      NULL,
      NULL,
      0,
      1.155124,
      0.464370,
      1.512829,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.460359,
      2.165437,
      0.161940,
      1,
      1.309377,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.702948,
      NULL,
      NULL,
      NULL,
      2.968024,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.002474,
      NULL,
      NULL,
      NULL,
      5.508582,
      1.283357,
      NULL,
      NULL,
      NULL,
      3.328539,
      NULL,
      0,
      1,
      86.915483,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510068,
      NULL,
      NULL,
      1.755107,
      NULL,
      NULL,
      1,
      NULL,
      1.634293,
      14.208819,
      1,
      1.111128,
      0,
      1,
      NULL,
      NULL,
      0,
      1.077880,
      0,
      1.889356,
      1,
      1.797446,
      1.910454,
      1,
      0.406113,
      0.087803,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192713,
      0.660064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.731485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.743844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.285753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      2.127204,
      NULL,
      143,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      9,
      24.104470,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      3,
      NULL,
      1.931858,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.504266,
      NULL,
      0.405144,
      3.296713,
      3.072208,
      3,
      3.203861,
      2,
      3.319956,
      3,
      0.463356,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3,
      2.727125,
      NULL,
      1.358311,
      1,
      0,
      1.546808,
      2,
      3.075020,
      1,
      NULL,
      3,
      NULL,
      0.761686,
      1.789229,
      1.632559,
      NULL,
      0,
      1.609547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.358320,
      0,
      1.796873,
      1,
      0.489913,
      NULL,
      6,
      6,
      1,
      NULL,
      NULL,
      19.506122,
      110,
      3,
      2,
      0,
      '11112',
      '4330',
      '41110',
      1.145318,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


