set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9404807';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '3023314',
      3.677444,
      0,
      2,
      NULL,
      '4223',
      1,
      1,
      NULL,
      NULL,
      ' 4-27-1988',
      3.745766,
      NULL,
      NULL,
      3,
      1.840436,
      ' 5- 9-1988',
      NULL,
      2.897530,
      144,
      NULL,
      1,
      NULL,
      NULL,
      ' 4-19-1978',
      1.143939,
      2,
      NULL,
      2.632571,
      0.888743,
      2,
      1,
      2.270195,
      NULL,
      NULL,
      NULL,
      7.725590,
      NULL,
      NULL,
      NULL,
      1,
      7,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.032060,
      NULL,
      1,
      1,
      0,
      1,
      1.448799,
      NULL,
      0,
      5,
      3,
      2.723425,
      1,
      NULL,
      1,
      3,
      3,
      NULL,
      2,
      3,
      4,
      5,
      0,
      3,
      NULL,
      2,
      0,
      NULL,
      1,
      1.433173,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      6.839071,
      2.745674,
      NULL,
      0,
      1.896595,
      2.434499,
      0.793914,
      0,
      3,
      NULL,
      2.522769,
      1,
      0,
      1,
      1,
      3.195005,
      3.749267,
      NULL,
      0,
      0,
      4,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      1.475598,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      1.821455,
      1,
      0,
      0,
      3,
      2,
      NULL,
      4,
      3,
      NULL,
      3,
      2,
      1,
      2,
      NULL,
      3,
      3,
      NULL,
      2,
      NULL,
      5,
      4,
      0,
      5,
      NULL,
      2,
      NULL,
      2,
      ' 8- 9-1992',
      6,
      ' 7-18-1979',
      7.142759,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.720077,
      4.091260,
      0.920553,
      0,
      4.251759,
      0.075133,
      NULL,
      NULL,
      NULL,
      0,
      0.235067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266729,
      0,
      NULL,
      0,
      0.067786,
      1.450889,
      0.133718,
      0.851391,
      NULL,
      1.412308,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.277513,
      3,
      3,
      2,
      2,
      NULL,
      0,
      NULL,
      2,
      2,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.159756,
      1.203090,
      0.272841,
      NULL,
      1.642538,
      1.325090,
      1.437125,
      0,
      1,
      0.614927,
      1,
      0.744760,
      5,
      1.251458,
      10.081123,
      4,
      NULL,
      2,
      3,
      2.319768,
      0.939139,
      3,
      7.365116,
      1.375070,
      3,
      2.078248,
      3.481886,
      NULL,
      1.353044,
      NULL,
      NULL,
      30,
      42,
      1,
      0.075297,
      3,
      '33241',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.308943,
      NULL,
      '',
      '',
      NULL,
      8,
      0,
      0.884228,
      0.139001,
      33,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.942193,
      0.758659,
      NULL,
      NULL,
      0.371015,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0.789073,
      NULL,
      NULL,
      0.381790,
      NULL,
      NULL,
      1.287735,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.509099,
      6,
      1,
      0,
      1.739668,
      NULL,
      NULL,
      NULL,
      1.131971,
      NULL,
      NULL,
      NULL,
      0.893161,
      NULL,
      NULL,
      1.159358,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184728,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.037275,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      1.167634,
      0.375281,
      NULL,
      NULL,
      1.710676,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      8,
      NULL,
      1,
      2.600258,
      1,
      3.243889,
      2,
      1.132326,
      9.628323,
      0,
      0,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.507640,
      NULL,
      1,
      1.935525,
      0,
      2,
      NULL,
      NULL,
      1.154463,
      0,
      NULL,
      3,
      NULL,
      1.283192,
      0,
      1,
      1.255570,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520908,
      3.906517,
      7.746864,
      1,
      0,
      8.825565,
      1.374243,
      NULL,
      1,
      NULL,
      0,
      0.689268,
      1,
      1,
      1,
      0.396354,
      NULL,
      NULL,
      1.895449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.851427,
      NULL,
      NULL,
      1.662806,
      NULL,
      NULL,
      1.860534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247350,
      NULL,
      NULL,
      0.155642,
      NULL,
      0.986297,
      1,
      0,
      NULL,
      2.303081,
      NULL,
      NULL,
      0,
      1.434269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      1.992322,
      NULL,
      NULL,
      2,
      0.273311,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.331734,
      0.043220,
      NULL,
      NULL,
      NULL,
      0.671403,
      NULL,
      NULL,
      0.562612,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.320341,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.352624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409208,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      52.244557,
      5.862717,
      1.575849,
      1.336341,
      0,
      0.005201,
      1.261217,
      0,
      3,
      NULL,
      NULL,
      0.071575,
      0.365153,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      1.311601,
      1,
      1,
      2,
      1.685926,
      NULL,
      1,
      1.525318,
      NULL,
      0.803899,
      0.867187,
      NULL,
      1.391182,
      1,
      23.492139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.028267,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700903,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191976,
      0.310848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.568592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.977778,
      NULL,
      1.098983,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.438440,
      1.443673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.782299,
      NULL,
      1.401802,
      NULL,
      0.241368,
      NULL,
      NULL,
      NULL,
      1.279096,
      0.141144,
      2.969037,
      NULL,
      1,
      NULL,
      1.036511,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.842781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      0,
      0.299553,
      1,
      NULL,
      1,
      1.343490,
      3,
      NULL,
      1,
      NULL,
      1.144238,
      NULL,
      1,
      1.304411,
      0.423924,
      0.893886,
      0.300117,
      0.561651,
      NULL,
      1,
      1.089507,
      NULL,
      NULL,
      1.894262,
      1.505622,
      1.836238,
      1,
      NULL,
      NULL,
      0,
      0,
      0.364489,
      0,
      0.394927,
      NULL,
      1.981573,
      1.168779,
      1,
      1,
      0,
      NULL,
      1,
      2.164041,
      3.808853,
      0.284434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.701531,
      1,
      0,
      NULL,
      0.865499,
      NULL,
      NULL,
      43.003327,
      NULL,
      1,
      1.900804,
      1.626367,
      '44003',
      '14122',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


