set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '0130431',
      NULL,
      0,
      NULL,
      3,
      '2403',
      NULL,
      0,
      NULL,
      NULL,
      ' 3- 9-1991',
      NULL,
      NULL,
      2,
      NULL,
      0.706200,
      ' 5- 1-1975',
      27,
      0.737433,
      37,
      112,
      2,
      ' 8- 0-1993',
      ' 1-25-2000',
      ' 6-26-1987',
      3,
      0,
      1.444699,
      0.907708,
      1,
      1.061500,
      7,
      2.258785,
      NULL,
      NULL,
      NULL,
      6.627731,
      5.556495,
      10.296412,
      14,
      NULL,
      5.028851,
      3,
      0,
      1.908190,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      3,
      0,
      4.703078,
      1,
      0,
      0,
      2,
      1.402251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      0,
      1,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      1,
      1.333799,
      NULL,
      1.883623,
      3,
      3,
      1,
      0,
      1,
      5,
      2,
      NULL,
      5,
      2,
      1,
      0,
      3,
      1,
      2,
      5,
      0,
      2,
      NULL,
      2,
      0,
      5,
      1,
      NULL,
      1,
      NULL,
      3,
      ' 4-28-2003',
      101.527591,
      NULL,
      236.776463,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.648614,
      1.754776,
      0.344947,
      NULL,
      2,
      1,
      1.691501,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.716989,
      1.122780,
      0.827463,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.585834,
      2,
      0.181103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.534540,
      0.701738,
      0.008560,
      0.481341,
      NULL,
      1,
      1,
      1.979886,
      37,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.814137,
      2,
      0,
      2,
      3,
      NULL,
      0,
      2,
      0,
      NULL,
      2,
      2,
      3.463582,
      NULL,
      0.341973,
      1.929965,
      NULL,
      1.673855,
      1.383583,
      0.528532,
      NULL,
      NULL,
      1.395153,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      1.187109,
      0.935784,
      NULL,
      NULL,
      4.095094,
      7,
      4.154036,
      0.957217,
      1,
      NULL,
      1.138774,
      3.182593,
      NULL,
      63,
      3,
      3,
      NULL,
      35,
      21,
      70,
      0,
      1.110932,
      1.372321,
      '23202',
      '',
      '',
      0.575125,
      NULL,
      '',
      NULL,
      1.057034,
      '',
      NULL,
      '',
      3.016654,
      42.038457,
      3,
      1.199261,
      3,
      43,
      2.202066,
      7.394230,
      NULL,
      NULL,
      0,
      NULL,
      0.815386,
      NULL,
      NULL,
      1.963665,
      NULL,
      NULL,
      1.879419,
      NULL,
      NULL,
      1.400366,
      NULL,
      NULL,
      0,
      2.020088,
      2,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.622168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.346303,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.436107,
      NULL,
      NULL,
      0.399736,
      NULL,
      NULL,
      1.660471,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.786584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.957753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667689,
      1.800273,
      0,
      1,
      NULL,
      NULL,
      2,
      5,
      1.661565,
      3,
      2.644791,
      2.158761,
      NULL,
      NULL,
      NULL,
      0,
      5.297937,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.200446,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.341185,
      NULL,
      2.790239,
      2.513916,
      1,
      1.079430,
      2.615157,
      1,
      3,
      3.913990,
      0,
      2.234823,
      NULL,
      NULL,
      2.264023,
      2,
      2.357635,
      1.007699,
      1.862182,
      0.261712,
      NULL,
      0,
      NULL,
      4.932611,
      1,
      2.484354,
      0,
      3.759944,
      1,
      NULL,
      NULL,
      NULL,
      0.943908,
      2.471016,
      3.274716,
      1.078753,
      2.478366,
      NULL,
      NULL,
      3.288948,
      7,
      NULL,
      0,
      3.996218,
      3.687574,
      0,
      NULL,
      0,
      1,
      1.664236,
      0.727228,
      NULL,
      3.610413,
      NULL,
      NULL,
      0.799006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.817430,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.346547,
      NULL,
      NULL,
      1.826546,
      NULL,
      NULL,
      1.347938,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.679491,
      2,
      3,
      1,
      0.477952,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.886764,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.152447,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.600165,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201387,
      NULL,
      NULL,
      NULL,
      1.630207,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742532,
      6,
      NULL,
      3.656160,
      9.734460,
      NULL,
      0.754287,
      NULL,
      NULL,
      0.733596,
      NULL,
      NULL,
      0.469842,
      NULL,
      NULL,
      0.048709,
      NULL,
      NULL,
      1.771872,
      NULL,
      0.043330,
      1.886391,
      0.138077,
      0,
      1.240572,
      0,
      NULL,
      0,
      1.221860,
      1,
      0,
      NULL,
      0,
      1.330002,
      0,
      0.793073,
      1.206007,
      NULL,
      0.225111,
      0.275615,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      1.473225,
      NULL,
      NULL,
      3.032044,
      0,
      2.362591,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.764053,
      0.925465,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.786778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602272,
      NULL,
      0,
      1,
      NULL,
      0.900964,
      NULL,
      NULL,
      0.786997,
      2,
      NULL,
      1,
      1.325122,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.630376,
      0.922320,
      NULL,
      0.539247,
      NULL,
      NULL,
      NULL,
      2.622124,
      NULL,
      NULL,
      NULL,
      1.583176,
      NULL,
      0.723488,
      NULL,
      NULL,
      NULL,
      3.119625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.073215,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1.763847,
      NULL,
      NULL,
      NULL,
      1.878574,
      NULL,
      2,
      3,
      6,
      0,
      NULL,
      NULL,
      36,
      NULL,
      NULL,
      1.085377,
      0,
      '30001',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


