set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '4004322',
      3,
      0.296945,
      NULL,
      1,
      '2401',
      0,
      NULL,
      NULL,
      NULL,
      ' 7- 9-1980',
      NULL,
      NULL,
      1,
      1.247583,
      3,
      ' 6-14-1978',
      35.069354,
      NULL,
      156.202247,
      46.775411,
      1,
      ' 5-27-2003',
      ' 1-14-1993',
      ' 2-18-1993',
      1.591124,
      1.314778,
      0.048924,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      4,
      11,
      0,
      0,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      2,
      NULL,
      2,
      0,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3.550351,
      NULL,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      0.598753,
      NULL,
      NULL,
      3,
      0,
      1,
      1.776635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      1,
      0,
      0,
      1.494508,
      1.860436,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      1.749289,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      3,
      NULL,
      3,
      0,
      2,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      5,
      0,
      1,
      1,
      NULL,
      4,
      2,
      5,
      5,
      0,
      3,
      ' 8-21-2003',
      326.358629,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      2.659734,
      1.010723,
      5,
      1.579173,
      3,
      1,
      NULL,
      3.483528,
      NULL,
      0,
      3,
      2.239416,
      1.600135,
      1.946442,
      4.296457,
      1,
      3,
      2,
      1.623041,
      0.540421,
      NULL,
      NULL,
      NULL,
      NULL,
      0.052907,
      0,
      0.885227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.498461,
      0.255226,
      1,
      1.021259,
      1.845602,
      1,
      1.671001,
      NULL,
      NULL,
      0,
      1.997559,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2,
      2,
      3.751181,
      NULL,
      0,
      0.944182,
      0,
      0,
      0.117604,
      NULL,
      0.302228,
      0,
      1.603731,
      0.456095,
      1,
      1.323012,
      1.371882,
      0,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      26,
      NULL,
      5,
      1.028680,
      3,
      '31234',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.205624,
      '',
      '',
      NULL,
      0.178297,
      44.096222,
      107.932905,
      0.726110,
      3.034980,
      31.463194,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.758264,
      NULL,
      NULL,
      3.974751,
      0.648861,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.429811,
      0.682086,
      0.658078,
      NULL,
      NULL,
      0.056559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.256539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.086638,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941932,
      NULL,
      NULL,
      NULL,
      0.759655,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.622316,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.571665,
      0.282655,
      1.141186,
      0.099762,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.989028,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.022754,
      5.086029,
      1,
      NULL,
      NULL,
      NULL,
      1.152528,
      0,
      0,
      2.702470,
      0,
      0,
      2,
      NULL,
      0.061910,
      7,
      5,
      0,
      0,
      3,
      NULL,
      7.773727,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.140869,
      2,
      NULL,
      NULL,
      4.355967,
      0.378392,
      0,
      NULL,
      NULL,
      0,
      1,
      3,
      1.628555,
      0,
      1.361801,
      1,
      0.527792,
      3,
      NULL,
      NULL,
      0.263367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533331,
      NULL,
      NULL,
      1.368994,
      NULL,
      NULL,
      0.772430,
      NULL,
      1.717917,
      1.324372,
      NULL,
      2.784143,
      0,
      NULL,
      NULL,
      2.526017,
      2.240554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.826079,
      NULL,
      NULL,
      0.417630,
      1.690456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486591,
      3,
      NULL,
      NULL,
      1,
      0.878094,
      NULL,
      NULL,
      1.741571,
      1,
      NULL,
      NULL,
      1,
      0.697428,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.211892,
      0,
      NULL,
      NULL,
      0.035765,
      1.712080,
      NULL,
      NULL,
      1.268680,
      1,
      NULL,
      NULL,
      1.021494,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2,
      0.815759,
      NULL,
      NULL,
      1.831334,
      2.760692,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      1.541090,
      NULL,
      NULL,
      NULL,
      0,
      16.710359,
      NULL,
      2.784281,
      3.788762,
      NULL,
      0.132328,
      NULL,
      NULL,
      1.491159,
      NULL,
      NULL,
      1.697927,
      1035.259372,
      NULL,
      0.676125,
      NULL,
      NULL,
      1.415222,
      NULL,
      1.686109,
      0,
      1.125933,
      1.954652,
      0,
      NULL,
      1.550869,
      0,
      0,
      1,
      0,
      1,
      0.779077,
      NULL,
      0,
      0.486591,
      0.008234,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      1.964709,
      2,
      0,
      0,
      NULL,
      2,
      2.258064,
      0.278903,
      0.501348,
      0.129105,
      0,
      0,
      1.468816,
      NULL,
      1,
      0.231832,
      1,
      NULL,
      2.051616,
      2.447570,
      3,
      3.383462,
      0,
      0,
      NULL,
      1.589222,
      0,
      2,
      1.327474,
      1,
      1.119720,
      NULL,
      0,
      0.373045,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.851577,
      0.361531,
      3,
      3,
      1.469095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.347712,
      NULL,
      1.030234,
      NULL,
      0,
      NULL,
      0.901157,
      NULL,
      1.574501,
      NULL,
      0.880275,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.710692,
      NULL,
      NULL,
      15.461318,
      1.927800,
      NULL,
      0.760433,
      1.253136,
      0.036920,
      1,
      1.082698,
      0,
      NULL,
      5,
      2,
      1.425584,
      NULL,
      NULL,
      69.482940,
      95,
      NULL,
      1.922224,
      0,
      '40313',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


