set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '4312323',
      2.573846,
      1,
      NULL,
      NULL,
      '1444',
      3,
      NULL,
      NULL,
      NULL,
      ' 9-19-1986',
      1,
      NULL,
      4,
      3.478155,
      0,
      NULL,
      11.021558,
      2.148593,
      302.608624,
      7.693771,
      NULL,
      ' 9- 6-1975',
      '10-29-2002',
      ' 1-16-1994',
      0,
      NULL,
      3,
      NULL,
      1.606371,
      2.014031,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6.005135,
      22.230084,
      13.392572,
      1,
      9,
      NULL,
      NULL,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      2,
      4,
      0,
      2,
      3,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      4,
      1,
      4,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      5.239612,
      1,
      1,
      0.349854,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      2,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      5.509039,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      4,
      NULL,
      0,
      5,
      1,
      5,
      1,
      1,
      3,
      2,
      0,
      0,
      0,
      1,
      3,
      NULL,
      0,
      NULL,
      3,
      3,
      4,
      5,
      3,
      4,
      3,
      6,
      3,
      ' 8-29-1988',
      520.555661,
      ' 9-21-2002',
      26,
      3,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6.176659,
      3,
      0.530657,
      1,
      1.153844,
      0.247141,
      1,
      1,
      0,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4.072794,
      1,
      4,
      3.006564,
      3.430084,
      5,
      5,
      0,
      NULL,
      NULL,
      0.688224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.501856,
      1.195889,
      0.446959,
      0.124585,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.436837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.249346,
      0,
      2,
      NULL,
      0,
      2,
      0,
      1,
      3,
      NULL,
      2,
      NULL,
      1,
      0.797802,
      0.221533,
      0,
      NULL,
      1.596456,
      0.552791,
      NULL,
      0.712494,
      0,
      1,
      0.588593,
      0,
      0,
      0,
      1.029494,
      3.351980,
      0.804718,
      5,
      5.616908,
      1,
      NULL,
      1,
      3.088353,
      2.651356,
      NULL,
      6.061347,
      3.406492,
      2.248108,
      1,
      48.810982,
      0,
      3,
      NULL,
      NULL,
      43,
      73.440748,
      0,
      1.715705,
      2.506834,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      22,
      53.484136,
      0.091066,
      1,
      34.740764,
      0,
      6,
      3,
      0,
      3.618272,
      0,
      1.021432,
      NULL,
      NULL,
      2,
      3,
      0.388866,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.481960,
      1.077959,
      3,
      NULL,
      3,
      1.118847,
      1.338863,
      NULL,
      1.390337,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067892,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.582715,
      9.164414,
      0.865238,
      1,
      0.513228,
      NULL,
      NULL,
      NULL,
      0.009092,
      NULL,
      NULL,
      NULL,
      1.841138,
      NULL,
      NULL,
      1.366476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.551106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881087,
      NULL,
      NULL,
      1,
      3,
      1,
      3,
      NULL,
      1.274908,
      1,
      NULL,
      NULL,
      6,
      3.437627,
      0.235355,
      2,
      0.015998,
      3,
      2.602970,
      NULL,
      NULL,
      3.056969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.012313,
      1,
      2,
      0.293193,
      2,
      1.381416,
      4,
      1,
      1.340347,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.295015,
      1,
      3.667662,
      NULL,
      1.876851,
      1,
      NULL,
      0,
      NULL,
      7,
      0.840001,
      1.102036,
      NULL,
      NULL,
      3,
      3,
      1.785191,
      2,
      2.363900,
      NULL,
      2,
      3,
      2.469566,
      2,
      2,
      2,
      NULL,
      7.811146,
      NULL,
      0,
      2,
      2,
      0,
      0.087705,
      1,
      0.541973,
      0,
      0.887134,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308199,
      NULL,
      NULL,
      1.300869,
      NULL,
      NULL,
      0.865764,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.233709,
      NULL,
      0,
      NULL,
      1,
      2.927991,
      0.227366,
      NULL,
      NULL,
      NULL,
      1.456878,
      NULL,
      NULL,
      6,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.914483,
      0,
      NULL,
      NULL,
      0.072470,
      2,
      NULL,
      NULL,
      0.914960,
      0.017120,
      NULL,
      NULL,
      2.582036,
      1.367030,
      NULL,
      NULL,
      1,
      0.879391,
      NULL,
      NULL,
      2.082044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.477281,
      NULL,
      NULL,
      2.206743,
      1,
      NULL,
      NULL,
      NULL,
      0.598829,
      NULL,
      NULL,
      8.242438,
      3,
      NULL,
      NULL,
      1.719953,
      NULL,
      NULL,
      NULL,
      0,
      12,
      3,
      0,
      2,
      3.509703,
      0.326205,
      NULL,
      NULL,
      0,
      4.010140,
      4.515362,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.525260,
      1.061708,
      1,
      1.263715,
      0.099955,
      1.684485,
      NULL,
      NULL,
      1.943443,
      1,
      NULL,
      0,
      1,
      1.203062,
      1,
      1,
      1,
      0.930444,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.517150,
      2.500776,
      1,
      0.392533,
      0,
      4,
      3,
      0.995795,
      NULL,
      0.454595,
      0,
      0.748915,
      NULL,
      1,
      0,
      1.392896,
      NULL,
      0,
      0.387215,
      2,
      1,
      2,
      0.171786,
      3,
      1.935478,
      3,
      NULL,
      0.603782,
      1.009155,
      1,
      1,
      3,
      3,
      1,
      0,
      1,
      1,
      1,
      0,
      1.877859,
      0.403334,
      0,
      2,
      3.481930,
      0.210882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.895473,
      2,
      0,
      0,
      0,
      NULL,
      0,
      3.998905,
      1.622884,
      NULL,
      NULL,
      NULL,
      2,
      1.061486,
      1.607523,
      3.407295,
      0,
      0,
      1,
      0,
      0.759819,
      2.401697,
      1,
      NULL,
      NULL,
      1.921074,
      NULL,
      NULL,
      0,
      4,
      0,
      NULL,
      1,
      0.557188,
      0.054740,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      74.344255,
      87,
      5,
      0.923082,
      NULL,
      '01204',
      '',
      NULL,
      1.502071,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


