set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      0,
      NULL,
      0.165203,
      0.594892,
      NULL,
      NULL,
      ' 3-16-2002',
      21.827082,
      NULL,
      1,
      1,
      10.899566,
      ' 8-15-1999',
      18.858933,
      3.790144,
      322.978164,
      167,
      NULL,
      NULL,
      ' 2-12-1993',
      ' 6- 2-1977',
      3,
      1.528278,
      3,
      1.626729,
      NULL,
      1.626618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      18.376364,
      18.743870,
      1,
      8,
      2,
      NULL,
      0,
      0.199927,
      1,
      2,
      0.381354,
      1,
      0,
      0,
      0.077547,
      1,
      NULL,
      1.021039,
      NULL,
      NULL,
      0,
      0.619831,
      2,
      NULL,
      3,
      0,
      2,
      0,
      2,
      3,
      NULL,
      1,
      5,
      1,
      2,
      0,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      0.686751,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.042629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.150541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      3,
      2,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      4,
      0,
      NULL,
      0,
      1,
      0,
      2,
      0,
      NULL,
      1.026932,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      4,
      3,
      5,
      1,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      2,
      5,
      1,
      5,
      5,
      NULL,
      3,
      2,
      3,
      '10-13-1997',
      0.335275,
      ' 4-25-1977',
      6.648934,
      1.871648,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0.142906,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      0.291343,
      2.958212,
      0,
      3,
      1.947355,
      2,
      NULL,
      0,
      6.968584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.949538,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470163,
      3.824763,
      1.972888,
      1,
      1,
      0.589156,
      0,
      3,
      31.602443,
      3.315984,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      2,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0.172537,
      0.097009,
      1,
      NULL,
      0,
      5.344494,
      0.693716,
      1.615939,
      NULL,
      1.140398,
      1.434841,
      1,
      1.134477,
      1,
      0,
      3,
      2.369170,
      0.610997,
      4.731225,
      0.216567,
      3.121026,
      6.552496,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      3.560706,
      1.461657,
      29,
      3,
      2,
      NULL,
      6,
      22,
      60.162027,
      2,
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      54.174431,
      7,
      5.503090,
      0.730678,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.208386,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.072554,
      3,
      NULL,
      1.028549,
      2.288586,
      1.077886,
      0.740520,
      NULL,
      NULL,
      0,
      1.586707,
      0,
      3.881666,
      3.777539,
      0,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      2.011634,
      2.317097,
      1,
      3.951305,
      2.631008,
      1.678626,
      1.526621,
      1,
      1.147722,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961097,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895998,
      NULL,
      NULL,
      0.294366,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.809892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.642184,
      0,
      NULL,
      NULL,
      0.488631,
      NULL,
      NULL,
      3,
      0.644210,
      1.217966,
      3,
      0.819911,
      NULL,
      2,
      1.808887,
      1.012345,
      3.490539,
      3,
      NULL,
      1.290494,
      NULL,
      NULL,
      0.838379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.204588,
      NULL,
      NULL,
      0.629806,
      NULL,
      NULL,
      3,
      1.623356,
      1,
      0.582478,
      NULL,
      NULL,
      NULL,
      7,
      0.591263,
      0,
      NULL,
      1.867343,
      2.234243,
      NULL,
      NULL,
      3.349141,
      NULL,
      0,
      3.346117,
      3,
      1.777533,
      NULL,
      3,
      0.048293,
      4.268416,
      2,
      0,
      NULL,
      3,
      0.317433,
      2.397251,
      NULL,
      0.054471,
      2.891597,
      1.745650,
      0,
      NULL,
      1.826115,
      1,
      5.619026,
      1,
      0,
      2.792405,
      NULL,
      0,
      3,
      3,
      3,
      1,
      0.565948,
      1.008497,
      0.828822,
      1.578816,
      0.885977,
      NULL,
      NULL,
      0.641934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.697724,
      NULL,
      NULL,
      0.115166,
      NULL,
      NULL,
      0.839930,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.369837,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.665950,
      NULL,
      NULL,
      1,
      NULL,
      1.418297,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      2.289677,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966787,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.325546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.150059,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.281004,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.357302,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.393538,
      1.537407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288479,
      NULL,
      NULL,
      NULL,
      3.091429,
      NULL,
      NULL,
      NULL,
      1.456760,
      1.037615,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.861939,
      309,
      46,
      0.842804,
      0.889473,
      0.248210,
      0,
      0.525392,
      0.518092,
      NULL,
      1,
      1.668472,
      0.890965,
      0,
      1.445822,
      NULL,
      1,
      0.001061,
      0,
      1.708376,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.562647,
      NULL,
      NULL,
      2,
      3,
      7.858141,
      1,
      3,
      NULL,
      1,
      1,
      0,
      0,
      3.889055,
      1,
      1.461466,
      NULL,
      0.161109,
      0,
      NULL,
      1.502371,
      1.073257,
      1,
      0,
      0.568627,
      1.805658,
      NULL,
      0.624372,
      2.934943,
      NULL,
      0,
      3.051212,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1.980603,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554010,
      0.115436,
      NULL,
      0,
      1,
      3,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311778,
      1,
      '01400',
      '',
      '',
      1.289558,
      '',
      '',
      '',
      1.796169,
      '',
      '',
      '');
commit;
end;
/


