set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8335020';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '4030230',
      3.882470,
      1.254200,
      0,
      2,
      '4241',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 9-1983',
      26.345177,
      NULL,
      3,
      2,
      1,
      ' 1- 6-1976',
      22,
      0,
      145.441903,
      125.844357,
      0,
      ' 3-17-1999',
      ' 7-18-1990',
      NULL,
      2.392390,
      1,
      1,
      NULL,
      0.569167,
      2.935629,
      1,
      1,
      1.681202,
      55.854605,
      NULL,
      NULL,
      0,
      13.975390,
      1,
      4,
      NULL,
      4,
      2,
      6.105819,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.401916,
      0,
      0,
      0.934337,
      134.795660,
      NULL,
      3,
      1,
      3.253507,
      3,
      1,
      NULL,
      5,
      4,
      4,
      0,
      1,
      5,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.148094,
      1,
      2,
      NULL,
      1,
      1.024792,
      3.359176,
      0,
      1,
      NULL,
      1,
      0,
      2.919837,
      NULL,
      1.733432,
      1.910047,
      0.992389,
      0,
      3.285372,
      0.087327,
      NULL,
      3,
      2,
      0,
      4,
      5.203007,
      1,
      NULL,
      0,
      1.849579,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      0,
      0,
      1,
      3,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      4,
      0,
      3,
      NULL,
      4,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      0,
      0,
      2,
      4,
      3,
      3,
      3,
      3,
      NULL,
      3,
      NULL,
      517,
      '10- 3-1980',
      NULL,
      1.099434,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      2,
      1,
      1.297374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.788530,
      0.177860,
      0.823492,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      2.509173,
      6,
      1.991162,
      11,
      1.320285,
      NULL,
      NULL,
      0.956860,
      NULL,
      NULL,
      NULL,
      2.070222,
      9.546205,
      0.282826,
      0,
      1,
      1,
      4,
      '10-26-1990',
      188,
      ' 3-11-2003',
      NULL,
      1.972058,
      1,
      1,
      1.363192,
      NULL,
      0,
      3,
      0.364676,
      0,
      1.661067,
      1.343150,
      150.218238,
      1.771099,
      0.488044,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      1,
      2,
      1,
      0,
      2,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3,
      0.338365,
      0,
      3.618663,
      0,
      NULL,
      1,
      0,
      1.342447,
      0,
      0.040558,
      NULL,
      0,
      NULL,
      3.763668,
      NULL,
      5,
      NULL,
      6,
      4.785758,
      4.674624,
      0.125676,
      NULL,
      0,
      NULL,
      3.081684,
      0,
      1.219604,
      40.481964,
      0,
      2.407027,
      NULL,
      NULL,
      27,
      37.260052,
      NULL,
      0,
      2.311169,
      '41301',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.656947,
      30.259780,
      2,
      11.765559,
      0,
      30,
      5,
      NULL,
      4,
      2.478590,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.743359,
      NULL,
      0,
      3.940691,
      1.880119,
      1.086516,
      0,
      0,
      1,
      1,
      1.084767,
      0.011304,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.975369,
      NULL,
      1.796166,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.502977,
      1,
      0.634356,
      8,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.481275,
      3.308588,
      1,
      0.849284,
      NULL,
      3.422775,
      3,
      2.883755,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.269439,
      2,
      2.236687,
      1,
      1.974693,
      NULL,
      1.943688,
      2,
      NULL,
      1,
      1,
      1,
      1.245281,
      1.791404,
      0.637464,
      NULL,
      NULL,
      NULL,
      3.054560,
      1,
      9,
      3.752302,
      2.722966,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.022688,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.173851,
      NULL,
      NULL,
      NULL,
      2,
      1.919059,
      7.373443,
      4.928435,
      0,
      1.595486,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435073,
      NULL,
      NULL,
      0,
      2.176381,
      0.956558,
      NULL,
      3,
      NULL,
      3.506432,
      6,
      5.541263,
      3,
      3.015136,
      5,
      1,
      NULL,
      NULL,
      0.919124,
      3,
      0,
      0.190099,
      2.897122,
      0.078274,
      1.759102,
      2.303635,
      3,
      7,
      1.111138,
      6.137734,
      3,
      NULL,
      2.365316,
      NULL,
      2.312640,
      1,
      1,
      NULL,
      1,
      1.020914,
      0.857688,
      3.967409,
      NULL,
      7.513107,
      8.237850,
      9,
      3,
      4,
      3,
      3,
      NULL,
      0.926353,
      NULL,
      0.003010,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.067462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533122,
      NULL,
      NULL,
      3.477213,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      2,
      3,
      3.590746,
      3,
      NULL,
      0,
      8,
      NULL,
      1.947145,
      NULL,
      625.205689,
      289,
      NULL,
      NULL,
      1.921432,
      2,
      NULL,
      NULL,
      1.927315,
      3.948014,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0.563354,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.000652,
      1.031484,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      0.171465,
      1.578701,
      0,
      NULL,
      0.324123,
      NULL,
      0,
      NULL,
      NULL,
      3.462547,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.117118,
      1.416575,
      NULL,
      3,
      3.040020,
      0.435469,
      NULL,
      12.664453,
      2,
      1,
      NULL,
      0.497929,
      0,
      NULL,
      2.575711,
      NULL,
      0,
      0,
      118.353950,
      0,
      0,
      25.682823,
      1.253487,
      NULL,
      11.183943,
      2,
      2,
      1.417923,
      1.788707,
      1,
      23.855622,
      12,
      1.357839,
      NULL,
      NULL,
      0,
      23.477838,
      0,
      125,
      NULL,
      0.461318,
      NULL,
      NULL,
      1.851028,
      1.402469,
      1,
      0.194751,
      NULL,
      0.707986,
      0,
      0.687090,
      1.654672,
      1,
      1,
      NULL,
      1.081424,
      0.716849,
      1.513097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936730,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718253,
      1.023861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.100622,
      NULL,
      0.013374,
      0,
      0.432842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576390,
      0.271090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092774,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      9.324977,
      NULL,
      1,
      0.699254,
      0,
      3.812648,
      1,
      0.665520,
      NULL,
      NULL,
      1.017542,
      NULL,
      0,
      2,
      NULL,
      1.168754,
      0.390512,
      NULL,
      0,
      1,
      NULL,
      3.210397,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0.656315,
      NULL,
      2.832855,
      2.141433,
      NULL,
      1,
      0.229637,
      NULL,
      1,
      NULL,
      NULL,
      1.447024,
      0,
      NULL,
      3.860196,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440984,
      0,
      NULL,
      NULL,
      NULL,
      3.365213,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.461018,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.015282,
      NULL,
      3,
      NULL,
      0.387741,
      NULL,
      0,
      NULL,
      33,
      0,
      NULL,
      0.105291,
      NULL,
      0.448956,
      NULL,
      1,
      NULL,
      2,
      NULL,
      6,
      0.305385,
      0.502429,
      0.110976,
      1,
      65.529186,
      4,
      0,
      3,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


