set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9522082';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-8-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '0341221',
      1,
      NULL,
      NULL,
      3,
      '2022',
      3.455446,
      1,
      NULL,
      NULL,
      ' 7-22-2003',
      136.371096,
      NULL,
      3,
      3.453106,
      11,
      ' 7- 3-1991',
      35.199421,
      NULL,
      NULL,
      43,
      2,
      NULL,
      NULL,
      NULL,
      0.380257,
      0.765253,
      3.139223,
      1.075186,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      9.101248,
      5,
      NULL,
      2.960219,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      1.516156,
      NULL,
      0,
      1,
      0.699132,
      NULL,
      3,
      2,
      1.894994,
      1,
      0,
      0,
      3,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      6.167112,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.240221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1.086596,
      NULL,
      1,
      NULL,
      0,
      1.844562,
      NULL,
      0.293975,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      5,
      4,
      1,
      0,
      1,
      2,
      1,
      0,
      5,
      5,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2.071924,
      0,
      '10- 4-1976',
      106.522214,
      NULL,
      4,
      1.793938,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      1,
      0,
      2,
      0.284967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.725422,
      1,
      0.304127,
      1.572413,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.895861,
      0.940199,
      1,
      0.407323,
      0,
      1,
      17,
      1.279796,
      0.066150,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      2,
      3,
      NULL,
      2,
      3,
      3,
      NULL,
      1,
      2,
      2,
      2.019266,
      3.182499,
      NULL,
      3.885743,
      1.695348,
      NULL,
      0,
      0,
      1,
      0,
      0.688470,
      1.539237,
      1,
      NULL,
      1,
      0,
      2.326138,
      0.369369,
      0,
      0.918082,
      0,
      5,
      NULL,
      1,
      5,
      NULL,
      1,
      1,
      NULL,
      NULL,
      11,
      1,
      0.973801,
      NULL,
      7,
      22,
      9.339954,
      5,
      5,
      NULL,
      '12321',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.399789,
      2,
      17,
      NULL,
      0.418595,
      NULL,
      NULL,
      NULL,
      NULL,
      3.145219,
      NULL,
      NULL,
      1.826251,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.248757,
      0.189988,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.018028,
      0.348859,
      1.838183,
      1.277100,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.411774,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.229626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806384,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      0.603287,
      2.413360,
      2.756179,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.807181,
      2,
      1.935393,
      3.986129,
      NULL,
      3.243548,
      0,
      NULL,
      1.894062,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.155578,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.484280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.328602,
      1,
      2.268789,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475301,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.358451,
      NULL,
      NULL,
      1.807806,
      NULL,
      NULL,
      1.281756,
      NULL,
      NULL,
      0.367727,
      NULL,
      NULL,
      5.342361,
      0.478976,
      NULL,
      0,
      NULL,
      NULL,
      1.667193,
      0,
      0,
      1.470144,
      0.757462,
      1.769795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.283554,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625266,
      NULL,
      NULL,
      NULL,
      3.755296,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.633617,
      NULL,
      NULL,
      0.348065,
      NULL,
      NULL,
      0,
      NULL,
      0,
      494.975018,
      12,
      1.958654,
      1,
      1,
      1,
      NULL,
      1.718777,
      0,
      1.330311,
      0,
      0.925520,
      1.692165,
      NULL,
      0,
      NULL,
      0.715801,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.186690,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.707992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.028623,
      NULL,
      NULL,
      NULL,
      0.773590,
      NULL,
      1.811173,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.750634,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.079835,
      NULL,
      0.714616,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.037110,
      3.943928,
      0.703092,
      0,
      1,
      0,
      NULL,
      1,
      1.977531,
      3,
      NULL,
      1,
      0.510507,
      NULL,
      0,
      2.136759,
      NULL,
      1,
      1,
      NULL,
      1.440707,
      NULL,
      NULL,
      0.191430,
      NULL,
      NULL,
      1.600028,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.469260,
      0.163997,
      NULL,
      0,
      1.901544,
      NULL,
      NULL,
      NULL,
      1.501182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.744822,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      5,
      0,
      NULL,
      NULL,
      87,
      72.422969,
      1,
      NULL,
      NULL,
      '40031',
      '',
      '',
      1.320760,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


